<?php

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

use Enum\PageSite;
use Classe\NavBar;
use Classe\Login;
use Views\VariousViewsHtml;
use Views\VisiteurVariousViewsHtml;

// Définir le répertoire racine du projet
$rootDir = dirname(__DIR__);
chdir($rootDir);

$installDontExists = false;
$userConnected = false;

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Récupérer le nom du projet depuis le chemin
$directory = new DirectoryIterator($rootDir);
$path = explode(DIRECTORY_SEPARATOR, $directory->getPath());
$path = $path[count($path) - 1];

// Définir les chemins des fichiers
$installFolder = $rootDir . DIRECTORY_SEPARATOR . 'install';
$configFile = $rootDir . DIRECTORY_SEPARATOR . 'config.php';

// Inclusions essentielles
$paramFile = $rootDir . "/Parametre/" . $path . "/" . $path . ".php";
$loadDirFile = $rootDir . "/Parametre/" . $path . "/LoadDirClass.php";
$dbConnectFile = $rootDir . "/Parametre/" . $path . "/dbConnect.php";
$functionFile = $rootDir . "/Classe/FunctionClasse.php";

if (file_exists($paramFile)) {
    include $paramFile;
} else {
    die("Erreur: Fichier de paramètres manquant");
}

if (file_exists($loadDirFile)) {
    include $loadDirFile;
} else {
    die("Erreur: Fichier LoadDirClass manquant");
}

if (file_exists($dbConnectFile)) {
    include $dbConnectFile;
} else {
    die("Erreur: Fichier dbConnect manquant");
}

if (file_exists($functionFile)) {
    include_once $functionFile;
} else {
    die("Erreur: Fichier FunctionClasse manquant");
}

// Fonction pour afficher la page d'inscription
function showRegisterPage() {
    ?>
    <!DOCTYPE html>
    <html lang="fr">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Taghilt - Créer un Compte</title>
        
        <!-- Bootstrap CSS -->
        <link href="assets/vendor/bootstrap-5.3.3/css/bootstrap.min.css" rel="stylesheet">
        <!-- Font Awesome -->
        <link href="assets/vendor/fontawesome-6.4.0-all.min.css" rel="stylesheet">
        
        <style>
            body {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            }
            
            .register-container {
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            
            .register-card {
                background: rgba(255, 255, 255, 0.95);
                backdrop-filter: blur(10px);
                border-radius: 20px;
                box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
                border: 1px solid rgba(255, 255, 255, 0.2);
                overflow: hidden;
                max-width: 600px;
                width: 100%;
                padding: 3rem;
            }
            
            .brand-logo {
                width: 80px;
                height: 80px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 20px;
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto 2rem;
            }
            
            .form-floating label {
                color: #666;
            }
            
            .form-control {
                border-radius: 12px;
                border: 2px solid #e9ecef;
                padding: 0.75rem 1rem;
                transition: all 0.3s ease;
            }
            
            .form-control:focus {
                border-color: #667eea;
                box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
            }
            
            .btn-register {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border: none;
                border-radius: 12px;
                padding: 0.75rem 2rem;
                font-weight: 600;
                text-transform: uppercase;
                letter-spacing: 1px;
                transition: all 0.3s ease;
            }
            
            .btn-register:hover {
                transform: translateY(-2px);
                box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
            }
            
            .btn-back {
                background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
                border: none;
                border-radius: 12px;
                padding: 0.75rem 2rem;
                color: white;
                text-decoration: none;
                transition: all 0.3s ease;
            }
            
            .btn-back:hover {
                transform: translateY(-2px);
                color: white;
                text-decoration: none;
            }
            
            .feature-list {
                background: rgba(102, 126, 234, 0.1);
                border-radius: 12px;
                padding: 1.5rem;
                margin: 1rem 0;
            }
            
            .feature-item {
                display: flex;
                align-items: center;
                margin-bottom: 0.75rem;
            }
            
            .feature-item:last-child {
                margin-bottom: 0;
            }
            
            .feature-icon {
                width: 40px;
                height: 40px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 8px;
                display: flex;
                align-items: center;
                justify-content: center;
                margin-right: 1rem;
                color: white;
            }
        </style>
    </head>
    <body>
        <div class="register-container">
            <div class="register-card">
                <div class="text-center">
                    <div class="brand-logo">
                        <i class="fas fa-home fa-2x text-white"></i>
                    </div>
                    
                    <h2 class="fw-bold mb-2">Rejoignez Taghilt</h2>
                    <p class="text-muted mb-4">Créez votre compte et commencez à vendre</p>
                </div>

                <!-- Avantages -->
                <div class="feature-list">
                    <h6 class="fw-bold mb-3 text-center">
                        <i class="fas fa-star text-warning me-2"></i>
                        Avec votre compte Taghilt :
                    </h6>
                    
                    <div class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-plus"></i>
                        </div>
                        <div>
                            <strong>Publiez vos annonces</strong><br>
                            <small class="text-muted">Maisons, appartements, terrains...</small>
                        </div>
                    </div>
                    
                    <div class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <div>
                            <strong>Gérez vos ventes</strong><br>
                            <small class="text-muted">Suivi des visites et négociations</small>
                        </div>
                    </div>
                    
                    <div class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <div>
                            <strong>Contactez les acheteurs</strong><br>
                            <small class="text-muted">Messagerie intégrée sécurisée</small>
                        </div>
                    </div>
                </div>

                <!-- Message d'alerte -->
                <div id="registerAlert" class="alert d-none mt-3" role="alert"></div>
                
                <!-- Indicateur de chargement -->
                <div id="registerLoading" class="text-center mt-3 d-none">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Création du compte...</span>
                    </div>
                    <p class="mt-2 text-muted">Création de votre compte en cours...</p>
                </div>

                <!-- Formulaire d'inscription -->
                <form id="registerForm" class="needs-validation" novalidate>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="prenom" name="prenom" placeholder="Prénom" required>
                                <label for="prenom"><i class="fas fa-user me-2"></i>Prénom</label>
                                <div class="invalid-feedback">
                                    Veuillez saisir votre prénom.
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="nom" name="nom" placeholder="Nom" required>
                                <label for="nom"><i class="fas fa-user me-2"></i>Nom</label>
                                <div class="invalid-feedback">
                                    Veuillez saisir votre nom.
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-floating mb-3">
                        <input type="email" class="form-control" id="email" name="email" placeholder="Email" required>
                        <label for="email"><i class="fas fa-envelope me-2"></i>Adresse Email</label>
                        <div class="invalid-feedback">
                            Veuillez saisir une adresse email valide.
                        </div>
                    </div>

                    <div class="form-floating mb-3">
                        <input type="tel" class="form-control" id="telephone" name="telephone" placeholder="Téléphone" required>
                        <label for="telephone"><i class="fas fa-phone me-2"></i>Numéro de Téléphone</label>
                        <div class="invalid-feedback">
                            Veuillez saisir votre numéro de téléphone.
                        </div>
                    </div>

                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" id="password" name="password" placeholder="Mot de passe" required minlength="6">
                        <label for="password"><i class="fas fa-lock me-2"></i>Mot de Passe</label>
                        <div class="invalid-feedback">
                            Le mot de passe doit contenir au moins 6 caractères.
                        </div>
                    </div>

                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" placeholder="Confirmer le mot de passe" required>
                        <label for="confirm_password"><i class="fas fa-lock me-2"></i>Confirmer le Mot de Passe</label>
                        <div class="invalid-feedback">
                            Les mots de passe ne correspondent pas.
                        </div>
                    </div>

                    <div class="form-check mb-4">
                        <input class="form-check-input" type="checkbox" id="accept_terms" name="accept_terms" required>
                        <label class="form-check-label" for="accept_terms">
                            J'accepte les <a href="#" target="_blank">Conditions d'Utilisation</a> et la <a href="#" target="_blank">Politique de Confidentialité</a>
                        </label>
                        <div class="invalid-feedback">
                            Vous devez accepter les conditions d'utilisation.
                        </div>
                    </div>

                    <div class="d-grid mb-3">
                        <button type="submit" class="btn btn-register text-white fw-bold">
                            <i class="fas fa-user-plus me-2"></i>
                            Créer Mon Compte
                        </button>
                    </div>

                    <div class="text-center">
                        <small class="text-muted">
                            Vous avez déjà un compte ? 
                            <a href="index.php" class="text-decoration-none">Se connecter</a>
                        </small>
                    </div>
                </form>

                <div class="text-center mt-4">
                    <a href="../index.php" class="btn-back">
                        <i class="fas fa-arrow-left me-2"></i>
                        Retour à l'accueil
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Bootstrap JS -->
        <script src="assets/vendor/bootstrap-5.3.3/js/bootstrap.bundle.min.js"></script>
        
        <script>
            // Validation et soumission du formulaire
            document.addEventListener('DOMContentLoaded', function() {
                const registerForm = document.getElementById('registerForm');
                const registerAlert = document.getElementById('registerAlert');
                const registerLoading = document.getElementById('registerLoading');
                
                // Validation en temps réel des mots de passe
                const password = document.getElementById('password');
                const confirmPassword = document.getElementById('confirm_password');
                
                function validatePasswords() {
                    if (confirmPassword.value && password.value !== confirmPassword.value) {
                        confirmPassword.setCustomValidity('Les mots de passe ne correspondent pas');
                    } else {
                        confirmPassword.setCustomValidity('');
                    }
                }
                
                password.addEventListener('input', validatePasswords);
                confirmPassword.addEventListener('input', validatePasswords);
                
                // Soumission du formulaire
                registerForm.addEventListener('submit', function(e) {
                    e.preventDefault();
                    
                    if (!registerForm.checkValidity()) {
                        e.stopPropagation();
                        registerForm.classList.add('was-validated');
                        return;
                    }
                    
                    // Afficher le chargement
                    registerLoading.classList.remove('d-none');
                    registerAlert.classList.add('d-none');
                    
                    // Préparer les données
                    const formData = new FormData(registerForm);
                    
                    // Envoyer la requête
                    fetch('../process_register.php', {
                        method: 'POST',
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        registerLoading.classList.add('d-none');
                        
                        if (data.success) {
                            registerAlert.className = 'alert alert-success mt-3';
                            registerAlert.textContent = data.message;
                            registerAlert.classList.remove('d-none');
                            
                            // Redirection après un délai
                            setTimeout(() => {
                                window.location.href = 'index.php';
                            }, 2000);
                        } else {
                            registerAlert.className = 'alert alert-danger mt-3';
                            registerAlert.textContent = data.message;
                            registerAlert.classList.remove('d-none');
                        }
                    })
                    .catch(error => {
                        registerLoading.classList.add('d-none');
                        registerAlert.className = 'alert alert-danger mt-3';
                        registerAlert.textContent = 'Erreur de connexion. Veuillez réessayer.';
                        registerAlert.classList.remove('d-none');
                        console.error('Erreur:', error);
                    });
                });
            });
        </script>
    </body>
    </html>
    <?php
    exit; // Important : arrêter l'exécution après l'affichage de la page
}

extract($_REQUEST, EXTR_PREFIX_ALL | EXTR_REFS, 'v');

// Gestion de la vérification de session AJAX
if (isset($v_page) && $v_page === 'check_session') {
    header('Content-Type: application/json');
    
    $response = ['connected' => false, 'isAdmin' => false];
    
    if (isset($_SESSION[$NomSite]['userConnected']) && $_SESSION[$NomSite]['userConnected']) {
        $response['connected'] = true;
        
        // Vérifier si l'utilisateur est admin (pour redirection)
        if (isset($_SESSION[$NomSite]['userRoles'])) {
            $roles = $_SESSION[$NomSite]['userRoles'];
            foreach ($roles as $role) {
                if (isset($role['role_level']) && $role['role_level'] >= 60) {
                    $response['isAdmin'] = true;
                    break;
                }
            }
        }
    }
    
    echo json_encode($response);
    exit;
}

// Créer une instance pour les vues avec les chemins adaptés
$variousViews = new VisiteurVariousViewsHtml();

// Vérifications d'installation
$pathInstallExists = is_dir($installFolder);

if ($pathInstallExists && !file_exists($configFile)) {
    $title = 'Taghilt - Vérification de l\'installation';
    $variousViews->generateHeader(false, false,  $title, 'db');
    $variousViews->showInstallError('pathinstallExists');
    $variousViews->generateFooter(false, false, 'db');
    exit;
} else if (!$pathInstallExists && !file_exists($configFile)) {
    $installDontExists = true;
    $title = 'Taghilt - Erreur d\'installation';
    $variousViews->generateHeader(false, false,  $title, 'db');
    $variousViews->showInstallError('pathinstallnotExists');
    $variousViews->generateFooter(false, false, 'db');
    exit;
} else if ($pathInstallExists && file_exists($configFile)) {
    $title = 'Taghilt - Configuration requise';
    $variousViews->generateHeader(false, false,  $title, 'db');
    $variousViews->showInstallError('renameinstall');
    $variousViews->generateFooter(false, false, 'db');
    exit;
} else if (file_exists($configFile) && !$pathInstallExists) {

    $conn = dbConnect(false);
    if (!$conn) {
        $title = 'Taghilt - Erreur de base de données';
        $variousViews->generateHeader(false, false,  $title, 'db');
        $variousViews->showMysqlError();
        $variousViews->generateFooter(false, false, 'db');
        exit;
    } else {
        if (!isset($v_page)) {
            $v_page = "";
            $pageSite = "";
        } else {
            $pageSite = PageSite::tryFromName($v_page);
            if ($pageSite == "E9999")
                $pageSite = "";
        }
        if (!isset($v_typePage))
            $v_typePage = "";

        // Définir les titres spécifiques pour chaque page visiteur
        $pageTitles = [
            'hv' => 'Taghilt - Espace Agent',
            'vsts' => 'Taghilt - Mes Annonces',
            'dep' => 'Taghilt - Départements',
            'page' => 'Taghilt - Pages du Site',
            'role' => 'Taghilt - Mon Rôle',
            'user' => 'Taghilt - Mon Profil',
            'wdw' => 'Taghilt - Mon Activité',
            'ab' => 'Taghilt - À Propos',
            'msg' => 'Taghilt - Messages',
            'param' => 'Taghilt - Paramètres',
            'log' => 'Taghilt - Connexion Immobilier'
        ];

        $title = isset($pageTitles[$v_page]) ? $pageTitles[$v_page] : $NomSiteCap . ' - Plateforme Immobilière';

        $connectedHost = getClientHostname();
        
        // Vérifier d'abord si c'est une demande d'inscription
        $requestedPage = $_GET['page'] ?? '';
        if ($requestedPage === 'register') {
            // Afficher la page d'inscription immédiatement
            showRegisterPage();
            exit; // Arrêter l'exécution ici
        }
        
        // Interface visiteur uniquement
        $login = new Login($conn, $pageSite);
        $userConnected = $login->userConnected;

        // Si l'utilisateur est connecté et est un admin, rediriger vers l'interface admin
        if ($userConnected && isset($_SESSION[$NomSite]['userRoles'])) {
            $roles = $_SESSION[$NomSite]['userRoles'];
            $userLevel = 0;
            foreach ($roles as $role) {
                if (isset($role['role_level'])) {
                    $userLevel = max($userLevel, $role['role_level']);
                }
            }
            
            // Si niveau administrateur (>= 60), rediriger vers admin
            if ($userLevel >= 60) {
                header('Location: ../admin/index.php');
                exit;
            }
        }

        //On vérifie si c'est une borne qui se connecte sur l'application
        if (in_array($connectedHost, $BorneMachine)) {
            $v_page = "insc";
            $pageSite = "visiteurInit.php";

            $variousViews->generateHeader(false, false, $title, 'visiteur');
            if ($SiteEnMaintenance && !in_array($connectedHost, $AllowedMachineOnMaintenance)) {
                $variousViews->showMaintenance($connectedHost);
            } else
            if (in_array($connectedHost, $AllowedMachineOnMaintenance) || in_array($connectedHost, $BorneMachine)) {
                include($rootDir . "/SitePage/" . $pageSite);
            }
            $variousViews->generateFooter(false, false, 'visiteur');
        } else {
            // Interface visiteur connecté (niveau 10-50)
            if ($userConnected) {
                $useChart = false; // Pas de graphiques pour les visiteurs

                $variousViews->generateHeader($useChart, true, $title, 'visiteur');
                
                $navBar = new NavBar($conn);
                $navBar->getHeader('../');
                echo '
                <div class="container-fluid-taghilt">
                    <div class="row">';
                
                // Pas de sidebar pour l'interface visiteur - contenu pleine largeur
                
                if ($pageSite != Null) {
                    include($rootDir . "/SitePage/" . $pageSite);
                } else {
                    // Dashboard visiteur utilisant la vraie classe DashboardHtml
                    $navBar->getDashBoard($NomSiteCap);
                }
                echo '
                    </div>
                </div>';

                $variousViews->generateFooter($useChart, true, 'visiteur');
            } else {
                // Page de connexion visiteur par défaut
                $login = new Login($conn, 'log');
            }
        }
    }
}
?>


