<?PHP
namespace Views;

class WriteWhoDidWhatHtml
{
    static public function AfficheWDW($result, $sql)
    {
        include_once("FunctionHtml.php");
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php"); ?>

        <main class="<?php echo $mainClass; ?> ms-sm-auto px-md-4 py-4" id="main-content" style="display: none;">
            <div class="card card-mh-90vh">
                <div class="card-header">
                    <b>Liste des visites fournisseur</b>
                </div>
                <div class="card-body">
                    <?php
                    $displayNomComplet = true;
                    $displayNFirstGrid = false;

                    if (isset($_GET["msg"])) {
                        $msg = $_GET["msg"];

                        // Define messages, their alert types, and icons
                        $alerts = [
                            "updated" => ["success", "fas fa-check-circle", "Visite mise à jour avec succès."],
                            "deleted" => ["success", "fas fa-check-circle", "Visite supprimée avec succès."],
                            "added" => ["success", "fas fa-check-circle", "Visite ajoutée avec succès."],
                            "errorsupr" => ["warning", "fas fa-exclamation-triangle", "Erreur suppression, réessayez plus tard ou contactez ".$errorMsgService."."],
                            "erroraddedit" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnu, réessayez plus tard ou contactez ".$errorMsgService."."],
                            "errorajax" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnu, réessayez plus tard ou contactez le CSI au 2123."]
                        ];

                        // Check if the message exists in the array and display the alert
                        if (array_key_exists($msg, $alerts)) {
                            list($alertType, $icon, $message) = $alerts[$msg];
                            echo '<div class="alert alert-' . $alertType . '" id="alertMessage" role="alert">
                                    <i class="' . $icon . ' me-2"></i> ' . $message . '
                                  </div>';
                        }
                    }

                    ?>
                    <table id="gridWhoDidWhat" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th>Utilisateur</th>
                                <th>Ordinateur</th>
                                <th>Mode</th>
                                <th>Table</th>
                                <th>Page</th>
                                <th>Requête SQL</th>
                                <th>nrows</th>
                                <th>Message</th>
                                <th>Dernière modification</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            foreach ($result as $row) {

                                echo '
                                <tr>
                                <td>' . $row["username"] . '</td>
                                <td>' . $row["hostname"] . '</td>
                                <td>' . $row["mode_cmd"] . '</td>
                                <td>' . $row["table_cmd"] . '</td>
                                <td>' . $row["url_cmd"] . '</td>
                                <td style=font-size:80%; font-family:courier">' . $row["sql_cmd"] . '</td>
                                <td>' . $row["nrows"] . '</td>
                                <td>' . $row["msg"] . '</td>
                                <td>' . $row["lastmod"] . '</td>
                                </tr>';
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Utilisateur</th>
                                <th>Ordinateur</th>
                                <th>Mode</th>
                                <th>Table</th>
                                <th>Page</th>
                                <th>Requête SQL</th>
                                <th>nrows</th>
                                <th>Message</th>
                                <th>Dernière modification</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </main>

        <?PHP
    }
} ?>
