<?PHP
namespace Views;

class VisiteursHtml
{
    public array $data = [];

    public function __construct() {}

    public static function affichePAVisiteur()
    {

        include_once("FunctionHtml.php");
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");

        if ($YesUseSwitchLang) {
            echo '
            <div class="language-toggle">
                <button id="btnLanguageToggle" class="btn btn-secondary">
                    ' . ($language === 'fr' ? 'Switch to English' : 'Passer au Fran�ais') . '
                </button>
            </div>';
        }
?>

        <div class="header">
            <img src="assets/images/<?= $logoEtablissement ?>" alt="Logo" height="50">
            <span class="fs-4 d-none"><?= $language === 'fr' ? "Bienvenue � Reoleweb" : "Welcome to Reoleweb" ?></span>
        </div>


        <div class="container d-flex justify-content-center align-items-center mt-4">
            <div class="d-flex p-4" style="min-width: 300px;max-width: 800px;">
                <div class="justify-content-center text-center">
                    <h2><?= $language === 'fr' ? "Bienvenue sur Taghilt - Votre plateforme immobilière!" : "Welcome to Taghilt - Your real estate platform!" ?>
                    </h2>
                    <p><?= $language === 'fr' ? "Merci pour votre visite.<br>Pour commencer, veuillez vous inscrire pour pouvoir imprimer votre badge repr�sentant.<br>Il vous sera n�cessaire pour circuler dans l'h�pital." : "Thank you for your visit.<br>To begin with, please register to be able to print your Visitor Badge.<br>It will allow you to move around the hospital." ?>
                    </p>
                </div>
            </div>
        </div>

        <div class="content center-container justify-content-center">
            <div class="text-center mb-5 me-3">
                <button class="btn btn-success btn-large" onclick="window.location.href='admin/index.php?page=hv&typePage=insc'"><i
                        class="fas fa-user-plus"></i> <?= $language === 'fr' ? "S'inscrire" : "Register" ?></button><br>
                <button class="btn btn-danger btn-large" style="visibility: hidden;"
                    onclick="window.location.href='admin/index.php?page=hv&typePage=connect'"><i class="fas fa-sign-in-alt"></i>
                    <?= $language === 'fr' ? "J'ai d�j� un code" : "I already have a code" ?></button>
            </div>
        </div>
        <div class="footer">
            <span>Tous droits r�serv�s � <?= $yearVersion . ' ' . $compagnyName ?></span>
        </div>
        <script src="FirstWebApp/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
        <?php


        if ($useOnlyFirstDate) {
            echo '<script>const useOnlyFirstDate = true;</script>';
        } else {
            echo '<script>const useOnlyFirstDate = false;</script>';
        }
    }
    static public function inscriptionVisiteur($conn, $resultcomp, $resultsecteur, $companyName, $champActivite, $champcivilite, $champnom, $champprenom, $champnomId, $champsecteur, $champcontactPerson, $champDateDebut, $champHeureDebut, $champDatefin, $champHeurefin, $companyId, $secteurId, $contactId, $msg)
    {
        include_once("views\FunctionHtml.php");
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");

        ?>
        <div class="home-button">
            <button id="btnGoToHome" class="btn btn-secondary">
                <i class="fa fa-home"></i> <?= $language === 'fr' ? "Accueil" : "Home" ?>
            </button>
        </div>

        <?php
        if ($YesUseSwitchLang) {
            echo '
            <div class="language-toggle">
                <button id="btnLanguageToggle" class="btn btn-secondary">
                    ' . ($language === 'fr' ? 'Switch to English' : 'Passer au Fran�ais') . '
                </button>
            </div>';
        }
        ?>
        <div class="header">
            <img src="assets/images/<?= $logoEtablissement ?>" alt="Logo" height="50px">
            <span
                class="fs-4"><?= $language === 'fr' ? formuleBienvenue($nomEtablissement) : "Welcome to " . $nomEtablissementAnglais ?></span>
        </div>

        <?php

        if ($UseStep) {
        ?>

            <div class="content center-container">
                <div class="form-container">
                    <h2 class="text-center text-primary mb-4">
                        <?= $language === 'fr' ? "Inscription repr�sentant" : "Representative Registration" ?></h2>
                    <form id="FormInscription" name="FormInscription" action="admin/index.php?page=hv&typePage=insc" method="post"
                        autocomplete="off">
                        <?php
                        if ($msg != "")
                            echo '<div class="alert alert-warning" role="alert">' . $msg . '</div>';

                        ?>
                        <div class="progress mb-4">
                            <div id="progressBar" class="progress-bar bg-primary" style="width: 10%;">Step 1 of 7</div>
                        </div>
                        <div class="card">
                            <div class="card-body">
                                <div class="step-content">
                                    <div class="step" id="step-1">
                                        <h4><?= $language === 'fr' ? "�tape" : "Step" ?> 1:
                                            <?= $language === 'fr' ? "Informations sur votre entreprise" : "Information about your company" ?>
                                        </h4>
                                        <div class="mb-3">
                                            <label for="companyName"
                                                class="form-label"><?= $language === 'fr' ? "Quelle entreprise repr�sentez-vous ??" : "Which company do you represent ??" ?> <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="companyName" name="companyName"
                                                value="<?php echo $companyName; ?>" autocomplete="off" required>
                                            <input type="hidden" id="companyId" name="companyId"
                                                value="<?php echo $companyId; ?>" />
                                            <div id="companyNameError" class="invalid-feedback d-none">
                                                <?= $language === 'fr' ? "Le nom de votre entreprise est requis." : "Your company name is required." ?>
                                            </div>
                                            <div id="resultContainer" class="result-list"></div>
                                        </div>
                                        <div class="mb-3">
                                            <label for="champActivite"
                                                class="form-label"><?= $language === 'fr' ? "Quelle est l'activit� de votre entreprise ?" : "What is the activity of your company ?" ?></label>
                                            <input type="text" class="form-control capitalize" id="champActivite"
                                                name="champActivite" value="<?php echo $champActivite; ?>" autocomplete="off"
                                                <?php echo $ActivityCompagnyRequiredText; ?>>
                                            <div id="champActiviteError" class="invalid-feedback d-none">
                                                <?= $language === 'fr' ? "L'activit� de votre entreprise est requis." : "Your company's activity is required." ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="step d-none" id="step-2">
                                        <h4><?= $language === 'fr' ? "�tape" : "Step" ?> 2:
                                            <?= $language === 'fr' ? "Vos informations" : "Your information" ?></h4>
                                        <div class="col-md-3 mb-3">
                                            <label for="champcivilite"
                                                class="form-label"><?= $language === 'fr' ? "Civilit�" : "Civility" ?> <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <select class="form-control" id="champcivilite" name="champcivilite" required>
                                                <option value="" selected>--</option>
                                                <option value="MR" <?= $champcivilite === 'MR' ? 'selected' : '' ?>>
                                                    <?= $language === 'fr' ? 'M.' : 'Mr' ?>
                                                </option>
                                                <option value="MME" <?= $champcivilite === 'MME' ? 'selected' : '' ?>>
                                                    <?= $language === 'fr' ? 'Mme' : 'Mrs' ?>
                                                </option>
                                                <option value="MLLE" <?= $champcivilite === 'MLLE' ? 'selected' : '' ?>>
                                                    <?= $language === 'fr' ? 'Mlle' : 'Miss' ?>
                                                </option>
                                                <option value="DR" <?= $champcivilite === 'DR' ? 'selected' : '' ?>>
                                                    <?= $language === 'fr' ? 'Dr' : 'Dr' ?>
                                                </option>
                                                <option value="DRE" <?= $champcivilite === 'DRE' ? 'selected' : '' ?>>
                                                    <?= $language === 'fr' ? 'Dre' : 'Dr (f)' ?>
                                                </option>
                                            </select>
                                            <div id="champciviliteVisiteurError" class="invalid-feedback">
                                                <?= $language === 'fr' ? "Ce champ est requis." : "This field is required." ?></div>
                                        </div>

                                        <div class="mb-3 row">
                                            <div class="col-md-12 mb-3">
                                                <label for="champnom"
                                                    class="form-label"><?= $language === 'fr' ? "Nom" : "Last name" ?> <span
                                                        style="color: red; font-weight: bold;">*</span></label>
                                                <input type="text" class="form-control capitalize" id="champnom" name="champnom"
                                                    value="<?php echo  $champnom; ?>" autocomplete="off" required>
                                                <input type="hidden" id="champnomId" name="champnomId"
                                                    value="<?php echo $champnomId; ?>" />
                                                <div id="champnomVisiteurError" class="invalid-feedback">
                                                    <?= $language === 'fr' ? "Ce champ est requis." : "This field is required." ?>
                                                </div>
                                                <div id="resultContainer-nom" class="result-list"></div>
                                            </div>
                                        </div>

                                        <div class="mb-3">
                                            <label for="champprenom"
                                                class="form-label"><?= $language === 'fr' ? "Pr�nom" : "First name" ?> <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="champprenom" name="champprenom"
                                                value="<?php echo $champprenom; ?>" autocomplete="off" required>
                                            <div id="champprenomVisiteurError" class="invalid-feedback">
                                                <?= $language === 'fr' ? "Ce champ est requis." : "This field is required." ?></div>
                                            <div id="resultContainer-prenom" class="result-list"></div>
                                        </div>

                                        <div class="mb-3 row">
                                            <div class="col-md-12 mb-3">
                                                <label for="champemailVisiteur" class="form-label"><?= $language === 'fr' ? "Courriel" : "Email address" ?></label>
                                                <input type="email" class="form-control uncapitalize" id="champemailVisiteur"
                                                    name="champemailVisiteur" autocomplete="off">
                                                <div id="champemailVisiteurError" class="invalid-feedback">
                                                    <?= $language === 'fr' ? "Ce champ est requis." : "This field is required." ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mb-3 row">
                                            <div class="col-md-6 mb-3">
                                                <label for="champtelVisiteur" class="form-label"><?= $language === 'fr' ? "T�l�phone" : "Phone number" ?></label>
                                                <input type="tel" class="form-control capitalize" id="champtelVisiteur"
                                                    name="champtelVisiteur" autocomplete="off">
                                                <div id="champtelVisiteurError" class="invalid-feedback">
                                                    <?= $language === 'fr' ? "Ce champ est requis." : "This field is required." ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="step d-none" id="step-3">
                                        <h4><?= $language === 'fr' ? "�tape" : "Step" ?> 3:
                                            <?= $language === 'fr' ? "Informations sur la visite" : "Visit information" ?></h4>
                                        <div class="mb-3">
                                            <label for="champsecteur"
                                                class="form-label"><?= $language === 'fr' ? "Nom du secteur avec lequel vous avez rendez-vous?" : "Name of the department you have an appointment with" ?>
                                                <span style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="champsecteur" name="champsecteur"
                                                value="<?php echo  $champsecteur; ?>" autocomplete="off" required />
                                            <input type="hidden" id="secteurId" name="secteurId"
                                                value="<?php echo  $secteurId; ?>" />
                                            <div id="resultContainer-secteur" class="result-list"></div>
                                            <div id="champsecteurError" class="invalid-feedback">
                                                <?= $language === 'fr' ? "Ce champ est requis." : "This field is required." ?></div>
                                        </div>

                                        <div class="mb-3">
                                            <label for="champcontactPerson"
                                                class="form-label"><?= $language === 'fr' ? "Nom de la personne avec laquelle vous avez rendez-vous?" : "Name of the person you have an appointment with" ?>
                                                <span style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="champcontactPerson"
                                                name="champcontactPerson" value="<?php echo  $champcontactPerson; ?>"
                                                autocomplete="off" required>
                                            <input type="hidden" id="contactId" name="contactId"
                                                value="<?php echo  $contactId; ?>" />
                                            <div id="resultContainer-contactPerson" class="result-list"></div>
                                            <div id="champcontactPersonError" class="invalid-feedback">
                                                <?= $language === 'fr' ? "Ce champ est requis." : "This field is required." ?></div>
                                        </div>

                                        <div class="mb-3 row">
                                            <?php
                                            if ($useOnlyFirstDate) {
                                                echo '
                                                <div class="col-md-4 mb-3">
                                                    <label for="champDateDebut" class="form-label">' . ($language === 'fr' ? "Date de la visite" : "Visit date?") . ' <span
                                                            style="color: red; font-weight: bold;">*</span></label>
                                                    <input type="date" class="form-control" id="champDateDebut"
                                                        name="champDateDebut" required>
                                                    <input type="hidden" id="hchampdatedebut" name="hchampdatedebut" value="' . $champDateDebut . '"
                                required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="champHeureDebut" class="form-label">' . ($language === 'fr' ? "Heure d'arriv�e" : "Arrival time?") . ' <span style="color: red; font-weight: bold;">*</span></label>
                                <div class="input-group">
                                    <select class="form-control with-arrow" id="champHeureDebut" name="champHeureDebut"
                                        required>
                                    </select>
                                    <span class="input-group-text">
                                        <i class="fas fa-clock"></i>
                                    </span>
                                </div>
                                <input type="hidden" id="hchampheuredebut" name="hchampheuredebut" value="' . $champHeureDebut . '" required>
                                <div id="champHeureDebutError" class="invalid-feedback">' . ($language === 'fr' ? "Ce champ est requis." : "This field is required.") . '</div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="champHeurefin" class="form-label">' . ($language === 'fr' ? "Heure de d�part?" : "Departure time") . ' <span style="color: red; font-weight: bold;">*</span></label>
                                <div class="input-group">
                                    <select class="form-control with-arrow" id="champHeurefin" name="champHeurefin"
                                        required>
                                    </select>
                                    <span class="input-group-text">
                                        <i class="fas fa-clock"></i>
                                    </span>
                                <div id="champHeurefinError" class="invalid-feedback">' . ($language === 'fr' ? "Ce champ est requis." : "This field is required.") . '</div>
                                </div>
                                <input type="hidden" id="hchampheurefin" name="hchampheurefin" value="' . $champHeurefin . '" required>
                            </div>';
                                            } else {
                                                echo '
                            <div class="col-md-6 align-items-center">
                                <div>
                                    <label for="champDateDebut"
                                        class="form-label">' . ($language === 'fr' ? "Date de la visite" : "Visit date?") . ' <span style="color: red; font-weight: bold;">*</span></label>
                                    <input type="date" class="form-control" id="champDateDebut" name="champDateDebut" required>
                                    <input type="hidden" id="hchampdatedebut" name="hchampdatedebut" value="' . $champDateDebut . '" required>
                                </div>
                                <div>
                                    <label for="champHeureDebut"
                                        class="form-label">' . ($language === 'fr' ? "Heure d'arriv�e" : "Arrival time?") . '<span style="color: red; font-weight: bold;">*</span></label>
                                    <div class="input-group">
                                        <select class="form-control with-arrow" id="champHeureDebut" name="champHeureDebut" required>
                                        </select>
                                        <span class="input-group-text">
                                            <i class="fas fa-clock"></i>
                                        </span>
                                    </div>
                                    <input type="hidden" id="hchampheuredebut" name="hchampheuredebut" value="' . $champHeureDebut . '" required>
                                    <div id="champHeureDebutError" class="invalid-feedback">' . ($language === 'fr' ? "Ce champ est requis." : "This field is required.") . '</div>
                                </div>
                            </div>

                            <!-- Date and Hour End -->
                            <div class="col-md-6 align-items-center">
                                <div>
                                    <label for="champDatefin"
                                        class="form-label">' . ($language === 'fr' ? "Date fin visite" : "End date of visit") . ' <span style="color: red; font-weight: bold;">*</span></label>
                                    <input type="date" class="form-control" id="champDatefin" name="champDatefin" required>
                                    <input type="hidden" id="hchampdatefin" name="hchampdatefin" value="' . $champDatefin . '" required>
                                </div>
                                <div>
                                    <label for="champHeurefin"
                                        class="form-label">' . ($language === 'fr' ? "Heure de d�part?" : "Departure time") . ' <span style="color: red; font-weight: bold;">*</span></label>
                                    <div class="input-group">
                                        <select class="form-control with-arrow" id="champHeurefin" name="champHeurefin" required>
                                        </select>
                                        <span class="input-group-text">
                                            <i class="fas fa-clock"></i>
                                        </span>
                                    <div id="champHeurefinError" class="invalid-feedback">' . ($language === 'fr' ? "Ce champ est requis." : "This field is required.") . '</div>
                                    </div>
                                    <input type="hidden" id="hchampheurefin" name="hchampheurefin" value="' . $champHeurefin . '" required>
                                </div>
                            </div>';
                                            }
                                            ?>
                                        </div>
                                        <div class="mb-3 row">
                                            <div class="col-md-12 mb-3">
                                                <label for="champobservation"
                                                    class="form-label"><?= $language === 'fr' ? "Motif de la visite" : "Purpose of the visit" ?></label>
                                                <textarea class="form-control" id="champobservation" name="champobservation"
                                                    rows="4" autocomplete="off"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="step d-none" id="step-4">
                                        <h4><?= $language === 'fr' ? "�tape" : "Step" ?> 4:
                                            <?= $language === 'fr' ? "Confirmer et soumettre" : "Confirm & Submit" ?></h4>
                                        <p><?= $language === 'fr' ? "V�rifiez vos informations, puis soumettez-les pour imprimer votre badge." : "Please verify your information before submitting to print your badge." ?>
                                        </p>
                                        <table class="table table-bordered">
                                            <tr>
                                                <th style="width:50%">
                                                    <?= $language === 'fr' ? "Nom de votre entreprise" : "Name of your company" ?>
                                                </th>
                                                <td id="tdcompanyName"><?php echo  $companyName; ?></td>
                                            </tr>
                                            <tr>
                                                <th><?= $language === 'fr' ? "Activit� de votre entreprise" : "Your company's activity" ?>
                                                </th>
                                                <td id="tdchampActivite"></td>
                                            </tr>
                                            <tr>
                                                <th><?= $language === 'fr' ? "Civilit�" : "Civility" ?></th>
                                                <td id="tdchampcivilite"></td>
                                            </tr>
                                            <tr>
                                                <th><?= $language === 'fr' ? "Nom" : "Last name" ?></th>
                                                <td id="tdchampnom"></td>
                                            </tr>
                                            <tr>
                                                <th><?= $language === 'fr' ? "Pr�nom" : "First name" ?></th>
                                                <td id="tdchampprenom"></td>
                                            </tr>
                                            <tr>
                                                <th><?= $language === 'fr' ? "Nom du secteur avec lequel vous avez rendez-vous?" : "Name of the department you have an appointment with" ?></th>
                                                <td id="tdchampsecteur"></td>
                                            </tr>
                                            <tr>
                                                <th><?= $language === 'fr' ? "Nom de la personne avec laquelle vous avez rendez-vous?" : "Name of the person you have an appointment with" ?></th>
                                                <td id="tdchampcontactPerson"></td>
                                            </tr>

                                            <?php

                                            if ($useOnlyFirstDate) {
                                            ?>
                                                <tr>
                                                    <th><?= $language === 'fr' ? "Date et heure de la visite" : "Date and time of the visit" ?>
                                                    </th>
                                                    <td id="tdchampDateHeureDebut"></td>
                                                </tr>
                                            <?php
                                            } else {
                                            ?>
                                                <tr>
                                                    <th><?= $language === 'fr' ? "Date/Heure D�but de la viste" : "Date/Time Start of visit" ?>
                                                    </th>
                                                    <td id="tdchampDateHeureDebut"></td>
                                                </tr>

                                                <tr>
                                                    <th><?= $language === 'fr' ? "Date/Heure Fin de la viste" : "Date/Time End of visit" ?>
                                                    </th>
                                                    <td id="tdchampDateHeurefin"></td>
                                                </tr>
                                            <?php
                                            }
                                            ?>
                                            <tr>
                                                <th><?= $language === 'fr' ? "Motif de la visite" : "Purpose of the visit" ?></th>
                                                <td id="tdchampobservation"></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between mt-4">
                                    <input type="hidden" name="confirmation" id="confirmation" value="0">
                                    <button type="button" class="btn btn-dark" id="prevBtn"
                                        disabled><?= $language === 'fr' ? "Pr�c�dent" : "Previous" ?></button>
                                    <button type="button" class="btn btn-primary"
                                        id="nextBtn"><?= $language === 'fr' ? "Suivant" : "Next" ?></button>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3 row">
                            <div class="col-md-12 mb-3">
                                <br>
                                <span style="color: red; font-weight: bold;">(*)</span> <?= $language === 'fr' ? "Champs requis." : "Required field." ?>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="modal fade" id="inactivityModal" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalLabel">
                                <?= $language === 'fr' ? "Avertissement d'inactivit�" : "Inactivity Warning" ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <p><?= $language === 'fr' ? "Vous serez renvoy� vers la page d'accueil dans" : "You will be returned to the home page in" ?>
                                <span id="countdown">30</span> <?= $language === 'fr' ? "secondes..." : "seconds..." ?>
                            </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary" name="stayBtn"
                                id="stayBtn"><?= $language === 'fr' ? "Rester sur la page" : "Stay on Page" ?></button>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        } else {
        ?>

            <div class="content center-container">
                <div class="form-container">
                    <h2 class="text-center text-primary mb-4">
                        <?= $language === 'fr' ? "Inscription repr�sentant" : "Representative Registration" ?></h2>
                    <form id="FormInscription" name="FormInscription" action="admin/index.php?page=hv&typePage=insc" method="post">
                        <?php

                        if ($msg != "")
                            echo '<div class="alert alert-warning" role="alert">' . $msg . '</div>';

                        ?>
                        <div class="mb-3">
                            <label for="companyName"
                                class="form-label"><?= $language === 'fr' ? "Nom de votre compagnie" : "Name of your company" ?></label>
                            <input type="text" class="form-control capitalize" id="companyName" name="companyName"
                                value="<?php echo $companyName; ?>" autocomplete="off" required>
                            <input type="hidden" id="companyId" name="companyId" value="<?php echo $companyId; ?>" />
                            <div id="resultContainer" class="result-list"></div>
                        </div>

                        <div class="col-md-3 mb-3">
                            <label for="champcivilite" class="form-label"><?= $language === 'fr' ? "Civilit�" : "Civility" ?> <span
                                    style="color: red; font-weight: bold;">*</span></label>
                            <select class="form-control" id="champcivilite" name="champcivilite" required>
                                <option value="" selected>--</option>
                                <option value="MR" <?php if ($champcivilite == 'MR') echo 'selected'; ?>>Mr</option>
                                <option value="MME" <?php if ($champcivilite == 'MME') echo 'selected'; ?>>Mme</option>
                                <option value="MLLE" <?php if ($champcivilite == 'MLLE') echo 'selected'; ?>>Mlle</option>
                                <option value="DR" <?php if ($champcivilite == 'DR') echo 'selected'; ?>>Dr</option>
                                <option value="DRE" <?php if ($champcivilite == 'DRE') echo 'selected'; ?>>Dre</option>
                            </select>
                        </div>

                        <div class="mb-3 row">
                            <div class="col-md-12 mb-3">
                                <label for="champnom" class="form-label"><?= $language === 'fr' ? "Nom" : "Last name" ?></label>
                                <input type="text" class="form-control capitalize" id="champnom" name="champnom"
                                    value="<?php echo  $champnom; ?>" autocomplete="off" required>
                                <input type="hidden" id="champnomId" name="champnomId" value="<?php echo $champnomId; ?>" />
                                <div id="resultContainer-nom" class="result-list"></div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="champprenom" class="form-label"><?= $language === 'fr' ? "Pr�nom" : "First name" ?></label>
                            <input type="text" class="form-control capitalize" id="champprenom" name="champprenom"
                                value="<?php echo $champprenom; ?>" autocomplete="off" required>
                            <div id="resultContainer-prenom" class="result-list"></div>
                        </div>

                        <div class="mb-3">
                            <label for="champsecteur"
                                class="form-label"><?= $language === 'fr' ? "Secteur � visiter" : "Sector to visit" ?></label>
                            <input type="text" class="form-control capitalize" id="champsecteur" name="champsecteur"
                                value="<?php echo  $champsecteur; ?>" autocomplete="off" required />
                            <input type="hidden" id="secteurId" name="secteurId" value="<?php echo  $secteurId; ?>" />
                            <div id="resultContainer-secteur" class="result-list"></div>
                        </div>

                        <div class="mb-3">
                            <label for="champcontactPerson"
                                class="form-label"><?= $language === 'fr' ? "Personne � visiter" : "Person to visit" ?></label>
                            <input type="text" class="form-control capitalize" id="champcontactPerson" name="champcontactPerson"
                                value="<?php echo  $champcontactPerson; ?>" autocomplete="off" required>
                            <input type="hidden" id="contactId" name="contactId" value="<?php echo  $contactId; ?>" />
                            <div id="resultContainer-contactPerson" class="result-list"></div>
                        </div>

                        <div class="mb-3 row">
                            <div class="col-md-6 align-items-center">
                                <div class="me-2">
                                    <label for="champDateDebut"
                                        class="form-label"><?= $language === 'fr' ? "Date de la visite" : "Visit date?" ?></label>
                                    <input type="date" class="form-control" id="champDateDebut" name="champDateDebut" required>
                                    <input type="hidden" id="hchampdatedebut" name="hchampdatedebut"
                                        value="<?php echo  $champDateDebut; ?>" required>
                                </div>
                                <div>
                                    <label for="champHeureDebut"
                                        class="form-label"><?= $language === 'fr' ? "Heure d'arriv�e" : "Arrival time?" ?></label>
                                    <div class="input-group">
                                        <select class="form-control with-arrow" id="champHeureDebut" name="champHeureDebut"
                                            required>
                                        </select>
                                        <span class="input-group-text">
                                            <i class="fas fa-clock"></i>
                                        </span>
                                    </div>
                                    <input type="hidden" id="hchampheuredebut" name="hchampheuredebut"
                                        value="<?php echo  $champHeureDebut; ?>" required>
                                </div>
                            </div>
                            <div class="col-md-6 align-items-center">
                                <div class="me-2">
                                    <label for="champDatefin"
                                        class="form-label"><?= $language === 'fr' ? "Date fin visite" : "End date of visit" ?></label>
                                    <input type="date" class="form-control" id="champDatefin" name="champDatefin" required>
                                    <input type="hidden" id="hchampdatefin" name="hchampdatefin"
                                        value="<?php echo  $champDatefin; ?>" required>
                                </div>
                                <div>
                                    <label for="champHeurefin"
                                        class="form-label"><?= $language === 'fr' ? "Heure de d�part?" : "Departure time" ?></label>
                                    <div class="input-group">
                                        <select class="form-control with-arrow" id="champHeurefin" name="champHeurefin" required>
                                        </select>
                                        <span class="input-group-text">
                                            <i class="fas fa-clock"></i>
                                        </span>
                                    </div>
                                    <inputLECpe="hidden" id="hchampheurefin" name="hchampheurefin"
                                        value="<?php echo  $champHeurefin; ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <br>
                            <button type="button" id="btnSubmitForm"
                                class="btn btn-primary btn-lg w-100"><?= $language === 'fr' ? "S'inscrire" : "Register" ?></button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="modal fade" id="inactivityModal" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalLabel">
                                <?= $language === 'fr' ? "Avertissement d'inactivit�" : "Inactivity Warning" ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <p><?= $language === 'fr' ? "Vous serez renvoy� vers la page d'accueil dans" : "You will be returned to the home page in" ?>
                                <span id="countdown">30</span> <?= $language === 'fr' ? "secondes..." : "seconds..." ?>
                            </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary" name="stayBtn"
                                id="stayBtn"><?= $language === 'fr' ? "Rester sur la page" : "Stay on Page" ?></button>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        }

        if ($useOnlyFirstDate) {
            echo '<script>const useOnlyFirstDate = true;</script>';
        } else {
            echo '<script>const useOnlyFirstDate = false;</script>';
        }
        ?>
        <div class="footer">
            <span>Tous droits r�serv�s � <?= $yearVersion . ' ' . $compagnyName ?></span>
        </div>


    <?php
    }


    static public function confirmationDonneesVisiteur($conn, $companyName, $champActivite, $champcivilite, $champnom, $champprenom, $champnomId, $champsecteur, $champcontactPerson, $champDateDebut, $champHeureDebut, $champDatefin, $champHeurefin, $companyId, $secteurId, $contactId, $msg)
    {
        include_once("views\FunctionHtml.php");
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");

        $sql = "SELECT id_fournisseur, nom_compagnie FROM fournisseur WHERE id_fournisseur = " . $companyId . "";
        $conn->exec($sql);
        $resultcomp = $conn->data;
        foreach ($resultcomp as $row) {
            $resultcomp = "" . $row["nom_compagnie"];
        }
        $sql2 = "SELECT id_secteur, nom_secteur FROM secteur_a_visiter WHERE id_secteur = " . $secteurId . "";
        $conn->exec($sql2);
        $resultsecteur = $conn->data;
        foreach ($resultsecteur as $row) {
            $resultsecteur = "" . $row["nom_secteur"];
        }

    ?>
        <div class="home-button">
            <button id="btnGoToHome" class="btn btn-secondary">
                <i class="fa fa-home"></i> <?= $language === 'fr' ? "Accueil" : "Home" ?>
            </button>
        </div>

        <?php
        if ($YesUseSwitchLang) {
            echo '
        <div class="language-toggle">
            <button id="btnLanguageToggle" class="btn btn-secondary">
                ' . ($language === 'fr' ? 'Switch to English' : 'Passer au Fran�ais') . '
            </button>
        </div>';
        }
        ?>
        <div class="header">
            <img src="assets/images/drhtLogo01.png" alt="Logo" height="50px">
            <span
                class="fs-4 d-none"><?= $language === 'fr' ? "Bienvenue � Reoleweb" : "Welcome to Reoleweb" ?></span>
        </div>
        <div class="content center-container">
            <div class="form-container">
                <h2 class="text-center text-primary mb-4">
                    <?= $language === 'fr' ? "R�sum� de votre inscription 2" : "Summary of your registration" ?></h2>
                <table class="table table-bordered">
                    <tr>
                        <th><?= $language === 'fr' ? "Nom de votre compagnie" : "Name of your company" ?></th>
                        <td><?php echo  $companyName; ?></td>
                    </tr>
                    <tr>
                        <th><?= $language === 'fr' ? "Civilit�" : "Civility" ?></th>
                        <td><?php echo  $champcivilite; ?></td>
                    </tr>
                    <tr>
                        <th><?= $language === 'fr' ? "Nom" : "Last name" ?></th>
                        <td><?php echo  $champnom; ?></td>
                    </tr>
                    <tr>
                        <th><?= $language === 'fr' ? "Pr�nom" : "First name" ?></th>
                        <td><?php echo  $champprenom; ?></td>
                    </tr>
                    <tr>
                        <th><?= $language === 'fr' ? "Secteur � visiter" : "Sector to visit" ?></th>
                        <td><?php echo  $champsecteur; ?></td>
                    </tr>
                    <tr>
                        <th><?= $language === 'fr' ? "Personne � visiter" : "Person to visit" ?></th>
                        <td><?php echo  $champcontactPerson; ?></td>
                    </tr>
                    <?php

                    if ($YesUseSwitchLang) {
                    ?>
                        <tr>
                            <th><?= $language === 'fr' ? "Date/Heure D�but de la viste" : "Date/Time Start of visit" ?></th>
                            <td>Le <?php echo  $champDateDebut; ?>, de <?php echo  $champHeureDebut; ?> �
                                <?php echo  $champHeurefin; ?></td>
                        </tr>
                    <?php
                    } else {
                    ?>
                        <tr>
                            <th><?= $language === 'fr' ? "Date/Heure D�but de la viste" : "Date/Time Start of visit" ?></th>
                            <td><?php echo  $champDateDebut; ?> <?php echo  $champHeureDebut; ?></td>
                        </tr>
                        <tr>
                            <th><?= $language === 'fr' ? "Date/Heure Fin de la viste" : "Date/Time End of visit" ?></th>
                            <td><?php echo  $champDatefin; ?> <?php echo  $champHeurefin; ?></td>
                        </tr>
                    <?php
                    }
                    ?>

                </table>
                <div class="mt-4">
                    <form action="admin/index.php?page=hv&typePage=insc" method="post" style="display:inline;">
                        <input type="hidden" name="confirmation" value="1">
                        <input type="hidden" name="companyName" value="<?php echo  $companyName; ?>">
                        <input type="hidden" name="champActivite" value="<?php echo  $champActivite; ?>">
                        <input type="hidden" name="companyId" value="<?php echo  $companyId; ?>">
                        <input type="hidden" name="champnom" value="<?php echo  $champnom; ?>">
                        <input type="hidden" name="champcivilite" value="<?php echo  $champcivilite; ?>">
                        <input type="hidden" name="champnomId" value="<?php echo  $champnomId; ?>">
                        <input type=" hidden" name="champprenom" value="<?php echo  $champprenom; ?>">
                        <input type="hidden" name="champsecteur" value="<?php echo  $champsecteur; ?>">
                        <input type="hidden" name="secteurId" value="<?php echo  $secteurId; ?>">
                        <input type="hidden" name="champcontactPerson" value="<?php echo  $champcontactPerson; ?>">
                        <input type="hidden" name="contactId" value="<?php echo  $contactId; ?>">
                        <input type="hidden" name="champdatedebut" value="<?php echo  $champDateDebut; ?>">
                        <input type="hidden" name="champheuredebut" value="<?php echo  $champHeureDebut; ?>">
                        <input type="hidden" name="champdatefin" value="<?php echo  $champDatefin; ?>">
                        <input type="hidden" name="champheurefin" value="<?php echo  $champHeurefin; ?>">
                        <button type="submit" class="btn btn-secondary"><?= $language === 'fr' ? "Modifier" : "Edit" ?></button>
                        <button type="submit"
                            class="btn btn-primary"><?= $language === 'fr' ? "Confirmer" : "Confirm" ?></button>
                    </form>
                </div>
            </div>
        </div>
        <div class="modal fade" id="inactivityModal" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel">
                            <?= $language === 'fr' ? "Avertissement d'inactivit�" : "Inactivity Warning" ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><?= $language === 'fr' ? "Vous serez renvoy� vers la page d'accueil dans" : "You will be returned to the home page in" ?>
                            <span id="countdown">30</span> <?= $language === 'fr' ? "secondes..." : "seconds..." ?>
                        </p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" name="stayBtn"
                            id="stayBtn"><?= $language === 'fr' ? "Rester sur la page" : "Stay on Page" ?></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer">
            <span>Tous droits r�serv�s � <?= $yearVersion . ' ' . $compagnyName ?></span>
        </div>
        <script src="vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
        <link href="assets/vendor/bootstrap-icons-1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

        <?php


        if ($useOnlyFirstDate) {
            echo '<script>const useOnlyFirstDate = true;</script>';
        } else {
            echo '<script>const useOnlyFirstDate = false;</script>';
        }
    }

    static public function impressionBadgeVisiteur($conn, $companyName, $champActivite, $champcivilite, $champnom, $champprenom, $champnomId, $champsecteur, $champcontactPerson, $champDateDebut, $champHeureDebut, $champDatefin, $champHeurefin, $companyId, $secteurId, $contactId, $msg)
    {
        include_once("views\FunctionHtml.php");
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");
        ?>
        <div class="home-button">
            <button id="btnGoToHome" class="btn btn-secondary">
                <i class="fa fa-home"></i> <?= $language === 'fr' ? "Accueil" : "Home" ?>
            </button>
        </div>

        <?php
        if ($YesUseSwitchLang) {
            echo '
        <div class="language-toggle">
            <button id="btnLanguageToggle" class="btn btn-secondary">
                ' . ($language === 'fr' ? 'Switch to English' : 'Passer au Fran�ais') . '
            </button>
        </div>';
        }
        ?>
        <div class="header">
            <img src="assets/images/drhtLogo01.png" alt="Logo" height="50px">
            <span
                class="fs-4 d-none"><?= $language === 'fr' ? "Bienvenue � Reoleweb" : "Welcome to Reoleweb" ?></span>
        </div>
        <div class="content center-container">
            <div class="form-container">
                <h2 class="text-center text-primary mb-4">
                    <?= $language === 'fr' ? "Impression Badge repr�sentant" : "Printing Representative Badge" ?></h2>
                <h3 class="text-center text-primary mb-4"><?php $champnom . " " . $champprenom ?></h3>
                <div class="mb-3" id="divalert">
                    <div class="alert alert-success text-center" id="successAlert" style="display: none;" role="alert"></div>
                </div>
                <form id="pdfForm" method="post" style="display:inline;">
                    <input type="hidden" name="confirmation" value="1">
                    <input type="hidden" name="companyName" value="<?php echo $companyName; ?>">
                    <input type="hidden" name="champActivite" value="<?php echo $champActivite; ?>">
                    <input type="hidden" name="companyId" value="<?php echo $companyId; ?>">
                    <input type="hidden" name="champcivilite" value="<?php echo $champcivilite; ?>">
                    <input type="hidden" name="champnom" value="<?php echo $champnom; ?>">
                    <input type="hidden" name="champnomId" value="<?php echo $champnomId; ?>">
                    <input type="hidden" name="champprenom" value="<?php echo $champprenom; ?>">
                    <input type="hidden" name="champsecteur" value="<?php echo $champsecteur; ?>">
                    <input type="hidden" name="secteurId" value="<?php echo $secteurId; ?>">
                    <input type="hidden" name="champcontactPerson" value="<?php echo $champcontactPerson; ?>">
                    <input type="hidden" name="contactId" value="<?php echo $contactId; ?>">
                    <input type="hidden" name="champDateDebut" value="<?php echo $champDateDebut; ?>">
                    <input type="hidden" name="champHeureDebut" value="<?php echo $champHeureDebut; ?>">
                    <input type="hidden" name="champDatefin" value="<?php echo $champDatefin; ?>">
                    <input type="hidden" name="champHeurefin" value="<?php echo $champHeurefin; ?>">
                    <button type="button" id="BtnPrint" class="btn btn-primary w-100" onclick="generatePDF()">
                        <i class="bi bi-printer"></i> <?= $language === 'fr' ? "Imprimez votre badge" : "Print your badge" ?>
                    </button>
                </form>
                <br />
            </div>
        </div>
        <div class="modal fade" id="inactivityModal" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel">
                            <?= $language === 'fr' ? "Avertissement d'inactivit�" : "Inactivity Warning" ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><?= $language === 'fr' ? "Vous serez renvoy� vers la page d'accueil dans" : "You will be returned to the home page in" ?>
                            <span id="countdown">30</span> <?= $language === 'fr' ? "secondes..." : "seconds..." ?>
                        </p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" name="stayBtn"
                            id="stayBtn"><?= $language === 'fr' ? "Rester sur la page" : "Stay on Page" ?></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer">
            <span>Tous droits r�serv�s � <?= $yearVersion . ' ' . $compagnyName ?></span>
        </div>

<?php

        if ($useOnlyFirstDate) {
            echo '<script>const useOnlyFirstDate = true;</script>';
        } else {
            echo '<script>const useOnlyFirstDate = false;</script>';
        }
    }
}

