<?php

namespace Views;

use Views\VariousViewsHtml;

class VisiteurVariousViewsHtml extends VariousViewsHtml {
    
    private $pathPrefix = '../'; // Toujours utiliser '../' pour l'interface visiteur
    
    public function __construct() {
        // Pour l'interface visiteur, on utilise toujours '../' car elle est dans un sous-répertoire
        $this->pathPrefix = '../';
        
        parent::__construct();
    }
    
    public function generateHeader($useChart, $useDataTables, $title, $type) {
        global $NoIndex, $NomSite, $description, $keywords, $UrlDomain;
        
        $noIndexMeta = (isset($NoIndex) && $NoIndex) ? '<meta name="robots" content="noindex">' : '';
        
        echo '<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="' . htmlspecialchars($description ?? '') . '">
    <meta name="keywords" content="' . htmlspecialchars($keywords ?? '') . '">
    ' . $noIndexMeta . '
    <title>' . htmlspecialchars($title) . '</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="' . $this->pathPrefix . 'assets/images/favicon.ico">
    
    <!-- Bootstrap CSS -->
    <link href="' . $this->pathPrefix . 'assets/vendor/bootstrap-5.2.3/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link href="' . $this->pathPrefix . 'assets/vendor/bootstrap-icons-1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="' . $this->pathPrefix . 'assets/vendor/fontawesome-free-5.2.0-web/css/all.min.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link href="' . $this->pathPrefix . 'assets/css/utils.css" rel="stylesheet">
    <link href="' . $this->pathPrefix . 'assets/css/visiteur.css" rel="stylesheet">
    
    <!-- DataTables CSS -->
    <link href="' . $this->pathPrefix . 'assets/vendor/DataTables/datatables.min.css" rel="stylesheet">
    <link href="' . $this->pathPrefix . 'assets/vendor/DataTables/buttons.dataTables.min.css" rel="stylesheet">
    
    <!-- Chart.js si nécessaire -->
    ';
    
    if ($useChart) {
        echo '<script src="' . $this->pathPrefix . 'assets/vendor/chart.js-4.4.0/chart.min.js"></script>';
    }
    
    echo '
</head>
<body>';
    }
    
    public function generateFooter($useChart, $useDataTables, $type) {
        echo '
    <!-- jQuery -->
    <script src="' . $this->pathPrefix . 'assets/vendor/jQuery-3.7.1/jquery-3.7.1.min.js"></script>
    
    <!-- Bootstrap JS -->
    <script src="' . $this->pathPrefix . 'assets/vendor/bootstrap-5.2.3/js/bootstrap.bundle.min.js"></script>
    
    <!-- DataTables JS -->
    <script src="' . $this->pathPrefix . 'assets/vendor/DataTables/jquery.dataTables.min.js"></script>
    <script src="' . $this->pathPrefix . 'assets/vendor/DataTables/datatables.min.js"></script>
    <script src="' . $this->pathPrefix . 'assets/vendor/DataTables/dataTables.buttons.min.js"></script>
    <script src="' . $this->pathPrefix . 'assets/vendor/DataTables/buttons.html5.min.js"></script>
    <script src="' . $this->pathPrefix . 'assets/vendor/DataTables/buttons.print.min.js"></script>
    <script src="' . $this->pathPrefix . 'assets/vendor/DataTables/buttons.colVis.min.js"></script>
    
    <!-- Custom JS -->
    <script src="' . $this->pathPrefix . 'assets/js/script.js"></script>
    
    <script>
        $(document).ready(function() {
            // Initialisation DataTables avec boutons
            if ($.fn.DataTable) {
                $(".dataTable").DataTable({
                    "language": {
                        "url": "' . $this->pathPrefix . 'assets/vendor/DataTables/French.json"
                    },
                    "responsive": true,
                    "pageLength": 25,
                    "dom": "Bfrtip",
                    "buttons": [
                        "copy", "csv", "excel", "pdf", "print", "colvis"
                    ]
                });
            }
        });
    </script>
</body>
</html>';
    }
    
    // Méthodes d'erreur héritées et adaptées
    public function showInstallError($type) {
        echo "<div class='container mt-5'>";
        echo "<div class='alert alert-danger'>";
        echo "<h3>Erreur d'installation</h3>";
        echo "<p>Type d'erreur: " . htmlspecialchars($type) . "</p>";
        echo "</div>";
        echo "</div>";
    }

    public function showMysqlError() {
        echo "<div class='container mt-5'>";
        echo "<div class='alert alert-danger'>";
        echo "<h3>Erreur de base de données</h3>";
        echo "<p>Impossible de se connecter à la base de données.</p>";
        echo "</div>";
        echo "</div>";
    }

    public function showMaintenance($host) {
        echo "<div class='container mt-5'>";
        echo "<div class='alert alert-warning'>";
        echo "<h3>Maintenance en cours</h3>";
        echo "<p>Le site est actuellement en maintenance. Host: " . htmlspecialchars($host) . "</p>";
        echo "</div>";
        echo "</div>";
    }
}
?>