<?PHP
namespace Views;

use Views\FooterHtml as ViewsFooterHtml;

class VariousViewsHtml
{
    public $NomSiteCap;
    public function __construct() {}
    public function showInstallError($error)
    {
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");
        extract($_REQUEST, EXTR_PREFIX_ALL | EXTR_REFS, 'v');

?>
        <div class="container-fluid-taghilt">
            <div class="row">
                <style>
                    .alert-overlay {
                        position: fixed;
                        top: 0;
                        left: 0;
                        width: 100%;
                        height: 100%;
                        background-color: rgba(0, 0, 0, 0.5);
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        z-index: 9999;
                    }
                </style>
                <div class="alert-overlay">
                    <div class="alert alert-danger text-center p-4">
                        <h4 class="alert-heading">Attention !</h4>
                        <?PHP
                        if ($error == 'renameinstall') {
                        ?>
                            <p>Le dossier <strong>install</strong> existe toujours sur le serveur.</p>
                            <hr>
                            <p class="mb-0">Veuillez le renommer ou le supprimer pour des raisons de sécurité.</p>
                        <?PHP
                        } else if ($error == 'pathinstallExists') {
                        ?>
                            <p>Il semble que l'application n'est pas installée sur ce serveur.</p>
                            <hr>
                            <p class="mb-0">
                                Veuillez lancer le programme d'installation en cliquant sur le lien ci-dessous :
                            </p>
                            <a class="btn btn-primary mt-3" href="install/index.php">
                                Lancer l'installation
                            </a>
                        <?PHP
                        } else if ($error == 'pathinstallnotExists') {
                        ?>
                            <p>Le fichier <strong>config.php</strong> est manquant et le dossier <strong>install</strong> est introuvable.</p>
                            <hr>
                            <p class="mb-0">Merci de vérifier votre installation ou de restaurer ces éléments avant de continuer.</p>
                        <?PHP
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    <?PHP
    }

    public function showMaintenance($connectedHost)
    {
    ?>
        <div class="container-fluid-taghilt">
            <div class="row">
                <style>
                    body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        height: 100vh;
                        background-color: #f8f9fa;
                        text-align: center;
                    }
                </style>
                <div class="maintenance-container">
                    <h1>🚧 Site en Maintenance 🚧 <br> numéro de poste : <?= $connectedHost ?></h1>
                    <p>Nous travaillons actuellement sur des améliorations. Revenez bientôt !</p>
                    <p>Merci pour votre patience.</p>
                    <p>Si vous avez des suggestions ou besoin d'informations, n'hésitez pas à me contacter au <b>4072</p>.</p>
                </div>
            </div>
        </div>
    <?PHP
    }
    public function showMysqlError()
    {
    ?>
        <div class="container-fluid-taghilt">
            <div class="row">
                <style>
                    .alert-overlay {
                        position: fixed;
                        top: 0;
                        left: 0;
                        width: 100%;
                        height: 100%;
                        background-color: rgba(0, 0, 0, 0.5);
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        z-index: 9999;
                    }
                </style>
                <div class="alert-overlay">
                    <div class="alert alert-danger text-center p-4 shadow rounded" style="max-width: 500px;">
                        <h4 class="alert-heading mb-3">❗ Erreur de connexion à la base de données</h4>
                        <p class="mb-3">
                            Il est impossible de se connecter à la base de données. Cela peut être dû à des informations incorrectes ou manquantes dans le fichier <strong>config.php</strong>.
                        </p>
                        <hr>
                        <p class="mb-3">
                            Pour résoudre ce problème :
                        <ul class="text-start mt-2">
                            <li>Vérifiez et modifiez les paramètres de connexion dans <strong>config.php</strong>.</li>
                            <li>Ou relancez le programme d'installation pour reconfigurer votre application.</li>
                        </ul>
                        </p>
                        <a class="btn btn-primary mt-2" href="install/index.php">
                            Lancer l'installation
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?PHP
    }

    public function showAccessDenied($userRole = '', $requiredLevel = 40)
    {
    ?>
        <div class="container-fluid-taghilt">
            <div class="row">
                <style>
                    .alert-overlay {
                        position: fixed;
                        top: 0;
                        left: 0;
                        width: 100%;
                        height: 100%;
                        background-color: rgba(0, 0, 0, 0.5);
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        z-index: 9999;
                    }
                </style>
                <div class="alert-overlay">
                    <div class="alert alert-warning text-center p-4 shadow rounded" style="max-width: 600px;">
                        <h4 class="alert-heading mb-3">🚫 Accès non autorisé</h4>
                        <p class="mb-3">
                            <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i><br>
                            Vous n'avez pas les permissions nécessaires pour accéder à cette page.
                        </p>
                        <hr>
                        <div class="text-start">
                            <p><strong>Votre rôle :</strong> <?= htmlspecialchars($userRole) ?: 'Non défini' ?></p>
                            <p><strong>Niveau requis :</strong> <?= $requiredLevel >= 80 ? 'Administrateur' : ($requiredLevel >= 40 ? 'Agent immobilier' : 'Utilisateur standard') ?></p>
                        </div>
                        <hr>
                        <p class="mb-3">
                            <strong>Que faire ?</strong>
                        </p>
                        <ul class="text-start">
                            <li>Contactez votre administrateur pour obtenir les droits nécessaires</li>
                            <li>Vérifiez que vous êtes connecté avec le bon compte</li>
                            <li>Retournez à la page d'accueil pour accéder aux fonctionnalités autorisées</li>
                        </ul>
                        <div class="mt-4">
                            <a class="btn btn-primary me-2" href="admin/index.php">
                                <i class="fas fa-arrow-left me-1"></i> Retour à l'accueil
                            </a>
                            <a class="btn btn-secondary" href="admin/index.php?page=vsts&typePage=vv">
                                <i class="fas fa-house-user"></i> Mes annonces
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?PHP
    }

    public function generateHeader($useChart, $useDataTables, $title, $type)
    {

    ?>
        <!DOCTYPE html>
        <html>

        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
            <meta name="author" content="Ahmed ZERZIH">
            <title><?= $title ?></title>
            <link rel="icon" href="assets/images/favicon.ico" type="image/x-icon">
            <link rel="stylesheet" type="text/css" href="assets/vendor/bootstrap-5.2.3/css/bootstrap.min.css" />
            <!-- FontAwesome from CDN (more reliable than local incomplete installation) -->
            <link rel="stylesheet" href="assets/vendor/fontawesome-free-5.2.0-web/css/all.min.css" crossorigin="anonymous" />
            <link rel="stylesheet" type="text/css" href="assets/vendor/bootstrap-icons-1.11.3/font/bootstrap-icons.min.css">

            <?PHP
            if ($useDataTables) {
            ?>
                <link rel="stylesheet" type="text/css" href="assets/vendor/DataTables/datatables.min.css" />
                <link rel="stylesheet" type="text/css" href="assets/vendor/DataTables/jquery.dataTables.min.css" />
                <link rel="stylesheet" type="text/css" href="assets/vendor/DataTables/buttons.dataTables.css" />
                <link rel="stylesheet" type="text/css" href="assets/vendor/DataTables/fixedColumns.dataTables.min.css">

            <?PHP
            }
            ?>

            <?PHP
            if ($type == 'visiteur') {
            ?>
                <link rel="stylesheet" type="text/css" href="assets/css/visiteur.css" />
            <?PHP
            } else {
            ?>
                <link rel="stylesheet" type="text/css" href="assets/css/utils.css" />
            <?PHP
            }
            ?>
            <link rel="stylesheet" type="text/css" href="assets/vendor/jquery-ui-1.14.1/jquery-ui.min.css">
            <?PHP
            if ($useChart) {
            ?>
                <link rel="stylesheet" type="text/css" href="assets/vendor/Highcharts-6.1.1/css/highcharts.css">
            <?PHP
            }

            ?>

        </head>

        <body class="d-flex flex-column vh-100">
        <?PHP
    }

    public function generateFooter($useChart, $useDataTables, $type)
    {
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");
        
        // Inclure explicitement le fichier FooterHtml
        include_once(__DIR__ . "/FooterHtml.php");
        
        // Inclure le footer HTML (modal d'inactivité) avant les scripts
        $navBarHtml = new FooterHtml();
        $navBarHtml->showFooter();
        
        ?>
            <script src="assets/vendor/Poppers.js-2.4/popper.min.js"></script>
            <!-- FontAwesome JS not needed when using CSS version from CDN -->
            <!-- <script src="assets/vendor/fontawesome-free-5.2.0-web/js/all.min.js"></script> -->
            <script src="assets/vendor/jQuery-3.7.1/jquery-3.7.1.min.js"></script>
            <script src="assets/vendor/bootstrap-5.2.3/js/bootstrap.bundle.min.js"></script>

            <?PHP
            if ($getConfig) {
                if ($useDataTables) {
            ?>
                    <script src="assets/vendor/DataTables/datatables.min.js"></script>
                    <script src="assets/vendor/DataTables/jquery.dataTables.min.js"></script>
                    <script src="assets/vendor/DataTables/datatables.js"></script>
                    <script src="assets/vendor/DataTables/dataTables.buttons.js"></script>
                    <script src="assets/vendor/DataTables/buttons.dataTables.js"></script>
                    <script src="assets/vendor/DataTables/jszip.min.js"></script>
                    <script src="assets/vendor/DataTables/pdfmake.min.js"></script>
                    <script src="assets/vendor/DataTables/vfs_fonts.js"></script>
                    <script src="assets/vendor/DataTables/buttons.html5.min.js"></script>
                    <script src="assets/vendor/DataTables/buttons.print.min.js"></script>
                    <script src="assets/vendor/DataTables/dataTables.fixedColumns.min.js"></script>

                    <script src="assets/vendor/jquery-ui-1.14.1/jquery-ui.min.js"></script>
                    <script src="assets/vendor/DatePicker/datepicker-fr-CA.js"></script>

                <?PHP
                }

                $inactivity_time = (int) $inactivity_time;

                if (isset($inactivity_time)) {
                ?>
                    <script>
                        let inactivityTime = <?= $inactivity_time ?> * 60 * 1000;
                    </script>
                <?PHP
                }
            }

            if ($type == 'visiteur') {
                ?>
                <script src="assets/js/Visiteur.js?v=<?= rand(1000, 9999) ?>"></script>
            <?PHP
            } else {
                // Determine which script to load based on current page
                $currentPage = isset($_GET['page']) ? $_GET['page'] : '';
                
                if ($currentPage == 'user') {
                ?>
                    <script src="assets/js/Users.js?v=<?= rand(1000, 9999) ?>"></script>
                <?PHP
                } else {
                ?>
                    <script src="assets/js/AnnonceClient.js?v=<?= rand(1000, 9999) ?>"></script>
                <?PHP
                }
            }

            if ($useChart) {
            ?>
                <script src="assets/vendor/Highcharts-6.1.1/js/highcharts.js"></script>
            <?PHP
            }
            ?>

        </body>

        </html>
        <?PHP
        }

        public function getFooter()
        {
            // Inclure explicitement le fichier FooterHtml
            include_once(__DIR__ . "/FooterHtml.php");
            
            $navBarHtml = new FooterHtml();
            $navBarHtml->showFooter();
        }

        public function getDashBoard($NomSiteCap)
        {

            //$userClass = new AnnonceClient($this->conn);
            //$userClass->afficherDashBoard($NomSiteCap);
        }
    }

?>

