<?PHP
namespace Views;

class RolesHtml
{
    static public function afficheLiteRoles($result)
    {
        include_once("FunctionHtml.php");
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");
        $displayOld = false;
?>
        <main class="<?php echo $mainClass; ?> ms-sm-auto px-md-4 py-4" id="main-content" style="display: none;">
            <div class="card card-mh-90vh">
                <div class="card-header">
                    <b>Liste des rôles</b>
                </div>
                <div class="card-body">

                    <?php
                    if (isset($_GET["msg"])) {
                        $msg = $_GET["msg"];
                        $alerts = [
                            "updated" => ["success", "fas fa-check-circle", "Rôle mis à jour avec succès."],
                            "deleted" => ["success", "fas fa-check-circle", "Rôle supprimé avec succès."],
                            "added" => ["success", "fas fa-check-circle", "Rôle ajoutée avec succès."],
                            "errorsupr" => ["warning", "fas fa-exclamation-triangle", "Erreur suppression, réessayez plus tard ou contactez ".$errorMsgService."."],
                            "erroraddedit" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnue, réessayez plus tard ou contactez ".$errorMsgService."."],
                            "errorajax" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnu, réessayez plus tard ou contactez ".$errorMsgService."."]
                        ];

                        if (array_key_exists($msg, $alerts)) {
                            list($alertType, $icon, $message) = $alerts[$msg];
                            echo '<div class="alert alert-' . $alertType . '" id="alertMessage" role="alert">
                <i class="' . $icon . '"></i> ' . $message . '
              </div>';
                        }
                    }
                    ?>
                    <table id="gridRoles" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Rôle</th>
                                <th>Commentaire</th>
                                <th>Dernière modification</th>
                                <th>Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            foreach ($result as $row) {
                                echo '
                                <tr>
                        <td style="text-align: center;" width="100px"><b>' . $row["id_role"] . '</b></td>
                        <td>' . $row["role_name"] . '</td>
                        <td>' . $row["role_comment"] . '</td>
                        <td style="text-align: center;">' . $row["lastmod"] . '</td>
                        <td style="text-align: center;" width="100px">
                        <a class="role-edit-link" title="Modifier rôle Num : ' . $row["id_role"] . '" data-id="' . $row["id_role"] . '"><span class="fas fa-edit m-1" style="color: green;"></span></a>
                        </td>
            </tr>';
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>ID</th>
                                <th>Rôle</th>
                                <th>Commentaire</th>
                                <th>Dernière modification</th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <div class="modal fade" id="modalFormAddEditRole" tabindex="-1" aria-labelledby="modalFormAddEditRoleLabel"
                aria-hidden="true" data-bs-backdrop="static">
                <div class="modal-dialog modal-xl modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalFormAddEditRoleLabel">Rôle - Ajout/Modification</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form name="formAddEditRole" id="formAddEditRole" action="#" method="post" enctype="multipart/form-data"
                            autocomplete="off">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <input type="hidden" id="idRoleToEdit" name="idRoleToEdit" value="" />
                                        <input type="hidden" id="page" name="page" value="Role" />
                                        <input type="hidden" id="typeSend" name="typeSend" value="" />

                                        <div class="alert alert-warning" id="alertMessageRoleModal" role="alert"></div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label" for="roleName">Nom du rôle <span class="text-danger">*</span></label>
                                            <input class="form-control" type="text" name="roleName" id="roleName" required
                                                value="" />
                                            <div id="roleNameError" class="invalid-feedback">Champ requis.</div>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label" for="roleComment">Commentaire (optionnel)</label>
                                            <textarea class="form-control" name="roleComment" id="roleComment" rows="2"
                                                style="resize: vertical;"> </textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Permissions</label>
                                        <div class="card border-primary">
                                            <div class="card-body" style="max-height: 50vh; overflow-y: auto;">
                                                <h6 class="card-title">Accès Tableau de Bord</h6>
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="voir_tdb" name="voir_tdb">
                                                    <label class="form-check-label" for="voir_tdb">Voir Tableau de Bord</label>
                                                </div>

                                                <hr>
                                                <h6 class="card-title">Fournisseurs</h6>
                                                <!-- Fournisseur switches -->
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="liste_fournisseurs" name="liste_fournisseurs"><label class="form-check-label" for="liste_fournisseurs">Autoriser accès à la liste des fournisseurs.</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="ajout_fournisseur" name="ajout_fournisseur"><label class="form-check-label" for="ajout_fournisseur">Ajout fournisseur</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="mod_fournisseur" name="mod_fournisseur"><label class="form-check-label" for="mod_fournisseur">Modification fournisseur</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="supp_fournisseur" name="supp_fournisseur"><label class="form-check-label" for="supp_fournisseur">Suppression fournisseur</label></div>

                                                <hr>
                                                <h6 class="card-title">Visiteurs</h6>
                                                <!-- Visiteur switches -->
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="liste_visiteurs" name="liste_visiteurs"><label class="form-check-label" for="liste_visiteurs">Autoriser accès à la liste des représentants.</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="ajout_visiteur" name="ajout_visiteur"><label class="form-check-label" for="ajout_visiteur">Ajout représentant</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="mod_visiteur" name="mod_visiteur"><label class="form-check-label" for="mod_visiteur">Modification représentant</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="supp_visiteur" name="supp_visiteur"><label class="form-check-label" for="supp_visiteur">Suppression représentant</label></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Permissions (Suite...)</label>
                                        <div class="card border-primary">
                                            <div class="card-body" style="overflow-y: auto;">
                                                <h6 class="card-title">Visites</h6>
                                                <!-- Visites switches -->
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="liste_visites_visiteurs" name="liste_visites_visiteurs"><label class="form-check-label" for="liste_visites_visiteurs">Autoriser accès à la liste des visites visiteurs.</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="ajout_visites_visiteurs" name="ajout_visites_visiteurs"><label class="form-check-label" for="ajout_visites_visiteurs">Ajout visite visiteur</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="mod_visites_visiteurs" name="mod_visites_visiteurs"><label class="form-check-label" for="mod_visites_visiteurs">Modification visite visiteur</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="supp_visites_visiteurs" name="supp_visites_visiteurs"><label class="form-check-label" for="supp_visites_visiteurs">Suppression visite visiteur</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="imp_visites_visiteurs" name="imp_visites_visiteurs"><label class="form-check-label" for="imp_visites_visiteurs">Impression visite visiteur</label></div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Permissions (Suite...)</label>
                                        <div class="card border-primary">
                                            <div class="card-body" style="overflow-y: auto;">
                                                <h6 class="card-title">Paramètres</h6>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="parametres" name="parametres"><label class="form-check-label" for="parametres">Paramètres</label></div>
                                            </div>
                                        </div>
                                        <div class="card border-primary mt-3">
                                            <div class="card-body" style="overflow-y: auto;">
                                                <h6 class="card-title">Utilisateurs</h6>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="liste_utilisateurs" name="liste_utilisateurs"><label class="form-check-label" for="liste_utilisateurs">Autoriser accès à la liste des utilisateurs.</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="ajout_utilisateur" name="ajout_utilisateur"><label class="form-check-label" for="ajout_utilisateur">Ajout utilisateur</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="mod_utilisateur" name="mod_utilisateur"><label class="form-check-label" for="mod_utilisateur">Modification utilisateur</label></div>
                                                <div class="form-check form-switch"><input class="form-check-input" type="checkbox" id="supp_utilisateur" name="supp_utilisateur"><label class="form-check-label" for="supp_utilisateur">Suppression utilisateur</label></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="modal-footer d-flex justify-content-between align-items-center">
                            <small class="text-muted"><span class="text-danger">*</span> Champs obligatoires</small>
                            <div>
                                <button type="button" id="confirmSubmitRole" class="btn btn-primary">Enregistrer</button>
                                <button type="button" id="cancelSubmitRole" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

<?PHP
    }
} ?>
