<?php
use Views\PublicHeaderFooter;

PublicHeaderFooter::renderHeader("Taghilt - Créer un Compte", $viewData['pathPrefix']);
?>

<style>
    body {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
    }
    
    .register-container {
        min-height: calc(100vh - 160px);
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 40px 20px;
    }
    
    .register-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        border-radius: 20px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        border: 1px solid rgba(255, 255, 255, 0.2);
        overflow: hidden;
        max-width: 600px;
        width: 100%;
        padding: 3rem;
    }
    
    .brand-logo {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 2rem;
    }
    
    .form-floating label {
        color: #666;
    }
    
    .form-control {
        border-radius: 12px;
        border: 2px solid #e9ecef;
        padding: 0.75rem 1rem;
        transition: all 0.3s ease;
    }
    
    .form-control:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }
    
    .btn-register {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        border-radius: 12px;
        padding: 0.75rem 2rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
        transition: all 0.3s ease;
    }
    
    .btn-register:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
    }
    
    .feature-list {
        background: rgba(102, 126, 234, 0.1);
        border-radius: 12px;
        padding: 1.5rem;
        margin: 1rem 0;
    }
    
    .feature-item {
        display: flex;
        align-items: center;
        margin-bottom: 0.75rem;
    }
    
    .feature-item:last-child {
        margin-bottom: 0;
    }
    
    .feature-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 1rem;
        color: white;
    }
</style>

<div class="register-container">
    <div class="register-card">
        <div class="text-center">
            <div class="brand-logo">
                <i class="fas fa-home fa-2x text-white"></i>
            </div>
            
            <h2 class="fw-bold mb-2">Rejoignez Taghilt</h2>
            <p class="text-muted mb-4">Créez votre compte et commencez à vendre</p>
        </div>

        <!-- Avantages -->
        <div class="feature-list">
            <h6 class="fw-bold mb-3 text-center">
                <i class="fas fa-star text-warning me-2"></i>
                Avec votre compte Taghilt :
            </h6>
            
            <div class="feature-item">
                <div class="feature-icon">
                    <i class="fas fa-plus"></i>
                </div>
                <div>
                    <strong>Publiez vos annonces</strong><br>
                    <small class="text-muted">Maisons, appartements, terrains...</small>
                </div>
            </div>
            
            <div class="feature-item">
                <div class="feature-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div>
                    <strong>Gérez vos ventes</strong><br>
                    <small class="text-muted">Suivi des visites et négociations</small>
                </div>
            </div>
            
            <div class="feature-item">
                <div class="feature-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div>
                    <strong>Contactez les acheteurs</strong><br>
                    <small class="text-muted">Messagerie intégrée sécurisée</small>
                </div>
            </div>
        </div>

        <!-- Message d'alerte -->
        <div id="registerAlert" class="alert d-none mt-3" role="alert"></div>
        
        <!-- Indicateur de chargement -->
        <div id="registerLoading" class="text-center mt-3 d-none">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Création du compte...</span>
            </div>
            <p class="mt-2 text-muted">Création de votre compte en cours...</p>
        </div>

        <!-- Formulaire d'inscription -->
        <form id="registerForm" class="needs-validation" novalidate>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="form-floating">
                        <input type="text" class="form-control" id="prenom" name="prenom" placeholder="Prénom" required>
                        <label for="prenom"><i class="fas fa-user me-2"></i>Prénom</label>
                        <div class="invalid-feedback">
                            Veuillez saisir votre prénom.
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="form-floating">
                        <input type="text" class="form-control" id="nom" name="nom" placeholder="Nom" required>
                        <label for="nom"><i class="fas fa-user me-2"></i>Nom</label>
                        <div class="invalid-feedback">
                            Veuillez saisir votre nom.
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-floating mb-3">
                <input type="email" class="form-control" id="email" name="email" placeholder="Email" required>
                <label for="email"><i class="fas fa-envelope me-2"></i>Adresse Email</label>
                <div class="invalid-feedback">
                    Veuillez saisir une adresse email valide.
                </div>
            </div>

            <div class="form-floating mb-3">
                <input type="tel" class="form-control" id="telephone" name="telephone" placeholder="Téléphone" required>
                <label for="telephone"><i class="fas fa-phone me-2"></i>Numéro de Téléphone</label>
                <div class="invalid-feedback">
                    Veuillez saisir votre numéro de téléphone.
                </div>
            </div>

            <div class="form-floating mb-3">
                <input type="password" class="form-control" id="password" name="password" placeholder="Mot de passe" required minlength="6">
                <label for="password"><i class="fas fa-lock me-2"></i>Mot de Passe</label>
                <div class="invalid-feedback">
                    Le mot de passe doit contenir au moins 6 caractères.
                </div>
            </div>

            <div class="form-floating mb-3">
                <input type="password" class="form-control" id="confirm_password" name="confirm_password" placeholder="Confirmer le mot de passe" required>
                <label for="confirm_password"><i class="fas fa-lock me-2"></i>Confirmer le Mot de Passe</label>
                <div class="invalid-feedback">
                    Les mots de passe ne correspondent pas.
                </div>
            </div>

            <div class="form-check mb-4">
                <input class="form-check-input" type="checkbox" id="accept_terms" name="accept_terms" required>
                <label class="form-check-label" for="accept_terms">
                    J'accepte les <a href="#" target="_blank">Conditions d'Utilisation</a> et la <a href="#" target="_blank">Politique de Confidentialité</a>
                </label>
                <div class="invalid-feedback">
                    Vous devez accepter les conditions d'utilisation.
                </div>
            </div>

            <div class="d-grid mb-3">
                <button type="submit" class="btn btn-register text-white fw-bold">
                    <i class="fas fa-user-plus me-2"></i>
                    Créer Mon Compte
                </button>
            </div>

            <div class="text-center">
                <small class="text-muted">
                    Vous avez déjà un compte ? 
                    <a href="<?= $viewData['pathPrefix'] ?>index.php?page=login" class="text-decoration-none">Se connecter</a>
                </small>
            </div>
        </form>
    </div>
</div>

<script>
// Validation et soumission du formulaire
document.addEventListener('DOMContentLoaded', function() {
    const registerForm = document.getElementById('registerForm');
    const registerAlert = document.getElementById('registerAlert');
    const registerLoading = document.getElementById('registerLoading');
    
    // Validation en temps réel des mots de passe
    const password = document.getElementById('password');
    const confirmPassword = document.getElementById('confirm_password');
    
    function validatePasswords() {
        if (confirmPassword.value && password.value !== confirmPassword.value) {
            confirmPassword.setCustomValidity('Les mots de passe ne correspondent pas');
        } else {
            confirmPassword.setCustomValidity('');
        }
    }
    
    password.addEventListener('input', validatePasswords);
    confirmPassword.addEventListener('input', validatePasswords);
    
    // Soumission du formulaire
    registerForm.addEventListener('submit', function(e) {
        e.preventDefault();
        
        if (!registerForm.checkValidity()) {
            e.stopPropagation();
            registerForm.classList.add('was-validated');
            return;
        }
        
        // Afficher le chargement
        registerLoading.classList.remove('d-none');
        registerAlert.classList.add('d-none');
        
        // Préparer les données
        const formData = new FormData(registerForm);
        
        // Envoyer la requête
        fetch('<?= $viewData['pathPrefix'] ?>process_register.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            registerLoading.classList.add('d-none');
            
            if (data.success) {
                registerAlert.className = 'alert alert-success mt-3';
                registerAlert.textContent = data.message;
                registerAlert.classList.remove('d-none');
                
                // Redirection après un délai
                setTimeout(() => {
                    window.location.href = '<?= $viewData['pathPrefix'] ?>visiteur/index.php';
                }, 2000);
            } else {
                registerAlert.className = 'alert alert-danger mt-3';
                registerAlert.textContent = data.message;
                registerAlert.classList.remove('d-none');
            }
        })
        .catch(error => {
            registerLoading.classList.add('d-none');
            registerAlert.className = 'alert alert-danger mt-3';
            registerAlert.textContent = 'Erreur de connexion. Veuillez réessayer.';
            registerAlert.classList.remove('d-none');
            console.error('Erreur:', error);
        });
    });
});
</script>

<?php PublicHeaderFooter::renderFooter($viewData['pathPrefix']); ?>