<?php
use Views\PublicHeaderFooter;

PublicHeaderFooter::renderHeader("Taghilt - Connexion", $viewData['pathPrefix']);
?>

<style>
    body {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
    }
    
    .login-container {
        min-height: calc(100vh - 160px);
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 40px 20px;
    }
    
    .login-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        border-radius: 20px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        border: 1px solid rgba(255, 255, 255, 0.2);
        overflow: hidden;
        max-width: 800px;
        width: 100%;
    }
    
    .login-left {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 3rem;
        position: relative;
    }
    
    .brand-logo {
        width: 80px;
        height: 80px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 2rem;
    }
    
    .feature-item {
        display: flex;
        align-items: center;
        margin-bottom: 1.5rem;
        color: white;
    }
    
    .feature-icon {
        width: 50px;
        height: 50px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 1rem;
    }
    
    .login-right {
        padding: 3rem;
    }
    
    .form-control {
        border-radius: 12px;
        border: 2px solid #e9ecef;
        padding: 0.75rem 1rem;
        transition: all 0.3s ease;
    }
    
    .form-control:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }
    
    .btn-login {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        border-radius: 12px;
        padding: 0.75rem;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    
    .btn-login:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
    }
    
    .stats-item {
        text-align: center;
        padding: 1rem 0;
    }
    
    .stats-number {
        font-size: 2rem;
        font-weight: bold;
        margin-bottom: 0.5rem;
    }
</style>

<div class="login-container">
    <div class="login-card">
        <div class="row g-0 h-100">
            <!-- Partie gauche - Branding et features -->
            <div class="col-lg-6 login-left">
                <div class="brand-logo">
                    <i class="fas fa-home fa-2x text-white"></i>
                </div>
                
                <h2 class="fw-bold mb-3 text-white">Taghilt</h2>
                <p class="fs-5 mb-4 text-white opacity-75">Votre plateforme immobilière de confiance</p>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-search text-white"></i>
                    </div>
                    <div>
                        <h6 class="mb-1">Recherche Avancée</h6>
                        <small class="opacity-75">Trouvez le bien parfait selon vos critères</small>
                    </div>
                </div>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-chart-line text-white"></i>
                    </div>
                    <div>
                        <h6 class="mb-1">Estimations Précises</h6>
                        <small class="opacity-75">Prix du marché en temps réel</small>
                    </div>
                </div>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt text-white"></i>
                    </div>
                    <div>
                        <h6 class="mb-1">Transactions Sécurisées</h6>
                        <small class="opacity-75">Accompagnement professionnel garanti</small>
                    </div>
                </div>
                
                <!-- Statistiques -->
                <div class="row mt-4 pt-4 border-top border-white border-opacity-25">
                    <div class="col-4 stats-item">
                        <div class="stats-number text-white">500+</div>
                        <small class="opacity-75">Biens</small>
                    </div>
                    <div class="col-4 stats-item">
                        <div class="stats-number text-white">98%</div>
                        <small class="opacity-75">Satisfaction</small>
                    </div>
                    <div class="col-4 stats-item">
                        <div class="stats-number text-white">24h</div>
                        <small class="opacity-75">Support</small>
                    </div>
                </div>
            </div>
            
            <!-- Partie droite - Formulaire de connexion -->
            <div class="col-lg-6 login-right">
                <div class="text-center mb-4">
                    <h3 class="fw-bold text-dark mb-2">Bienvenue</h3>
                    <p class="text-muted">Connectez-vous à votre espace immobilier</p>
                </div>

                <!-- Formulaire de connexion -->
                <form id="loginForm" action="<?= $viewData['pathPrefix'] ?>visiteur/index.php?page=lsl" method="post" class="needs-validation" novalidate>
                    <div class="form-floating mb-3">
                        <input type="text" class="form-control" id="user" name="user" placeholder="Nom d'utilisateur" required>
                        <label for="user"><i class="fas fa-user me-2"></i>Nom d'utilisateur</label>
                        <div class="invalid-feedback">
                            Veuillez saisir votre nom d'utilisateur.
                        </div>
                    </div>

                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" id="password" name="password" placeholder="Mot de passe" required>
                        <label for="password"><i class="fas fa-lock me-2"></i>Mot de passe</label>
                        <div class="input-group-append position-absolute" style="right: 15px; top: 50%; transform: translateY(-50%); z-index: 10;">
                            <button class="btn btn-link p-0" type="button" id="togglePassword">
                                <i class="fas fa-eye text-muted"></i>
                            </button>
                        </div>
                        <div class="invalid-feedback">
                            Veuillez saisir votre mot de passe.
                        </div>
                    </div>

                    <div class="form-check mb-4">
                        <input class="form-check-input" type="checkbox" id="rememberMe" name="rememberMe" value="1">
                        <label class="form-check-label" for="rememberMe">
                            Se souvenir de moi
                        </label>
                    </div>

                    <button type="submit" class="btn btn-login w-100 text-white fw-bold mb-3">
                        <i class="fas fa-sign-in-alt me-2"></i>
                        Se connecter
                    </button>

                    <div class="row">
                        <div class="col-6">
                            <a href="#" class="text-decoration-none text-muted small">
                                <i class="fas fa-key me-1"></i>
                                Mot de passe oublié ?
                            </a>
                        </div>
                        <div class="col-6 text-end">
                            <a href="<?= $viewData['pathPrefix'] ?>index.php?page=register" class="text-decoration-none small">
                                <i class="fas fa-user-plus me-1"></i>
                                Créer un compte
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle password visibility
    const togglePassword = document.getElementById('togglePassword');
    const passwordInput = document.getElementById('password');
    
    if (togglePassword && passwordInput) {
        togglePassword.addEventListener('click', function() {
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            
            const icon = this.querySelector('i');
            icon.classList.toggle('fa-eye');
            icon.classList.toggle('fa-eye-slash');
        });
    }
    
    // Form validation
    const loginForm = document.getElementById('loginForm');
    if (loginForm) {
        loginForm.addEventListener('submit', function(event) {
            if (!loginForm.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            loginForm.classList.add('was-validated');
        });
    }
});
</script>

<?php PublicHeaderFooter::renderFooter($viewData['pathPrefix']); ?>