<?php
use Views\PublicHeaderFooter;

PublicHeaderFooter::renderHeader("Taghilt - Plateforme Immobilière Algérienne", $viewData['pathPrefix']);
?>

<!-- Section Hero avec recherche -->
<section id="accueil" class="hero-section-wrapper d-flex align-items-center justify-content-center">
    <div class="container">
        <div class="hero-overlay rounded-5 shadow-lg">
            <div class="hero-content">
                <div class="col-lg-10 mx-auto text-center">
                    <!-- Titre principal -->
                    <div class="text-center text-white mb-5">
                        <h1 class="display-4 fw-bold mb-3" data-translate="hero_title">
                            Trouvez votre propriété idéale en Algérie
                        </h1>
                        <p class="lead" data-translate="hero_subtitle">
                            Des milliers de biens immobiliers à vendre et à louer partout en Algérie
                        </p>
                    </div>

                    <!-- Barre de recherche principale -->
                    <div class="search-box bg-white rounded-4 shadow-lg p-4">
                        <?php
                        // Récupérer les paramètres de la dernière recherche depuis la session
                        $lastSearch = $_SESSION['last_search_params'] ?? [];
                        ?>
                        <form id="search-form" class="search-form-modern" method="GET" action="index.php">
                            <input type="hidden" name="page" value="search">
                            <div class="search-inputs-wrapper">
                                <!-- Recherche de ville avec autocomplete -->
                                <div class="search-field search-field-city">
                                    <i class="fas fa-map-marker-alt search-icon"></i>
                                    <input 
                                        type="text" 
                                        id="city-search" 
                                        name="cities" 
                                        class="form-control-modern" 
                                        placeholder="Ville, commune, wilaya..."
                                        autocomplete="off"
                                        value=""
                                    >
                                    <!-- Champ caché pour stocker les villes sélectionnées -->
                                    <input type="hidden" id="cities-hidden" name="cities" value="<?= isset($lastSearch['cities']) ? htmlspecialchars($lastSearch['cities']) : '' ?>">
                                </div>

                                <!-- Type de transaction -->
                                <div class="search-field search-field-transaction">
                                    <i class="fas fa-handshake search-icon"></i>
                                    <select class="form-control-modern" name="transaction" id="transaction_type">
                                        <option value="">Type de transaction</option>
                                        <option value="vente" <?= isset($lastSearch['transaction']) && $lastSearch['transaction'] == 'vente' ? 'selected' : '' ?>>Vente</option>
                                        <option value="location" <?= isset($lastSearch['transaction']) && $lastSearch['transaction'] == 'location' ? 'selected' : '' ?>>Location</option>
                                    </select>
                                </div>

                                <!-- Type de propriété -->
                                <div class="search-field search-field-property">
                                    <i class="fas fa-building search-icon"></i>
                                    <select class="form-control-modern" name="property" id="property_type">
                                        <option value="">Type de propriété</option>
                                        <option value="appartement" <?= isset($lastSearch['property']) && $lastSearch['property'] == 'appartement' ? 'selected' : '' ?>>Appartement</option>
                                        <option value="villa" <?= isset($lastSearch['property']) && $lastSearch['property'] == 'villa' ? 'selected' : '' ?>>Villa</option>
                                        <option value="terrain" <?= isset($lastSearch['property']) && $lastSearch['property'] == 'terrain' ? 'selected' : '' ?>>Terrain</option>
                                        <option value="local_commercial" <?= isset($lastSearch['property']) && $lastSearch['property'] == 'local_commercial' ? 'selected' : '' ?>>Commerce</option>
                                        <option value="bureau" <?= isset($lastSearch['property']) && $lastSearch['property'] == 'bureau' ? 'selected' : '' ?>>Bureau</option>
                                        <option value="garage" <?= isset($lastSearch['property']) && $lastSearch['property'] == 'garage' ? 'selected' : '' ?>>Garage</option>
                                    </select>
                                </div>

                                <!-- Prix (avec toggle pour afficher le slider) -->
                                <div class="search-field search-field-price">
                                    <i class="fas fa-tag search-icon"></i>
                                    <button type="button" class="form-control-modern price-toggle" id="price-toggle">
                                        <span id="price-display">Budget</span>
                                        <i class="fas fa-chevron-down ms-2"></i>
                                    </button>
                                </div>

                                <!-- Bouton de recherche -->
                                <button type="submit" class="btn-search-modern">
                                    <i class="fas fa-search"></i>
                                    <span class="btn-text">Rechercher</span>
                                </button>
                            </div>

                            <!-- Autocomplete pour les villes (comme le panel Budget) -->
                            <div id="city-autocomplete" class="autocomplete-panel" style="display: none;"></div>


                            <!-- Villes sélectionnées (tags) -->
                            <div id="selected-cities-container" class="selected-cities-container" style="display: none;">
                                <div class="selected-cities-label">
                                    <i class="fas fa-map-marker-alt"></i>
                                    <span>Villes sélectionnées :</span>
                                </div>
                                <div id="selected-cities" class="selected-cities"></div>
                            </div>
                            <!-- Panel Prix Min/Max (caché par défaut) -->
                            <div id="price-panel" class="price-panel" style="display: none;">
                                <div class="price-panel-content">
                                    <div class="price-inputs">
                                        <div class="price-input-group">
                                            <label>Prix minimum</label>
                                            <input type="number" id="price-min" name="price_min" class="form-control" placeholder="0" min="0" step="100000" value="<?= isset($lastSearch['price_min']) ? $lastSearch['price_min'] : '' ?>">
                                            <span class="currency">DA</span>
                                        </div>
                                        <div class="price-separator">—</div>
                                        <div class="price-input-group">
                                            <label>Prix maximum</label>
                                            <input type="number" id="price-max" name="price_max" class="form-control" placeholder="50000000" min="0" step="100000" value="<?= isset($lastSearch['price_max']) ? $lastSearch['price_max'] : '' ?>">
                                            <span class="currency">DA</span>
                                        </div>
                                    </div>
                                    
                                    <div class="price-slider-container">
                                        <div class="price-slider-wrapper">
                                            <div class="price-slider-track" id="price-slider-track"></div>
                                            <div class="price-slider-range" id="price-slider-range"></div>
                                            <input type="range" id="price-slider-min" class="price-slider-input" min="0" max="50000000" step="100000" value="0">
                                            <input type="range" id="price-slider-max" class="price-slider-input" min="0" max="50000000" step="100000" value="50000000">
                                        </div>
                                        <div class="price-slider-labels">
                                            <span id="slider-label-min">0 DA</span>
                                            <span id="slider-label-max">50M DA</span>
                                        </div>
                                    </div>

                                    <div class="price-presets">
                                        <button type="button" class="preset-btn" data-min="0" data-max="5000000">Moins de 5M</button>
                                        <button type="button" class="preset-btn" data-min="5000000" data-max="10000000">5M - 10M</button>
                                        <button type="button" class="preset-btn" data-min="10000000" data-max="20000000">10M - 20M</button>
                                        <button type="button" class="preset-btn" data-min="20000000" data-max="50000000">Plus de 20M</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Section Statistiques -->
<section class="stats-section py-5">
    <div class="container">
        <div class="row text-center">
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-home"></i>
                    </div>
                    <h3 class="stat-number">500+</h3>
                    <p class="stat-label" data-translate="properties_available">Biens disponibles</p>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3 class="stat-number">1000+</h3>
                    <p class="stat-label" data-translate="satisfied_clients">Clients satisfaits</p>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <h3 class="stat-number">48</h3>
                    <p class="stat-label" data-translate="covered_wilayas">Wilayas couvertes</p>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-handshake"></i>
                    </div>
                    <h3 class="stat-number">98%</h3>
                    <p class="stat-label" data-translate="success_rate">Taux de réussite</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Section Services -->
<section id="services" class="services-section py-5 bg-light">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-8 text-center">
                <h2 class="display-5 fw-bold mb-4" data-translate="our_services">Nos Services</h2>
                <p class="lead text-muted" data-translate="services_subtitle">
                    Des solutions complètes pour tous vos besoins immobiliers
                </p>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="service-card h-100">
                    <div class="service-icon">
                        <i class="fas fa-search"></i>
                    </div>
                    <h4 data-translate="property_search">Recherche de Biens</h4>
                    <p data-translate="property_search_desc">
                        Trouvez le bien parfait grâce à notre moteur de recherche avancé et nos filtres personnalisés.
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4">
                <div class="service-card h-100">
                    <div class="service-icon">
                        <i class="fas fa-plus-circle"></i>
                    </div>
                    <h4 data-translate="property_listing">Publication d'Annonces</h4>
                    <p data-translate="property_listing_desc">
                        Vendez ou louez rapidement votre bien avec nos outils de publication simples et efficaces.
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4">
                <div class="service-card h-100">
                    <div class="service-icon">
                        <i class="fas fa-calculator"></i>
                    </div>
                    <h4 data-translate="property_valuation">Estimation Immobilière</h4>
                    <p data-translate="property_valuation_desc">
                        Obtenez une estimation précise de votre bien basée sur les prix du marché local.
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4">
                <div class="service-card h-100">
                    <div class="service-icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h4 data-translate="expert_advice">Conseils d'Experts</h4>
                    <p data-translate="expert_advice_desc">
                        Bénéficiez de l'accompagnement de nos experts immobiliers tout au long de votre projet.
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4">
                <div class="service-card h-100">
                    <div class="service-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h4 data-translate="secure_transactions">Transactions Sécurisées</h4>
                    <p data-translate="secure_transactions_desc">
                        Effectuez vos transactions en toute sécurité avec notre système de garanties.
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4">
                <div class="service-card h-100">
                    <div class="service-icon">
                        <i class="fas fa-headset"></i>
                    </div>
                    <h4 data-translate="customer_support">Support Client</h4>
                    <p data-translate="customer_support_desc">
                        Notre équipe est disponible 24h/7j pour vous accompagner dans toutes vos démarches.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Section Témoignages -->
<section class="testimonials-section py-5">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-8 text-center">
                <h2 class="display-5 fw-bold mb-4" data-translate="testimonials">Témoignages</h2>
                <p class="lead text-muted" data-translate="testimonials_subtitle">
                    Ce que nos clients disent de nous
                </p>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-4 mb-4">
                <div class="testimonial-card">
                    <div class="testimonial-content">
                        <p data-translate="testimonial_1">
                            "Excellent service ! J'ai trouvé la maison de mes rêves en moins d'une semaine. 
                            L'équipe de Taghilt est très professionnelle."
                        </p>
                    </div>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div>
                            <h6 class="mb-0">Ahmed Benali</h6>
                            <small class="text-muted">Alger</small>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 mb-4">
                <div class="testimonial-card">
                    <div class="testimonial-content">
                        <p data-translate="testimonial_2">
                            "Interface très intuitive et recherche efficace. J'ai pu vendre mon appartement 
                            rapidement grâce à leur plateforme."
                        </p>
                    </div>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div>
                            <h6 class="mb-0">Fatima Khadra</h6>
                            <small class="text-muted">Oran</small>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 mb-4">
                <div class="testimonial-card">
                    <div class="testimonial-content">
                        <p data-translate="testimonial_3">
                            "Service client exceptionnel ! Ils m'ont accompagné à chaque étape de mon achat. 
                            Je recommande vivement."
                        </p>
                    </div>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div>
                            <h6 class="mb-0">Mohamed Cherif</h6>
                            <small class="text-muted">Constantine</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Section Types de Propriétés -->
<section class="property-types-section py-5 bg-light">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-8 text-center">
                <h2 class="display-5 fw-bold mb-4" data-translate="property_types">Types de Propriétés</h2>
                <p class="lead text-muted" data-translate="property_types_subtitle">
                    Explorez nos différentes catégories de biens immobiliers
                </p>
            </div>
        </div>

        <div class="row g-4">
            <!-- Appartements -->
            <div class="col-md-6 col-lg-3">
                <div class="property-type-card h-100">
                    <div class="property-type-image">
                        <img src="https://images.unsplash.com/photo-1522708323590-d24dbb6b0267?w=800&auto=format&fit=crop" 
                             alt="Appartements" class="img-fluid">
                        <div class="property-type-overlay">
                            <i class="fas fa-building fa-3x text-white"></i>
                        </div>
                    </div>
                    <div class="property-type-content">
                        <h4 class="fw-bold mb-2">Appartements</h4>
                        <p class="text-muted mb-3">Trouvez l'appartement idéal en ville</p>
                        <a href="<?= $viewData['pathPrefix'] ?>index.php?page=search&type=appartement" class="btn btn-primary btn-sm w-100">
                            <i class="fas fa-search me-2"></i>Explorer
                        </a>
                    </div>
                </div>
            </div>

            <!-- Villas -->
            <div class="col-md-6 col-lg-3">
                <div class="property-type-card h-100">
                    <div class="property-type-image">
                        <img src="https://images.unsplash.com/photo-1600596542815-ffad4c1539a9?w=800&auto=format&fit=crop" 
                             alt="Villas" class="img-fluid">
                        <div class="property-type-overlay">
                            <i class="fas fa-home fa-3x text-white"></i>
                        </div>
                    </div>
                    <div class="property-type-content">
                        <h4 class="fw-bold mb-2">Villas</h4>
                        <p class="text-muted mb-3">Maisons spacieuses avec jardin</p>
                        <a href="<?= $viewData['pathPrefix'] ?>index.php?page=search&type=villa" class="btn btn-primary btn-sm w-100">
                            <i class="fas fa-search me-2"></i>Explorer
                        </a>
                    </div>
                </div>
            </div>

            <!-- Terrains -->
            <div class="col-md-6 col-lg-3">
                <div class="property-type-card h-100">
                    <div class="property-type-image">
                        <img src="https://images.unsplash.com/photo-1500382017468-9049fed747ef?w=800&auto=format&fit=crop" 
                             alt="Terrains" class="img-fluid">
                        <div class="property-type-overlay">
                            <i class="fas fa-map-marked-alt fa-3x text-white"></i>
                        </div>
                    </div>
                    <div class="property-type-content">
                        <h4 class="fw-bold mb-2">Terrains</h4>
                        <p class="text-muted mb-3">Parcelles constructibles disponibles</p>
                        <a href="<?= $viewData['pathPrefix'] ?>index.php?page=search&type=terrain" class="btn btn-primary btn-sm w-100">
                            <i class="fas fa-search me-2"></i>Explorer
                        </a>
                    </div>
                </div>
            </div>

            <!-- Locaux Commerciaux -->
            <div class="col-md-6 col-lg-3">
                <div class="property-type-card h-100">
                    <div class="property-type-image">
                        <img src="https://images.unsplash.com/photo-1497366216548-37526070297c?w=800&auto=format&fit=crop" 
                             alt="Locaux Commerciaux" class="img-fluid">
                        <div class="property-type-overlay">
                            <i class="fas fa-store fa-3x text-white"></i>
                        </div>
                    </div>
                    <div class="property-type-content">
                        <h4 class="fw-bold mb-2">Commerces</h4>
                        <p class="text-muted mb-3">Locaux pour votre activité</p>
                        <a href="<?= $viewData['pathPrefix'] ?>index.php?page=search&type=commerce" class="btn btn-primary btn-sm w-100">
                            <i class="fas fa-search me-2"></i>Explorer
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="text-center mt-5">
            <a href="<?= $viewData['pathPrefix'] ?>index.php?page=search" class="btn btn-outline-primary btn-lg">
                <i class="fas fa-th-large me-2"></i>
                Voir toutes les catégories
            </a>
        </div>
    </div>
</section>

<style>
.property-type-card {
    background: white;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
}

.property-type-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.15);
}

.property-type-image {
    position: relative;
    height: 250px;
    overflow: hidden;
}

.property-type-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.property-type-card:hover .property-type-image img {
    transform: scale(1.1);
}

.property-type-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(0,123,255,0.7), rgba(220,53,69,0.7));
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.property-type-card:hover .property-type-overlay {
    opacity: 1;
}

.property-type-content {
    padding: 1.5rem;
}

.property-type-content h4 {
    color: #2c3e50;
    font-size: 1.25rem;
}

.property-type-content p {
    font-size: 0.9rem;
}

.property-type-content .btn {
    transition: all 0.3s ease;
}

.property-type-content .btn:hover {
    transform: scale(1.05);
}
</style>

<!-- Section Call to Action -->
<section class="cta-section py-5 bg-primary text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h2 class="fw-bold mb-3" data-translate="cta_title">
                    Prêt à trouver votre propriété idéale ?
                </h2>
                <p class="lead mb-0" data-translate="cta_subtitle">
                    Rejoignez des milliers d'Algériens qui nous font confiance pour leurs projets immobiliers.
                </p>
            </div>
            <div class="col-lg-4 text-lg-end">
                <a href="<?= $viewData['pathPrefix'] ?>index.php?page=register" class="btn btn-light btn-lg">
                    <i class="fas fa-user-plus me-2"></i>
                    <span data-translate="cta_button">Créer mon compte</span>
                </a>
            </div>
        </div>
    </div>
</section>

<script>
// Initialiser les villes de la session dans le système de recherche
// Ce script s'exécute APRÈS le chargement de search-form-modern.js
window.addEventListener('load', function() {
    // Attendre que search-form-modern.js soit complètement chargé
    setTimeout(function() {
        <?php if (isset($lastSearch['city_ids']) && is_array($lastSearch['city_ids']) && isset($lastSearch['cities'])): ?>
        // Récupérer les données de la session
        const cityIds = <?= json_encode($lastSearch['city_ids']) ?>;
        const cityNames = '<?= $lastSearch['cities'] ?>'.split(',').map(c => c.trim());
        
        console.log('🔄 Chargement des villes de la session:', cityNames);
        
        // Simuler l'ajout de chaque ville au système de recherche
        // en déclenchant un événement personnalisé que search-form-modern.js pourra écouter
        cityIds.forEach((id, index) => {
            if (cityNames[index]) {
                const cityData = {
                    id: id,
                    label: cityNames[index],
                    value: cityNames[index],
                    type: 'commune'
                };
                
                // Créer un événement personnalisé pour ajouter la ville
                const event = new CustomEvent('addCityFromSession', {
                    detail: cityData
                });
                document.dispatchEvent(event);
            }
        });
        <?php endif; ?>
    }, 100); // Petit délai pour s'assurer que search-form-modern.js est prêt
});
</script>

<?php PublicHeaderFooter::renderFooter($viewData['pathPrefix']); ?>