<?php
namespace Views;

class PublicHeaderFooter
{
    public static function renderHeader($title = "Taghilt - Plateforme Immobilière Algérienne", $pathPrefix = '')
    {
        ?>
        <!DOCTYPE html>
        <html lang="fr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title><?= htmlspecialchars($title) ?></title>
            
            <!-- SEO Meta Tags -->
            <meta name="description" content="Taghilt - Plateforme immobilière algérienne pour acheter, vendre et louer des biens immobiliers en Algérie">
            <meta name="keywords" content="immobilier, Algérie, achat, vente, location, appartement, maison, villa, terrain">
            <meta name="author" content="Taghilt">
            <meta property="og:title" content="<?= htmlspecialchars($title) ?>">
            <meta property="og:description" content="Trouvez votre propriété idéale en Algérie avec Taghilt">
            <meta property="og:type" content="website">
            
            <!-- Favicon -->
            <link rel="icon" href="<?= $pathPrefix ?>assets/images/favicon.ico" type="image/x-icon">
            
            <!-- Bootstrap CSS - Local -->
            <link href="<?= $pathPrefix ?>assets/vendor/bootstrap-5.3.3/css/bootstrap.min.css" rel="stylesheet">
            
            <!-- Font Awesome - Local -->
            <link href="<?= $pathPrefix ?>assets/vendor/fontawesome-6.4.0-all.min.css" rel="stylesheet">
            
            <!-- CSS personnalisé -->
            <link href="<?= $pathPrefix ?>assets/css/public-style.css" rel="stylesheet">
            <link href="<?= $pathPrefix ?>assets/css/utils.css" rel="stylesheet">
            <link href="<?= $pathPrefix ?>assets/css/search-form-modern.css" rel="stylesheet">
            
            <style>
                /* Styles généraux pour corriger le scroll */
                html, body {
                    height: auto !important;
                    overflow-x: hidden;
                    overflow-y: auto;
                }
                
                /* Compensation pour le navbar fixed */
                body {
                    padding-top: 76px; /* Hauteur du navbar + marge */
                }
                
                /* Styles pour la navigation publique */
                .navbar-brand {
                    font-weight: bold;
                    font-size: 1.5rem;
                }
                
                .navbar-nav .nav-link {
                    font-weight: 500;
                    margin: 0 0.5rem;
                    transition: color 0.3s ease;
                }
                
                .navbar-nav .nav-link:hover {
                    color: #667eea !important;
                }
                
                .btn-login, .btn-register {
                    border-radius: 25px;
                    padding: 0.5rem 1.5rem;
                    font-weight: 600;
                    transition: all 0.3s ease;
                }
                
                .btn-login {
                    background: transparent;
                    border: 2px solid #667eea;
                    color: #667eea;
                }
                
                .btn-login:hover {
                    background: #667eea;
                    color: white;
                }
                
                .btn-register {
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    border: none;
                    color: white;
                }
                
                .btn-register:hover {
                    transform: translateY(-2px);
                    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
                }
            </style>
        </head>
        <body>
            <!-- Navigation -->
            <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm fixed-top">
                <div class="container">
                    <a class="navbar-brand text-primary" href="<?= $pathPrefix ?>index.php">
                        <i class="fas fa-home me-2"></i>
                        <span data-translate="brand_name">Taghilt</span>
                    </a>
                    
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    
                    <div class="collapse navbar-collapse" id="navbarNav">
                        <ul class="navbar-nav me-auto">
                            <li class="nav-item">
                                <a class="nav-link" href="<?= $pathPrefix ?>index.php#accueil" data-translate="nav_home">Accueil</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= $pathPrefix ?>index.php#recherche" data-translate="nav_search">Recherche</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= $pathPrefix ?>index.php#services" data-translate="nav_services">Services</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= $pathPrefix ?>index.php#contact" data-translate="nav_contact">Contact</a>
                            </li>
                        </ul>
                        
                        <div class="d-flex">
                            <a href="<?= $pathPrefix ?>index.php?page=login" class="btn btn-login me-2" data-translate="nav_login">
                                <i class="fas fa-sign-in-alt me-1"></i>
                                Connexion
                            </a>
                            <a href="<?= $pathPrefix ?>index.php?page=register" class="btn btn-register" data-translate="nav_register">
                                <i class="fas fa-user-plus me-1"></i>
                                S'inscrire
                            </a>
                        </div>
                    </div>
                </div>
            </nav>
        <?php
    }
    
    public static function renderFooter($pathPrefix = '')
    {
        ?>
            <!-- Footer -->
            <footer class="bg-dark text-light py-5 mt-5">
                <div class="container">
                    <div class="row">
                        <!-- À propos -->
                        <div class="col-lg-3 col-md-6 mb-4">
                            <h5 class="fw-bold mb-3">
                                <i class="fas fa-home me-2 text-primary"></i>
                                <span data-translate="brand_name">Taghilt</span>
                            </h5>
                            <p class="text-light-75" data-translate="footer_description">
                                Votre plateforme immobilière de confiance en Algérie. 
                                Trouvez, vendez et louez des propriétés en toute sécurité.
                            </p>
                            <div class="social-links">
                                <a href="#" class="text-light me-3" title="Facebook">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                                <a href="#" class="text-light me-3" title="Instagram">
                                    <i class="fab fa-instagram"></i>
                                </a>
                                <a href="#" class="text-light me-3" title="LinkedIn">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                                <a href="#" class="text-light" title="YouTube">
                                    <i class="fab fa-youtube"></i>
                                </a>
                            </div>
                        </div>

                        <!-- Liens utiles -->
                        <div class="col-lg-3 col-md-6 mb-4">
                            <h5 class="fw-bold mb-3" data-translate="useful_links">Liens Utiles</h5>
                            <ul class="list-unstyled">
                                <li class="mb-2"><a href="#" class="text-light-75" data-translate="about">À propos</a></li>
                                <li class="mb-2"><a href="#" class="text-light-75" data-translate="how_it_works">Comment ça marche</a></li>
                                <li class="mb-2"><a href="#" class="text-light-75" data-translate="pricing">Tarifs</a></li>
                                <li class="mb-2"><a href="#" class="text-light-75" data-translate="help">Aide</a></li>
                                <li class="mb-2"><a href="#" class="text-light-75" data-translate="blog">Blog</a></li>
                            </ul>
                        </div>

                        <!-- Types de biens -->
                        <div class="col-lg-3 col-md-6 mb-4">
                            <h5 class="fw-bold mb-3" data-translate="property_types">Types de Biens</h5>
                            <ul class="list-unstyled">
                                <li class="mb-2"><a href="#" class="text-light-75" data-translate="apartments">Appartements</a></li>
                                <li class="mb-2"><a href="#" class="text-light-75" data-translate="houses">Maisons</a></li>
                                <li class="mb-2"><a href="#" class="text-light-75" data-translate="villas">Villas</a></li>
                                <li class="mb-2"><a href="#" class="text-light-75" data-translate="land">Terrains</a></li>
                                <li class="mb-2"><a href="#" class="text-light-75" data-translate="commercial_properties">Biens commerciaux</a></li>
                            </ul>
                        </div>

                        <!-- Contact -->
                        <div class="col-lg-3 col-md-6">
                            <h5 class="fw-bold mb-3" data-translate="contact">Contact</h5>
                            <div class="contact-info">
                                <div class="mb-2">
                                    <i class="fas fa-map-marker-alt me-2"></i>
                                    <span data-translate="address">Alger, Algérie</span>
                                </div>
                                <div class="mb-2">
                                    <i class="fas fa-phone me-2"></i>
                                    <a href="tel:+213123456789" class="text-light-75">+213 123 456 789</a>
                                </div>
                                <div class="mb-2">
                                    <i class="fas fa-envelope me-2"></i>
                                    <a href="mailto:contact@taghilt.com" class="text-light-75">contact@taghilt.com</a>
                                </div>
                                <div class="mb-2">
                                    <i class="fas fa-clock me-2"></i>
                                    <span data-translate="hours">Lun - Ven: 8h - 18h</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr class="my-4">

                    <!-- Copyright -->
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <p class="mb-0" data-translate="copyright">
                                &copy; 2024 Taghilt. Tous droits réservés.
                            </p>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <ul class="list-inline mb-0">
                                <li class="list-inline-item">
                                    <a href="#" class="text-light-75" data-translate="privacy">Confidentialité</a>
                                </li>
                                <li class="list-inline-item">|</li>
                                <li class="list-inline-item">
                                    <a href="#" class="text-light-75" data-translate="terms">Conditions</a>
                                </li>
                                <li class="list-inline-item">|</li>
                                <li class="list-inline-item">
                                    <a href="#" class="text-light-75" data-translate="sitemap">Plan du site</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </footer>

            <!-- Bootstrap JS - Local -->
            <script src="<?= $pathPrefix ?>assets/vendor/bootstrap-5.3.3/js/bootstrap.bundle.min.js"></script>
            <!-- Script personnalisé -->
            <script src="<?= $pathPrefix ?>assets/js/public-script.js?v=<?= time() ?>"></script>
            <script src="<?= $pathPrefix ?>assets/js/search-form-modern.js?v=<?= time() ?>"></script>
        </body>
        </html>
        <?php
    }
}
?>
