<?PHP
namespace Views;

class ParametresHtml
{
    static public function AfficherParametres($resultParam, $msgParam, $msgParam2)
    {
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");

        function checkbox($id, $checked, $label, $description, $disabled = '', $classCheckBox = '', $dataId = '', $info = '', $complHtml = '')
        {
            echo '
            <div class="mb-2 p-2 bg-info-subtle border rounded">
                <label class="form-label d-block">' . $description . '</label>';

            if (!empty($info)) {
                echo '<p class="d-block">' . $info . '</p>';
            }
            echo '
                <div class="form-check form-switch">
                    <input class="form-check-input ' . $classCheckBox . '" 
                           type="checkbox" 
                           id="' . $id . '" 
                           name="' . $id . '" 
                           title="' . $label . '" 
                           data-id="' . $dataId . '" 
                           ' . $checked . ' ' . $disabled . '>
                    <label class="form-check-label ms-2" for="' . $id . '">' . $label . '</label>
                </div>';

            if ($complHtml != '')
                echo $complHtml;

            echo ' </div>';
        }

?>

        <main class="<?php echo $mainClass; ?> ms-sm-auto px-md-4 py-4" id="main-content" style="display: none;">
            <form id="formParam" name="formParam" method="post" action="index.php?page=param" enctype="multipart/form-data">
                <div class="card card-mh-90vh">
                    <div class="card-header">
                        <b>Paramètres de l'application</b>
                    </div>
                    <div class="card-body">
                        <?php
                        if (((isset($_GET["msg"]) && $_GET["msg"]) != "") || (isset($msgParam) && $msgParam != "")) {
                            $msg = !empty($msgParam) ? $msgParam : $_GET["msg"];

                            // Define messages and their alert types with Font Awesome icons
                            $alerts = [
                                "updated" => ["success", "fas fa-check-circle", "Utilisateur mis à jour avec succès."],
                                "deleted" => ["success", "fas fa-check-circle", "Utilisateur supprimé avec succès."],
                                "added" => ["success", "fas fa-check-circle", "Utilisateur ajouté avec succès."],
                                "errorsupr" => ["warning", "fas fa-exclamation-triangle", "Erreur suppression, réessayez plus tard ou contactez " . $errorMsgService . "."],
                                "erroraddedit" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnu, réessayez plus tard ou contactez " . $errorMsgService . "."],
                                "errorajax" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnu, réessayez plus tard ou contactez " . $errorMsgService . "."],
                            ];

                            // Display alert if message exists in array
                            if (array_key_exists($msg, $alerts)) {
                                list($alertType, $icon, $message) = $alerts[$msg];
                                echo '
                            <div class="alert alert-' . $alertType . '" id="alertMessageSuggestion" role="alert">
                                <i class="' . $icon . ' me-2"></i> ' . $message . '
                            </div>';
                            }
                        }

                        ?>
                        <div class="row g-4">
                            <div class="col-sm-6 col-md-6 col-lg-3">
                                <div class="card h-100">
                                    <div class="card-header bg-primary text-white">Informations </div>
                                    <div class="card-body">
                                        <label for="logo_site" class="form-label">Logo de l'entreprise (PNG/JPG uniquement)</label>
                                        <div id="logoPreview" class="mt-2 d-flex justify-content-center align-items-center border rounded p-2" style="max-height: 120px;">
                                            <?php if (!empty($resultParam['logo_file'])) : ?>
                                                <img src="assets/images/<?= htmlspecialchars($resultParam['logo_file']) ?>" alt="Logo actuel" style="max-height: 100px;" />
                                            <?php endif; ?>
                                        </div>
                                        <input type="file" class="form-control mt-3" id="logo_site" name="logo_site" accept=".png, .jpg, .jpeg" />

                                        <label class="form-label mt-3" for="nom_etablissement">Nom de votre établissement<span style="color: red; font-weight: bold;">*</span></label>
                                        <input type="text" class="form-control mb-3" name="nom_etablissement" value="<?= $resultParam['nom_etablissement'] ?>" required>

                                        <label class="form-label mt-3" for="adresse_etablissement">Votre adresse <span style="color: red; font-weight: bold;">*</span></label>
                                        <input type="text" class="form-control mb-3" name="adresse_etablissement" value="<?= $resultParam['adresse_etablissement'] ?>" required>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6 col-md-6 col-lg-3">
                                <div class="card">
                                    <div class="card-header bg-secondary text-white">Configuration des Bornes</div>
                                    <div class="card-body">
                                        <label class="form-label" for="noms_bornes">Noms des bornes</label>
                                        <textarea class="form-control mb-3" name="noms_bornes" rows="3"><?= htmlspecialchars($resultParam['noms_bornes']) ?></textarea>
                                        <p class="mt-3">
                                            Ex. : <strong>NOMORDI01</strong> ou <strong>NOMORDI02, 170.0.0.99</strong><br>
                                            <em>Note :</em> il est fortement conseillé d’indiquer à la fois le nom de l’ordinateur et son adresse IP, séparés par des virgules.
                                        </p>
                                        <?php

                                        $compHtml = '
                                        <div id="comNameAngfields">
                                            <div class="mb-2 p-2 bg-info-subtle border rounded">
                                                <label class="form-label mt-3" for="nom_etablissement_anglais">Nom de votre établissement en Anglais <span style="color: red; font-weight: bold;">*</span></label>
                                                <input type="text" class="form-control mb-3" id="nom_etablissement_anglais" name="nom_etablissement_anglais" value="' . $resultParam['nom_etablissement_anglais'] . '" required>
                                            </div>
                                        </div>';

                                        checkbox(
                                            'utiliser_mulitlangue',
                                            ($resultParam['utiliser_mulitlangue'] ? 'checked' : ''),
                                            'Utiliser la multilangue (Français et Anglais)',
                                            'Permettre l\'utilisation de l\'anglais dans le formulaire d\'inscription des représentants.',
                                            '',
                                            '',
                                            '',
                                            'Si vous décochez cette case, le formulaire d\'inscription pour les représentants sera uniquement en langue française.',
                                            $compHtml
                                        );

                                        checkbox(
                                            'utiliser_etape',
                                            ($resultParam['utiliser_etape'] ? 'checked' : ''),
                                            'Utiliser les étapes',
                                            'Activer les étapes dans le formulaire d\'inscription d\'un représentant.',
                                            '',
                                            '',
                                            '',
                                            info: 'Si vous décochez cette case, le formulaire d\'inscription sera en une seule page (non recommandé).'
                                        );

                                        checkbox(
                                            'utiliser_seul_date_debut',
                                            ($resultParam['utiliser_seul_date_debut'] ? 'checked' : ''),
                                            'Date début uniquement',
                                            'Utiliser seulement la date de début sans date de fin.',
                                            '',
                                            '',
                                            '',
                                            info: 'Si vous décochez cette case, les représentants peuvent s\'inscrire d\'une date début à une date de fin.'
                                        );
                                        ?>

                                    </div>
                                </div>

                                <div class="card mt-3">
                                    <div class="card-header bg-success text-white">Informations sur le support Technique</div>
                                    <div class="card-body">
                                        <label class="form-label" for="nom_service">Nom du service (Support) <span style="color: red; font-weight: bold;">*</span></label>
                                        <input type="text" class="form-control mb-3" name="nom_service" value="<?= $resultParam['nom_service'] ?>" required>

                                        <label class="form-label" for="email_support">Adresse email du support</label>
                                        <input type="text" class="form-control mb-3" name="email_support" value="<?= $resultParam['email_support'] ?>">

                                        <label class="form-label" for="tel_support">Numéro de téléphone du support</label>
                                        <input type="text" class="form-control" name="tel_support" value="<?= $resultParam['tel_support'] ?>">
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6 col-md-6 col-lg-3">
                                <div class="card">
                                    <div class="card-header bg-danger text-white">Option impression Badge</div>
                                    <div class="card-body">
                                        <label class="form-label" for="chemin_imprimante">Chemin sur le serveur <span style="color: red; font-weight: bold;">*</span></label>
                                        <input type="text" class="form-control mb-3" name="chemin_imprimante" value="<?= $resultParam['chemin_imprimante'] ?>" required>
                                        <p>Ex. \\MON-SERVEUR-IMP\ETI_SECURITE_01</p>
                                    </div>
                                </div>

                                <div class="card mt-3">
                                    <div class="card-header bg-info text-white">Options de configuration</div>
                                    <div class="card-body">
                                        <div class="mb-2 p-2 bg-info-subtle border rounded">
                                            <label class="form-label" for="inactivity_time">Délai avant verrouillage automatique <span style="color: red; font-weight: bold;">*</span></label>
                                            <select id="inactivity_time" name="inactivity_time" class="form-select mb-3" required>
                                                <option value="5" <?= $resultParam['inactivity_time'] == 5 ? 'selected' : '' ?>>5 minutes</option>
                                                <option value="10" <?= $resultParam['inactivity_time'] == 10 ? 'selected' : '' ?>>10 minutes</option>
                                                <option value="15" <?= $resultParam['inactivity_time'] == 15 ? 'selected' : '' ?>>15 minutes</option>
                                                <option value="30" <?= $resultParam['inactivity_time'] == 30 ? 'selected' : '' ?>>30 minutes</option>
                                                <option value="60" <?= $resultParam['inactivity_time'] == 60 ? 'selected' : '' ?>>1 hour</option>
                                                <option value="120" <?= $resultParam['inactivity_time'] == 120 ? 'selected' : '' ?>>2 hours</option>
                                                <option value="180" <?= $resultParam['inactivity_time'] == 180 ? 'selected' : '' ?>>3 hours</option>
                                                <option value="240" <?= $resultParam['inactivity_time'] == 240 ? 'selected' : '' ?>>4 hours</option>
                                            </select>
                                            <p>Définit le temps d'inactivité avant le verrouillage automatique de l'application.</p>
                                        </div>
                                        <?php

                                        checkbox(
                                            'afficher_sidebar',
                                            ($resultParam['afficher_sidebar'] ? 'checked' : ''),
                                            'Afficher la sidebar',
                                            'Afficher ou masquer le menu latéral.'
                                        );

                                        checkbox(
                                            'utiliser_mode_dark',
                                            ($resultParam['utiliser_mode_dark'] ? 'checked' : ''),
                                            'Mode sombre',
                                            'Autoriser l\'utilisation du thème sombre dans l\'application.'
                                        );

                                        $compHtml = '
                                        <div id="computer-name-fields">
                                            <div class="mb-2 p-2 bg-info-subtle border rounded">
                                                <label class="form-label">Noms et adresse Ip des ordinateurs à autoriser </label>
                                                <textarea class="form-control mb-3" name="allowedonmaintenance" rows="3">' . $resultParam['allowedonmaintenance'] . '</textarea>
                                                <p class="mt-3">
                                                    Ex. : <strong>NOMORDI05</strong> ou <strong>NOMORDI05, 170.0.0.99, NOMORDI11, 170.0.0.100</strong><br>
                                                    <em>Note :</em> il est fortement conseillé d’indiquer à la fois le nom de l’ordinateur et son adresse IP, séparés par des virgules.
                                                </p>
                                            </div>
                                        </div>';
                                        checkbox(
                                            'en_maintenance',
                                            ($resultParam['en_maintenance'] ? 'checked' : ''),
                                            'Maintenance',
                                            'Basculer l\'application en mode maintenance.',
                                            '',
                                            '',
                                            '',
                                            '',
                                            $compHtml
                                        );

                                        checkbox(
                                            'regrouper_menu',
                                            ($resultParam['regrouper_menu'] ? 'checked' : ''),
                                            'Regrouper le menu',
                                            'Afficher les éléments du menu de manière regroupée.'
                                        );

                                        checkbox(
                                            'affi_fraphe_stat_mon',
                                            ($resultParam['affi_fraphe_stat_mon'] ? 'checked' : ''),
                                            'Afficher les statistiques mensuelles',
                                            'Afficher les statistiques mensuelles sur le tableau de bord.'
                                        );

                                        checkbox(
                                            'affi_fraphe_stat_annu',
                                            ($resultParam['affi_fraphe_stat_annu'] ? 'checked' : ''),
                                            'Afficher les statistiques anneulles',
                                            'Afficher les statistiques annuelles sur le tableau de bord.'
                                        );

                                        ?>
                                    </div>
                                </div>

                            </div>
                            <script>
                                document.addEventListener("DOMContentLoaded", function() {
                                    const checkbox = document.getElementById('ldap_enabled');
                                    const ldapFields = document.getElementById('ldap-fields');

                                    const en_maintenance = document.getElementById('en_maintenance');
                                    const computernamefields = document.getElementById('computer-name-fields');

                                    const utiliserMultilangue = document.getElementById('utiliser_mulitlangue');
                                    const nomEtabAnglaisInput = document.getElementById('nom_etablissement_anglais');
                                    const comNameAngfields = document.getElementById('comNameAngfields');

                                    function toggleLdapFields() {
                                        ldapFields.style.display = checkbox.checked ? 'block' : 'none';
                                    }

                                    function toggleMaintenanceFields() {
                                        computernamefields.style.display = en_maintenance.checked ? 'block' : 'none';
                                    }

                                    function toggleNomEtabFields() {
                                        //comNameAngfields.style.display = utiliser_mulitlangue.checked ? 'block' : 'none';

                                        const show = utiliserMultilangue?.checked;
                                        comNameAngfields.style.display = show ? 'block' : 'none';
                                        nomEtabAnglaisInput.required = show;
                                    }

                                    // Initial state
                                    toggleLdapFields();
                                    toggleMaintenanceFields();
                                    toggleNomEtabFields();

                                    // Listen for changes
                                    checkbox.addEventListener('change', toggleLdapFields);
                                    en_maintenance.addEventListener('change', toggleMaintenanceFields);
                                    utiliserMultilangue.addEventListener('change', toggleNomEtabFields);
                                });
                            </script>
                            <div class="col-sm-6 col-md-6 col-lg-3">
                                <div class="card">
                                    <div class="card-header bg-dark text-white">Authentification des utilisateurs</div>
                                    <div class="card-body">
                                        <div class="mb-2 p-4 bg-info-subtle border rounded">
                                            <p class="d-block">
                                                Activez cette option si vous souhaitez que vos utilisateurs se connectent avec leurs comptes Windows dans l'Active Directory (LDAP).<br>
                                                Si vous la décochez, l'authentification se fera avec les comptes créés dans l'application.
                                            </p>
                                            <div class="form-check form-switch">
                                                <input
                                                    class="form-check-input"
                                                    type="checkbox"
                                                    id="ldap_enabled"
                                                    name="ldap_enabled"
                                                    data-id="ldap_enabled"
                                                    <?= $resultParam['ldap_enabled'] == 1 ? 'checked' : '' ?>>
                                                <label class="form-check-label ms-2" for="ldap_enabled">Activer l'authentification LDAP</label>
                                            </div>
                                        </div>

                                        <!-- LDAP FIELDS -->
                                        <div id="ldap-fields">
                                            <div class="mb-3 p-4 bg-info-subtle border rounded">
                                                <p class="d-block">
                                                    Lorsque cette option est activée, l'application importera automatiquement dans la base de données locale les utilisateurs authentifiés via LDAP.
                                                </p>
                                                <div class="form-check form-switch">
                                                    <input
                                                        class="form-check-input"
                                                        type="checkbox"
                                                        id="import_user_from_ldap"
                                                        name="import_user_from_ldap"
                                                        data-id="import_user_from_ldap"
                                                        <?= $resultParam['import_user_from_ldap'] == 1 ? 'checked' : '' ?>>
                                                    <label class="form-check-label ms-2" for="import_user_from_ldap">
                                                        Importer et enregistrer automatiquement les utilisateurs LDAP dans la base locale
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">
                                                    LDAP Host <span style="color: red; font-weight: bold;">*</span>
                                                </label>
                                                <input
                                                    type="text"
                                                    name="ldap_host"
                                                    class="form-control"
                                                    value="<?= $resultParam['ldap_host'] ?? '' ?>"
                                                    required>
                                                <small class="form-text text-muted">Adresse du serveur LDAP (ex. : ldap.example.com)</small>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">
                                                    LDAP Port <span style="color: red; font-weight: bold;">*</span>
                                                </label>
                                                <input
                                                    type="number"
                                                    name="ldap_port"
                                                    class="form-control"
                                                    value="<?= $resultParam['ldap_port'] ?? '389' ?>"
                                                    required>
                                                <small class="form-text text-muted">Port utilisé pour la connexion LDAP. Par défaut : 389 (LDAP) ou 636 (LDAPS).</small>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">
                                                    Bind DN <span style="color: red; font-weight: bold;">*</span>
                                                </label>
                                                <input
                                                    type="text"
                                                    name="bind_dn"
                                                    class="form-control"
                                                    value="<?= $resultParam['bind_dn'] ?? '' ?>"
                                                    required>
                                                <small class="form-text text-muted">DN (Distinguished Name) de l'utilisateur autorisé à interroger l'annuaire LDAP (ex. : cn=admin,dc=example,dc=com).</small>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">
                                                    Bind Password <span style="color: red; font-weight: bold;">*</span>
                                                </label>`
                                                </button>
                                                <div class="input-group">
                                                    <input
                                                        type="password"
                                                        id="bind_pass"
                                                        name="bind_pass"
                                                        class="form-control"
                                                        required>

                                                    <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                                        <i class="bi bi-eye"></i></button>
                                                </div>
                                                <small class="form-text text-muted">Mot de passe du compte LDAP utilisé pour la liaison (Bind DN).</small>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">
                                                    Base DN <span style="color: red; font-weight: bold;">*</span>
                                                </label>
                                                <input
                                                    type="text"
                                                    name="base_dn"
                                                    class="form-control"
                                                    value="<?= $resultParam['base_dn'] ?? '' ?>"
                                                    required>
                                                <small class="form-text text-muted">Point de départ pour la recherche des utilisateurs dans l'annuaire LDAP (ex. : dc=example,dc=com).</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php

                        if ($showParameters === 'true') {
                        ?>
                            <div class="modal fade" id="configurationModal" tabindex="-1" aria-labelledby="configurationModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content shadow">
                                        <div class="modal-header bg-primary text-white">
                                            <h5 class="modal-title" id="configurationModalLabel">Configuration requise</h5>
                                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Fermer"></button>
                                        </div>
                                        <div class="modal-body text-center">
                                            <p class="mb-3">
                                                Bienvenue sur la page de configuration de l'application.
                                            </p>
                                            <p class="text-muted small">
                                                Veuillez remplir les paramètres nécessaires afin de pouvoir utiliser l'application correctement.
                                            </p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Commencer</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        <?php
                        }
                        ?>

                        <script>
                            // Hide alert after 10 seconds
                            setTimeout(function() {
                                var alert = document.getElementById('alertMessageSuggestion');
                                if (alert) {
                                    alert.style.display = 'none';
                                }
                            }, 10000);

                            // Toggle password visibility
                            document.addEventListener('DOMContentLoaded', function() {
                                var togglePassword = document.getElementById('togglePassword');
                                var passwordInput = document.getElementById('bind_pass');

                                if (togglePassword && passwordInput) {
                                    togglePassword.addEventListener('click', function() {
                                        var icon = togglePassword.querySelector('i');

                                        if (passwordInput.type === 'password') {
                                            passwordInput.type = 'text';
                                            if (icon) {
                                                icon.classList.remove('bi-eye');
                                                icon.classList.add('bi-eye-slash');
                                            }
                                        } else {
                                            passwordInput.type = 'password';
                                            if (icon) {
                                                icon.classList.remove('bi-eye-slash');
                                                icon.classList.add('bi-eye');
                                            }
                                        }
                                    });
                                }

                                <?php if ($showParameters === 'true') { ?>
                                    var myModal = new bootstrap.Modal(document.getElementById('configurationModal'));
                                    myModal.show();
                                <?php } ?>
                            });
                        </script>

                    </div>
                    <div class="card-footer mt-auto bg-light text-end">
                        <small class="text-muted mb-0">
                            <span class="text-danger">*</span> Champs obligatoires
                        </small>
                        <button type="submit" class="btn btn-dark">
                            <i class="fas fa-save me-1"></i> Enregistrer les paramètres
                        </button>
                    </div>
                </div>
            </form>
        </main>
<?php
    }
}
?>
