<?PHP
namespace Views;

class NavBarHtml
{
    public function __construct() {}

    /**
     * Obtient les libellés personnalisés selon le rôle de l'utilisateur
     */
    private function getCustomLabels($userRoles)
    {
        // Labels par défaut pour visiteurs
        $labels = [
            'dashboard' => 'Mon espace',
            'annonces' => 'Mes annonces',
            'contacts' => 'Mes contacts reçus',
            'gestion' => 'Gestion',
            'stats' => 'Mes performances'
        ];

        // Vérifier les rôles pour personnaliser
        if (isset($userRoles) && !empty($userRoles)) {
            foreach ($userRoles as $role) {
                $roleName = $role['role_name'] ?? '';
                $niveauAcces = $role['niveau_acces'] ?? 0;

                // Administrateurs
                if (in_array($roleName, ['Administrateur', 'Super Administrateur']) || $niveauAcces >= 90) {
                    $labels = [
                        'dashboard' => 'Centre de contrôle',
                        'annonces' => 'Toutes les annonces',
                        'contacts' => 'Tous les contacts',
                        'gestion' => 'Administration',
                        'stats' => 'Statistiques globales'
                    ];
                    break;
                }
                // Agents Premium
                elseif (in_array($roleName, ['Agent Premium', 'Modérateur']) || $niveauAcces >= 70) {
                    $labels = [
                        'dashboard' => 'Espace Pro Premium',
                        'annonces' => 'Mon portefeuille Pro',
                        'contacts' => 'Leads clients',
                        'gestion' => 'Gestion avancée',
                        'stats' => 'Analytics Pro'
                    ];
                    break;
                }
                // Agents Standard
                elseif (in_array($roleName, ['Agent Standard', 'Gestionnaire']) || $niveauAcces >= 40) {
                    $labels = [
                        'dashboard' => 'Espace Pro',
                        'annonces' => 'Mes mandats',
                        'contacts' => 'Contacts clients',
                        'gestion' => 'Gestion biens',
                        'stats' => 'Mes statistiques'
                    ];
                    break;
                }
                // Agent Particulier
                elseif (in_array($roleName, ['Agent Particulier']) || $niveauAcces >= 20) {
                    $labels = [
                        'dashboard' => 'Mon espace',
                        'annonces' => 'Mes biens',
                        'contacts' => 'Mes contacts',
                        'gestion' => 'Gestion biens',
                        'stats' => 'Mes performances'
                    ];
                    break;
                }
            }
        }

        return $labels;
    }

    public function showMenu($departement, $user, $pathPrefix = '')
    {
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");

        // Obtenir les libellés personnalisés selon le rôle
        $userRoles = isset($_SESSION[$NomSite]['userRoles']) ? $_SESSION[$NomSite]['userRoles'] : [];
        $customLabels = $this->getCustomLabels($userRoles);


        $activef = '';
        $activev = '';
        $activevv = '';
        $activeab = '';
        $activegest = '';

        if ($UseModeDark) {
            $modeDark = '';
        } else {
            $modeDark = 'd-none';
        }

        $activedb = (isset($_GET['typePage']) && $_GET['typePage'] == 'db') || (!isset($_GET['page']) && !isset($_GET['typePage'])) ? 'active' : '';
        $activef = (isset($_GET['page']) && $_GET['page'] == 'vsts' && isset($_GET['typePage']) && $_GET['typePage'] == 'f') ? 'active' : '';
        $activev = (isset($_GET['page']) && $_GET['page'] == 'vsts' && isset($_GET['typePage']) && $_GET['typePage'] == 'v') ? 'active' : '';
        $activevv = (isset($_GET['page']) && $_GET['page'] == 'vsts' && isset($_GET['typePage']) && $_GET['typePage'] == 'vv') ? 'active' : '';
        $activeab = (isset($_GET['typePage']) && $_GET['typePage'] == 'ab') ? 'active' : '';

        if ($activef || $activev || $activevv) {
            $activegest = 'active';
        } else {
            $activegest = '';
        }

        $activeuser = (isset($_GET['page']) && $_GET['page'] == 'user') ? 'active' : '';
        $activedep = (isset($_GET['page']) && $_GET['page'] == 'dep') ? 'active' : '';
        $activepage = (isset($_GET['page']) && $_GET['page'] == 'page') && !isset($_GET['typePage']) ? 'active' : '';
        $activepagevue = (isset($_GET['page']) && $_GET['page'] == 'page' && isset($_GET['typePage']) && $_GET['typePage'] == 'pv') ? 'active' : '';
        $activerole = (isset($_GET['page']) && $_GET['page'] == 'role') ? 'active' : '';
        $activewdw = (isset($_GET['page']) && $_GET['page'] == 'wdw') ? 'active' : '';
        $activemsg = (isset($_GET['page']) && $_GET['page'] == 'msg') ? 'active' : '';
        $activeparam = (isset($_GET['page']) && $_GET['page'] == 'param') ? 'active' : '';

        if ($activeuser || $activepage || $activepagevue || $activerole || $activewdw || $activedep)
            $activeoutils = 'active';
        else
            $activeoutils = '';

        if ($useInMenuGestion) {
            $str1 = '
        <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle ' . $activegest . ' text-start" href="#" id="gestionDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="fas fa-briefcase"></i> <span class="d-lg-inline">' . $customLabels['gestion'] . '</span>
            </a>
            <ul class="dropdown-menu text-start" aria-labelledby="gestionDropdown">';
            $str2 = '';
            $str3 = 'dropdown-item text-start';
            $str4 = '</ul>
        </li>';
        } else {
            $str1 = '';
            $str2 = 'class="nav-item"';
            $str3 = 'nav-link ';
            $str4 = '';
        }

        if ($StyleMenu == 1) {

?>
            <nav class="navbar navbar-expand-md fixed-top navbar-dark bg-dark">
                <div class="container-fluid">
                    <a class="navbar-brand" href="index.php">
                        <img src="<?= $pathPrefix ?>assets/images/TrackRep2.png" alt="Logo" height="30" class="d-inline-block align-top invert" alt="">
                        <img src="<?= $pathPrefix ?>assets/images/logodrht_30.png" width="30" height="30" class="d-inline-block align-top d-none" alt="">
                        <img src="<?= $pathPrefix ?>assets/images/Icone-Gestion-Visiteur32-32.png" width="30" height="30" class="d-inline-block align-top rounded-circle d-none" alt="">
                        <span class="site-name d-none"><?= $NomSiteCap; ?></span>
                    </a>

                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
                        aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse " id="navbarSupportedContent">
                        <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                            <?php if (!$DisplaySideBAr) { ?>

                                <li class="nav-item hide-text">
                                    <a class="nav-link <?php echo $activedb; ?> text-start" href="index.php?page=vsts&typePage=db">
                                        <i class="bi bi-speedometer2"></i> <span class="d-lg-inline"><?php echo $customLabels['dashboard']; ?></span>
                                    </a>
                                </li>

                                <?php echo $str1; ?>

                                <li <?php echo $str2; ?>>
                                    <a class="<?php echo $str3; ?> <?php echo $activef; ?>" href="index.php?page=vsts&typePage=f">
                                        <i class="bi bi-box-seam"></i> Fournisseurs
                                    </a>
                                </li>
                                <li <?php echo $str2; ?>>
                                    <a class="<?php echo $str3; ?> <?php echo $activev; ?>" href="index.php?page=vsts&typePage=v">
                                        <i class="bi bi-people"></i> Représentants
                                    </a>
                                </li>
                                <li <?php echo $str2; ?>>
                                    <a class="<?php echo $str3; ?> <?php echo $activevv; ?>" href="index.php?page=vsts&typePage=vv">
                                        <i class="bi bi-house-door"></i> <?php echo $customLabels['annonces']; ?>
                                    </a>
                                </li>
                                <?php echo $str4; ?>

                                <!-- 
                                <li class="nav-item hide-text">
                                    <a class="nav-link <?php echo $activeab; ?>" href="index.php?page=vsts&typePage=ab">
                                        <i class="bi bi-info-circle"></i> <span class="d-lg-inline">À propos</span>
                                    </a>
                                </li>
                                -->
                            <?php } ?>
                        </ul>


                        <ul class="navbar-nav">

                            <?php
                            // Vérifier le niveau d'accès de l'utilisateur
                            $showAdminTools = false;
                            if (isset($_SESSION[$NomSite]['userRoles'])) {
                                $roles = $_SESSION[$NomSite]['userRoles'];
                                foreach ($roles as $role) {
                                    // Si l'utilisateur a un rôle avec niveau d'accès >= 40 (Agent Standard ou plus)
                                    if (isset($role['niveau_acces']) && $role['niveau_acces'] >= 40) {
                                        $showAdminTools = true;
                                        break;
                                    }
                                    // Compatibilité avec l'ancien système de noms de rôles
                                    if (in_array($role['role_name'], ['Administrateur', 'Pilote', 'Gestionnaire', 'Super Administrateur', 'Modérateur', 'Agent Premium', 'Agent Standard'])) {
                                        $showAdminTools = true;
                                        break;
                                    }
                                }
                            }
                            
                            //valide si l'utilisateur a accès aux outils d'administration
                            if ($showAdminTools) { ?>
                                <li class="nav-item dropdown hide-text">
                                    <a class="nav-link dropdown-toggle <?php echo $activeoutils; ?>" href="#" id="navbarDropdown" role="button"
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fas fa-cogs"></i></i> <span class="d-lg-inline"> Outils d'administration</span>
                                    </a>
                                    <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                        <li><a class="dropdown-item <?php echo $activeuser; ?> text-start" href="index.php?page=user">Utilisateurs</a>
                                        <li><a class="dropdown-item <?php echo $activerole; ?> text-start" href="index.php?page=role">Rôles</a>
                                        <li><a class="dropdown-item <?php echo $activewdw; ?> text-start" href="index.php?page=wdw">Who did what?</a>

                                    </ul>
                                </li>
                            <?php
                            }
                            ?>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="navbarDropdown" role="button"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fas fa-user-circle me-2"></i> <!-- Profile Icon -->
                                    <?= strtoupper($user->firstname[0] . "." . $user->lastname); ?> <span class="caret"></span>
                                    <input type="hidden" id="UserConnectedId" value="<?= $user->idUser; ?>">
                                    <input type="hidden" id="UserConnectedName" value="<?= $user->firstname . " " . $user->lastname; ?>">
                                </a>

                                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                    <li><a class="dropdown-item d-none" id="#" href="#">Voir profil</a></li>

                                    <?php

                                    if ($roleAdministrateur || $rolePilote || $roleDeveloppeur) {
                                        //
                                    }

                                    if ($roleDeveloppeur) {
                                        echo '<li><a class="dropdown-item ' . $activeparam . '" href="index.php?page=param">Paramètres de l\'application</a></li>';
                                        echo '<li><a class="dropdown-item ' . $activemsg . '" href="index.php?page=msg">Messages</a></li>';
                                    } else {
                                        echo '<li><a class="dropdown-item" id="openSuggestionModal" href="#">Faire une suggestion aux développeurs</a></li>';
                                    }
                                    ?>
                                    <li><a class="dropdown-item" href="index.php?page=d">Déconnexion</a></li>
                                </ul>


                            </li>

                            <li class="nav-item dropdown d-none">
                                <a class="nav-link disabled" href="#"><span class="site-name-responsive"><?php echo 'Reoleweb - Immobilier'; ?></span></a>
                            </li>
                            <li class="nav-item dropdown <?php echo $modeDark; ?>">
                                <a id="darkModeToggle" class="nav-link px-3 btn btn-dark " href="#ss">🌙 Dark Mode</a>
                            </li>

                        </ul>
                    </div>

                </div>
            </nav>
        <?php
        } else if ($StyleMenu == 2) {
        ?>

            <header class="navbar navbar-dark sticky-top bg-dark flex-md-nowrap p-0 shadow">
                <a class="navbar-brand col-md-3 col-lg-2 me-0 px-3" href="#">Company name</a>
                <button class="navbar-toggler position-absolute d-md-none collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#sidebarMenu" aria-controls="sidebarMenu" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="navbar-nav ms-auto d-flex align-items-center">
                    <div class="nav-item text-nowrap <?php echo $modeDark; ?>">
                        <a id="darkModeToggle" class="nav-link px-3 btn btn-dark " href="index.php?page=d">🌙 Dark Mode</a>
                    </div>
                    <div class="nav-item text-nowrap">
                        <a class="nav-link px-3 active" href="index.php?page=d">Déconnexion</a>
                    </div>
                </div>
            </header>
        <?php
        } else if ($StyleMenu == 3) {
        ?>


            <header class="p-3 mb-3 border-bottom">
                <div class="container">
                    <div class="d-flex flex-wrap align-items-center justify-content-center justify-content-lg-start">
                        <a href="/" class="d-flex align-items-center mb-2 mb-lg-0 text-dark text-decoration-none">
                            <svg class="bi me-2" width="40" height="32" role="img" aria-label="Bootstrap">
                                <use xlink:href="#bootstrap"></use>
                            </svg>
                            <img src="assets/images/logodrht_30.png" alt="mdo" height="40" class="rounded-circle">
                        </a>

                        <ul class="nav col-12 col-lg-auto me-lg-auto mb-2 justify-content-center mb-md-0">
                            <li><a href="#" class="nav-link px-2 link-secondary">Overview</a></li>
                            <li><a href="#" class="nav-link px-2 link-dark">Inventory</a></li>
                            <li><a href="#" class="nav-link px-2 link-dark">Customers</a></li>
                            <li><a href="#" class="nav-link px-2 link-dark">Products</a></li>
                        </ul>


                        <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <li><a class="dropdown-item" href="index.php?page=user">Utilisateurs</a>
                            <li><a class="dropdown-item" href="index.php?page=role">Rôles</a>
                            <li><a class="dropdown-item" href="index.php?page=wdw">Who did what?</a>

                            <li Class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" id="navbarDropdownAssignationLink" href="#" data-toggle="dropdown" style="color: black;">&nbsp&nbsp&nbsp&nbspLiens utiles</a>
                                <ul class="submenu dropdown-menu" aria-labelledby="navbarDropdownAssignationLink">
                                    <li><a class="dropdown-item" href="http://<?= $serveur; ?>/phpmyadmin/"
                                            target='_blank'>phpMyAdmin (<?= $serveur; ?>)</a></li>
                                </ul>
                            </li>

                        </ul>



                        <div class="dropdown text-end">
                            <a href="#" class="d-block link-dark text-decoration-none dropdown-toggle" data-bs-toggle="dropdown"
                                aria-expanded="false">
                                <img src="assets/images/logodrht_30.png" alt="mdo" width="32" height="32" class="rounded-circle">
                            </a>
                            <ul class="dropdown-menu text-small" style="">
                                <li><a class="dropdown-item" href="#">New project...</a></li>
                                <li><a class="dropdown-item" href="#">Settings</a></li>
                                <li><a class="dropdown-item" href="#">Profile</a></li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="#"></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </header>
        <?php
        } else if ($StyleMenu == 4) {
        ?>

            <header class="py-3 mb-3 border-bottom">
                <div class="container-fluid d-grid gap-3 align-items-center" style="grid-template-columns: 1fr 2fr;">
                    <div class="dropdown">
                        <a href="#"
                            class="d-flex align-items-center col-lg-4 mb-2 mb-lg-0 link-dark text-decoration-none dropdown-toggle"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <svg class="bi me-2" width="40" height="32">
                                <use xlink:href="#bootstrap"></use>
                            </svg>
                        </a>
                        <ul class="dropdown-menu text-small shadow">
                            <li><a class="dropdown-item active" href="#" aria-current="page">Overview</a></li>
                            <li><a class="dropdown-item" href="#">Inventory</a></li>
                            <li><a class="dropdown-item" href="#">Customers</a></li>
                            <li><a class="dropdown-item" href="#">Products</a></li>
                            <li>
                                <hr class="dropdown-divider">
                            </li>
                            <li><a class="dropdown-item" href="#">Reports</a></li>
                            <li><a class="dropdown-item" href="#">Analytics</a></li>
                        </ul>
                    </div>
                    <div class="d-flex align-items-center">
                        <form class="w-100 me-3" role="search">
                            <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                <li><a class="dropdown-item" href="index.php?page=user">Utilisateurs</a>
                                <li><a class="dropdown-item" href="index.php?page=role">Rôles</a>
                                <li><a class="dropdown-item" href="index.php?page=wdw">Who did what?</a>

                                <li Class="nav-item dropdown">
                                    <a class="nav-link dropdown-toggle" id="navbarDropdownAssignationLink" href="#"
                                        data-toggle="dropdown" style="color:black">&nbsp&nbsp&nbsp&nbspLiens utiles</a>
                                    <ul class="submenu dropdown-menu" aria-labelledby="navbarDropdownAssignationLink">
                                        <li><a class="dropdown-item" href="http://<?= $serveur; ?>/phpmyadmin/"
                                                target='_blank'>phpMyAdmin (<?= $serveur; ?>)</a></li>
                                    </ul>
                                </li>

                            </ul>
                        </form>
                        <div class="flex-shrink-0 dropdown">
                            <a href="#" class="d-block link-dark text-decoration-none dropdown-toggle" data-bs-toggle="dropdown"
                                aria-expanded="false">
                                <img src="assets/images/logodrht_30.png" alt="mdo" width="32" height="32" class="rounded-circle">
                            </a>
                            <ul class="dropdown-menu text-small shadow">
                                <li><a class="dropdown-item" href="#">New project...</a></li>
                                <li><a class="dropdown-item" href="#">Settings</a></li>
                                <li><a class="dropdown-item" href="#">Profile</a></li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="index.php?page=d">Déconnexion</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </header>
        <?php
        } else if ($StyleMenu == 5) {
        ?>

            <header class="navbar navbar-dark sticky-top bg-dark flex-md-nowrap p-0 shadow">
                <a class="navbar-brand col-md-3 col-lg-2 me-0 px-3" href="index.php">
                    <img src="assets/images/logodrht_30.png" width="30" height="30" class="d-inline-block align-top" alt="">
                    <?= $NomSiteCap; ?>
                </a>
                <a class="navbar-brand abs" href="#"> #
                    <h3 class="nav-link ">
                        Reoleweb - Immobilier
                    </h3>
                </a>
                <button class="navbar-toggler position-absolute d-md-none collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#sidebarMenu" aria-controls="sidebarMenu" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="navbar-nav ms-auto d-flex align-items-center">
                    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                        <!-- Assignation Dropdown -->
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown"
                                aria-expanded="false">
                                Assignation
                            </a>
                            <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                <li><a class="dropdown-item" href="/gestionvisiteur/assignationAjoutModif.php">Assignation du
                                        personnel</a></li>
                                <?PHP // Removed department-specific functionality ?>
                            </ul>
                        </li>

                        <!-- Rapport AIC Dropdown - Removed department dependency -->
                        <?PHP // if ($departement->rapportAicDep == 1) { ?>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown"
                                    aria-expanded="false">
                                    Rapport AIC
                                </a>
                                <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                    <li><a class="dropdown-item" href="/gestionvisiteur/rapportAic.php">Rapport</a></li>
                                    <li><a class="dropdown-item" href="/gestionvisiteur/rapportAicEpisode.php">Rapport
                                            patient/Episode</a></li>
                                </ul>
                            </li>
                        <?PHP // } ?>

                        <!-- Gestion Dropdown -->
                        <?PHP if ($user->isGestion($user)) { ?>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownGestion" role="button"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                    Gestion
                                </a>
                                <ul class="dropdown-menu" aria-labelledby="navbarDropdownGestion">
                                    <li><a class="dropdown-item" href="index.php?page=dep">Unité de soins</a></li>
                                    <li><a class="dropdown-item" href="index.php?page=po">Poste</a></li>
                                </ul>
                            </li>
                        <?PHP } ?>

                        <!-- À propos -->
                        <li class="nav-item">
                            <a class="nav-link" href="index.php?page=ab">À propos</a>
                        </li>
                    </ul>

                    <ul class="navbar-nav">
                        <?php if ($user->isAdmin($user)) { ?>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownAdmin" role="button"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                    Outils d'administration
                                </a>
                                <ul class="dropdown-menu" aria-labelledby="navbarDropdownAdmin">
                                    <li><a class="dropdown-item" href="index.php?page=user">Utilisateurs</a></li>
                                    <li><a class="dropdown-item" href="index.php?page=role">Rôles</a></li>
                                </ul>
                            </li>
                        <?php } ?>

                        <!-- User Profile Dropdown -->
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownUser" role="button"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                <?= $user->firstname . " " . $user->lastname; ?>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdownUser">
                                <li><a class="dropdown-item" href="index.php?page=d">Déconnexion</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </header>


<?PHP
        }
    }
};
?>
