<?PHP
namespace Views;

class MessagesHtml
{
    static public function AfficherMessages($resultMessage)
    {
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");
?>

        <main class="<?php echo $mainClass; ?> ms-sm-auto px-md-4 py-4" id="main-content" style="display: none;">
            <div class="card card-mh-90vh">
                <div class="card-header">
                    <b>Messages</b>
                </div>
                <div class="card-body">


                    <?php
                    if (isset($_GET["msg"])) {
                        $msg = $_GET["msg"];

                        // Define messages and their alert types with Font Awesome icons
                        $alerts = [
                            "updated" => ["success", "fas fa-check-circle", "Utilisateur mis à jour avec succès."],
                            "deleted" => ["success", "fas fa-check-circle", "Utilisateur supprimé avec succès."],
                            "added" => ["success", "fas fa-check-circle", "Utilisateur ajouté avec succès."],
                            "errorsupr" => ["warning", "fas fa-exclamation-triangle", "Erreur suppression, réessayez plus tard ou contactez ".$errorMsgService."."],
                            "erroraddedit" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnu, réessayez plus tard ou contactez ".$errorMsgService."."],
                            "errorajax" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnu, réessayez plus tard ou contactez ".$errorMsgService."."]
                        ];

                        // Display alert if message exists in array
                        if (array_key_exists($msg, $alerts)) {
                            list($alertType, $icon, $message) = $alerts[$msg];
                            echo '<div class="alert alert-' . $alertType . '" id="alertMessageSuggestion" role="alert">
                                <i class="' . $icon . ' me-2"></i> ' . $message . '
                            </div>';
                        }
                    }
                    ?>
                    <table id="gridSuggestions" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th>ID Suggestion</th>
                                <th>Utilisateur id_user</th>
                                <th>suggestion_text</th>
                                <th>user_comment</th>
                                <th>analyst_comment</th>
                                <th>dt_suggestion</th>
                                <th>dt_completed</th>
                                <th>dt_annulation</th>
                                <th>Statut</th>
                                <th>sss</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php

                            foreach ($resultMessage as $row) {
                                $UserName = !empty($row["UserName"]) ? strtoupper($row["UserName"]): "Inconnu";
                                echo '
                                <tr>
                                    <td style="text-align: center;"><b>' . $row["id_suggestion"] . '</b></td>
                                    <td><b>' . $UserName . '</b></td>
                                    <td>' . $row["suggestion_text"] . '</td>
                                    <td>' . $row["user_comment"] . '</td>
                                    <td>' . $row["analyst_comment"] . '</td>
                                    <td>' . $row["dt_suggestion"] . '</td>
                                    <td>' . $row["dt_completed"] . '</td>
                                    <td>' . $row["dt_annulation"] . '</td>
                                    <td>Lu</td>
                                    <td style="text-align: center;"></td>
                                </tr>';
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>ID Suggestion</th>
                                <th>Utilisateur id_user</th>
                                <th>suggestion_text</th>
                                <th>user_comment</th>
                                <th>analyst_comment</th>
                                <th>dt_suggestion</th>
                                <th>dt_completed</th>
                                <th>dt_annulation</th>
                                <th>Statut</th>
                                <th>sss</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </main>
<?php
    }
}
?>
