<?php

namespace Views;

class LoginModalHtml
{
    /**
     * Génère le modal de connexion requise
     * Utilisé pour les fonctionnalités nécessitant une authentification (favoris, alertes, etc.)
     */
    public static function renderLoginModal()
    {
?>
        <!-- Modal Connexion Requise -->
        <div class="modal fade" id="loginRequiredModal" tabindex="-1" aria-labelledby="loginRequiredModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content border-0 shadow-lg">
                    <div class="modal-header bg-gradient-purple text-white border-0">
                        <div>
                            <h5 class="modal-title fw-bold mb-1" id="loginRequiredModalLabel">
                                <i class="fas fa-user-lock me-2"></i>Connectez-vous pour continuer
                            </h5>
                            <p class="mb-0 small opacity-90">Accédez à toutes les fonctionnalités</p>
                        </div>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body p-4">
                        <div class="text-center mb-4">
                            <div class="login-icon-wrapper mb-3">
                                <i class="fas fa-heart fa-3x text-gradient-purple"></i>
                            </div>
                            <p class="text-muted fs-6">Découvrez tous les avantages d'un compte DuProprio :</p>
                        </div>
                        
                        <ul class="list-unstyled features-list">
                            <li class="d-flex align-items-start mb-3">
                                <i class="fas fa-check-circle text-success me-3 mt-1"></i>
                                <div>
                                    <strong>Sauvegardez vos recherches</strong>
                                    <p class="text-muted small mb-0">Retrouvez facilement vos critères de recherche</p>
                                </div>
                            </li>
                            <li class="d-flex align-items-start mb-3">
                                <i class="fas fa-check-circle text-success me-3 mt-1"></i>
                                <div>
                                    <strong>Enregistrez vos propriétés favorites</strong>
                                    <p class="text-muted small mb-0">Créez votre liste de coups de cœur</p>
                                </div>
                            </li>
                            <li class="d-flex align-items-start mb-3">
                                <i class="fas fa-check-circle text-success me-3 mt-1"></i>
                                <div>
                                    <strong>Recevez des alertes en temps réel</strong>
                                    <p class="text-muted small mb-0">Soyez informé dès qu'une nouvelle annonce correspond</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="modal-footer border-0 pt-0 pb-4 px-4">
                        <div class="d-grid gap-2 w-100">
                            <a href="index.php?page=login" class="btn btn-gradient-purple btn-lg">
                                <i class="fas fa-sign-in-alt me-2"></i>Se connecter
                            </a>
                            <a href="index.php?page=register" class="btn btn-outline-primary btn-lg">
                                <i class="fas fa-user-plus me-2"></i>Créer un compte
                            </a>
                        </div>
                        <p class="text-center text-muted small mt-3 mb-0">
                            C'est gratuit et rapide !
                        </p>
                    </div>
                </div>
            </div>
        </div>
<?php
    }

    /**
     * Génère le script JavaScript pour gérer le modal de connexion
     * @param string $triggerSelector - Sélecteur CSS des éléments qui déclenchent le modal
     */
    public static function renderLoginModalScript($triggerSelector = '.btn-favorite')
    {
?>
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Vérifier si l'utilisateur est connecté
            const isLoggedIn = <?= isset($_SESSION['user_id']) ? 'true' : 'false' ?>;
            
            // Gérer les clics sur les éléments qui nécessitent une connexion
            const triggerElements = document.querySelectorAll('<?= $triggerSelector ?>');
            
            triggerElements.forEach(function(element) {
                element.addEventListener('click', function(e) {
                    if (!isLoggedIn) {
                        e.preventDefault();
                        const modal = new bootstrap.Modal(document.getElementById('loginRequiredModal'));
                        modal.show();
                    } else {
                        // L'utilisateur est connecté, toggle la classe active
                        this.classList.toggle('active');
                        
                        // Ici vous pouvez ajouter votre logique AJAX pour sauvegarder/retirer le favori
                        const annonceId = this.getAttribute('data-annonce-id');
                        if (annonceId) {
                            // Exemple: saveFavorite(annonceId);
                        }
                    }
                });
            });
        });
        </script>
<?php
    }
}
