<?PHP

namespace Views;

class LoginHtml
{
	static public function afficheLogin($sharedMessage)
	{
		include_once("FunctionHtml.php");
		include_once("Classe/FunctionClasse.php");
		include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");

		// Détecter le préfixe de chemin selon le contexte
		$pathPrefix = '';
		if (strpos($_SERVER['REQUEST_URI'], '/admin/') !== false || strpos($_SERVER['REQUEST_URI'], '/visiteur/') !== false) {
			$pathPrefix = '../';
		}

?>
		<!DOCTYPE html>
		<html lang="fr">
		<head>
			<meta charset="utf-8">
			<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
			<meta name="author" content="Ahmed ZERZIH">
			<title><?= $NomSiteCap ?> - Connexion Immobilier</title>
			<link rel="icon" href="<?= $pathPrefix ?>assets/images/favicon.ico" type="image/x-icon">
			<link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/vendor/bootstrap-5.2.3/css/bootstrap.min.css" />
			<link href="<?= $pathPrefix ?>assets/vendor/fontawesome-free-5.2.0-web/css/all.min.css" rel="stylesheet">
			<link href="<?= $pathPrefix ?>assets/vendor/bootstrap-icons-1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
			<link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/css/utils.css" />
			
			<style>
				/* Design immobilier moderne */
				body {
					background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
					min-height: 100vh;
					font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
				}
				
				.login-container {
					min-height: 100vh;
					display: flex;
					align-items: center;
					justify-content: center;
					padding: 20px;
				}
				
				.login-card {
					background: rgba(255, 255, 255, 0.95);
					backdrop-filter: blur(10px);
					border-radius: 20px;
					box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
					border: 1px solid rgba(255, 255, 255, 0.2);
					overflow: hidden;
					max-width: 1000px;
					width: 100%;
				}
				
				.login-left {
					background: linear-gradient(45deg, #2c3e50, #34495e);
					color: white;
					padding: 3rem;
					position: relative;
					overflow: hidden;
				}
				
				.login-left::before {
					content: '';
					position: absolute;
					top: 0;
					left: 0;
					right: 0;
					bottom: 0;
					background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path d="M20,20 L80,20 L80,80 L20,80 Z" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="0.5"/><path d="M30,30 L70,30 L70,70 L30,70 Z" fill="none" stroke="rgba(255,255,255,0.05)" stroke-width="0.5"/></svg>') repeat;
					opacity: 0.3;
				}
				
				.login-right {
					padding: 3rem;
					background: white;
				}
				
				.brand-logo {
					width: 80px;
					height: 80px;
					background: rgba(255, 255, 255, 0.2);
					border-radius: 20px;
					display: flex;
					align-items: center;
					justify-content: center;
					margin-bottom: 2rem;
				}
				
				.feature-item {
					display: flex;
					align-items: center;
					margin-bottom: 1.5rem;
				}
				
				.feature-icon {
					width: 50px;
					height: 50px;
					background: rgba(255, 255, 255, 0.2);
					border-radius: 12px;
					display: flex;
					align-items: center;
					justify-content: center;
					margin-right: 1rem;
				}
				
				.form-floating label {
					color: #666;
				}
				
				.form-control {
					border-radius: 12px;
					border: 2px solid #e9ecef;
					padding: 0.75rem 1rem;
					transition: all 0.3s ease;
				}
				
				.form-control:focus {
					border-color: #667eea;
					box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
				}
				
				.btn-login {
					background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
					border: none;
					border-radius: 12px;
					padding: 0.75rem 2rem;
					font-weight: 600;
					text-transform: uppercase;
					letter-spacing: 1px;
					transition: all 0.3s ease;
				}
				
				.btn-login:hover {
					transform: translateY(-2px);
					box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
				}
				
				.stats-item {
					text-align: center;
					padding: 1rem;
				}
				
				.stats-number {
					font-size: 2rem;
					font-weight: bold;
					color: #667eea;
				}
				
				.floating-elements {
					position: absolute;
					top: 0;
					left: 0;
					right: 0;
					bottom: 0;
					overflow: hidden;
					pointer-events: none;
				}
				
				.floating-house {
					position: absolute;
					color: rgba(255, 255, 255, 0.1);
					animation: float 6s ease-in-out infinite;
				}
				
				.floating-house:nth-child(1) { top: 10%; left: 10%; animation-delay: 0s; }
				.floating-house:nth-child(2) { top: 20%; right: 10%; animation-delay: 2s; }
				.floating-house:nth-child(3) { bottom: 20%; left: 15%; animation-delay: 4s; }
				
				@keyframes float {
					0%, 100% { transform: translateY(0px); }
					50% { transform: translateY(-10px); }
				}
				
				/* Loading spinner */
				.loading-overlay {
					position: fixed;
					top: 0;
					left: 0;
					width: 100%;
					height: 100%;
					background: rgba(255, 255, 255, 0.9);
					display: none;
					align-items: center;
					justify-content: center;
					z-index: 9999;
				}
				
				.loading-spinner {
					width: 60px;
					height: 60px;
					border: 4px solid #f3f3f3;
					border-top: 4px solid #667eea;
					border-radius: 50%;
					animation: spin 1s linear infinite;
				}
				
				.loading-text {
					margin-top: 20px;
					font-size: 16px;
					color: #667eea;
					font-weight: 500;
				}
				
				@keyframes spin {
					0% { transform: rotate(0deg); }
					100% { transform: rotate(360deg); }
				}
				
				.success-message {
					color: #28a745;
					font-weight: bold;
					margin-top: 10px;
				}
			</style>
		</head>

		<body>
			<!-- Loading overlay -->
			<div class="loading-overlay" id="loadingOverlay">
				<div class="text-center">
					<div class="loading-spinner"></div>
					<div class="loading-text" id="loadingText">Connexion en cours...</div>
				</div>
			</div>
			<div class="login-container">
				<div class="login-card">
					<div class="row g-0 h-100">
						<!-- Partie gauche - Branding et features -->
						<div class="col-lg-6 login-left">
							<div class="floating-elements">
								<i class="floating-house fas fa-home fa-2x"></i>
								<i class="floating-house fas fa-building fa-2x"></i>
								<i class="floating-house fas fa-key fa-2x"></i>
							</div>
							
							<div class="position-relative">
								<div class="brand-logo">
									<i class="fas fa-home fa-2x text-white"></i>
								</div>
								
								<h2 class="fw-bold mb-3"><?= $NomSiteCap ?></h2>
								<p class="fs-5 mb-4 opacity-75">Votre plateforme immobilière de confiance</p>
								
								<div class="feature-item">
									<div class="feature-icon">
										<i class="fas fa-search text-white"></i>
									</div>
									<div>
										<h6 class="mb-1">Recherche Avancée</h6>
										<small class="opacity-75">Trouvez le bien parfait selon vos critères</small>
									</div>
								</div>
								
								<div class="feature-item">
									<div class="feature-icon">
										<i class="fas fa-chart-line text-white"></i>
									</div>
									<div>
										<h6 class="mb-1">Estimations Précises</h6>
										<small class="opacity-75">Prix du marché en temps réel</small>
									</div>
								</div>
								
								<div class="feature-item">
									<div class="feature-icon">
										<i class="fas fa-shield-alt text-white"></i>
									</div>
									<div>
										<h6 class="mb-1">Transactions Sécurisées</h6>
										<small class="opacity-75">Accompagnement professionnel garanti</small>
									</div>
								</div>
								
								<!-- Statistiques -->
								<div class="row mt-4 pt-4 border-top border-white border-opacity-25">
									<div class="col-4 stats-item">
										<div class="stats-number text-white">500+</div>
										<small class="opacity-75">Biens</small>
									</div>
									<div class="col-4 stats-item">
										<div class="stats-number text-white">98%</div>
										<small class="opacity-75">Satisfaction</small>
									</div>
									<div class="col-4 stats-item">
										<div class="stats-number text-white">24h</div>
										<small class="opacity-75">Support</small>
									</div>
								</div>
							</div>
						</div>
						
						<!-- Partie droite - Formulaire de connexion -->
						<div class="col-lg-6 login-right">
							<div class="text-center mb-4">
								<h3 class="fw-bold text-dark mb-2">Bienvenue</h3>
								<p class="text-muted">Connectez-vous à votre espace immobilier</p>
							</div>
								<!-- Messages d'erreur -->
							<?php if (isset($sharedMessage) && $sharedMessage != ""): ?>
								<div class="alert alert-danger alert-dismissible fade show" id="alertMessage" role="alert">
									<i class="fas fa-exclamation-triangle me-2"></i>
									<?= $sharedMessage ?>
									<button type="button" class="btn-close" data-bs-dismiss="alert"></button>
								</div>
							<?php endif; ?>

							<!-- Formulaire de connexion -->
							<form name="login" action="index.php?page=lsl" method="post" autocomplete="off" class="needs-validation" novalidate>
								<div class="form-floating mb-2">
									<input type="text" class="form-control" id="user" name="user" placeholder="Nom d'utilisateur" required>
									<label for="user"><i class="fas fa-user me-2"></i>Nom d'utilisateur</label>
									<div class="invalid-feedback">
										Veuillez saisir votre nom d'utilisateur.
									</div>
								</div>

								<div class="form-floating mb-2">
									<input type="password" class="form-control" id="password" name="password" placeholder="Mot de passe" required>
									<label for="password"><i class="fas fa-lock me-2"></i>Mot de passe</label>
									<div class="input-group-append position-absolute" style="right: 15px; top: 50%; transform: translateY(-50%); z-index: 10;">
										<button class="btn btn-link p-0" type="button" id="togglePassword">
											<i class="fas fa-eye text-muted"></i>
										</button>
									</div>
									<div class="invalid-feedback">
										Veuillez saisir votre mot de passe.
									</div>
								</div>

								<div class="form-check mb-2">
									<input class="form-check-input" type="checkbox" id="rememberMe" name="rememberMe" value="1">
									<label class="form-check-label" for="rememberMe">
										Se souvenir de moi
									</label>
								</div>

								<button type="submit" class="btn btn-login w-100 text-white fw-bold" autofocus>
									<i class="fas fa-sign-in-alt me-2"></i>
									Se connecter
								</button>

								<div class="row mt-3">
									<div class="col-6">
										<a href="#" class="text-decoration-none text-muted small" data-bs-toggle="modal" data-bs-target="#contactModal">
											<i class="fas fa-question-circle me-1"></i>
											Mot de passe oublié ?
										</a>
									</div>
									<div class="col-6 text-end">
										<a href="../index.php" class="text-decoration-none text-muted small">
											<i class="fas fa-arrow-left me-1"></i>
											Retour au site
										</a>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>

			<!-- Modal de contact -->
			<div class="modal fade" id="contactModal" tabindex="-1" aria-labelledby="contactModalLabel" aria-hidden="true">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content border-0 shadow">
						<div class="modal-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
							<h5 class="modal-title text-white" id="contactModalLabel">
								<i class="fas fa-headset me-2"></i>Support Client
							</h5>
							<button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
						</div>
						<div class="modal-body p-4">
							<div class="text-center mb-3">
								<i class="fas fa-phone-alt fa-2x text-primary mb-2"></i>
								<h6>Besoin d'aide ?</h6>
							</div>
							<?= $bodyService ?>
						</div>
						<div class="modal-footer border-0">
							<button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
								<i class="fas fa-times me-1"></i>Fermer
							</button>
						</div>
					</div>
				</div>
			</div>

			<!-- Footer -->
			<div class="position-fixed bottom-0 start-0 end-0 bg-white bg-opacity-90 backdrop-blur p-2 border-top">
				<div class="container-fluid">
					<div class="row text-center">
						<div class="col-md-6">
							<small class="text-muted">
								© <?= $yearVersion ?> <?= $compagnyName ?> - Tous droits réservés
							</small>
						</div>
						<div class="col-md-6">
							<small class="text-muted">
								Version <?= $versionApp ?> (<?= $dateHourVersion ?>)
							</small>
						</div>
					</div>
				</div>
			</div>

			<!-- Scripts -->
			<script src="<?= $pathPrefix ?>assets/vendor/jQuery-3.7.1/jquery-3.7.1.min.js"></script>
			<script src="<?= $pathPrefix ?>assets/vendor/bootstrap-5.2.3/js/bootstrap.bundle.min.js"></script>
			<script>
				$(document).ready(function() {
					// Vérifier si déjà connecté au chargement
					checkExistingConnection();
					
					// Validation du formulaire avec gestion de la progression
					var loginForm = document.querySelector('form[name="login"]');
					if (loginForm) {
						loginForm.addEventListener('submit', function(event) {
							event.preventDefault(); // Empêcher soumission normale
							
							// Valider le formulaire
							if (this.checkValidity() === false) {
								event.stopPropagation();
								this.classList.add('was-validated');
								return;
							}
							
							// Démarrer le processus de connexion
							startLoginProcess(this);
						});
					}

					// Masquer les messages d'erreur automatiquement
					setTimeout(function() {
						$("#alertMessage").fadeOut("slow");
					}, 8000);

					// Masquer les alertes lors de la saisie
					$("input[name='user'], input[name='password']").on("input", function() {
						$("#alertMessage").fadeOut("slow");
						$(this).removeClass('is-invalid');
					});

					// Toggle du mot de passe
					$('#togglePassword').click(function(e) {
						e.preventDefault();
						const input = $('#password');
						const icon = $(this).find('i');

						if (input.attr('type') === 'password') {
							input.attr('type', 'text');
							icon.removeClass('fa-eye').addClass('fa-eye-slash');
						} else {
							input.attr('type', 'password');
							icon.removeClass('fa-eye-slash').addClass('fa-eye');
						}
					});

					// Animation de focus sur les champs
					$('.form-floating input').on('focus', function() {
						$(this).parent().addClass('focused');
					}).on('blur', function() {
						if (!$(this).val()) {
							$(this).parent().removeClass('focused');
						}
					});

					// Auto-focus sur le premier champ
					$('#user').focus();
				});
				
				function checkExistingConnection() {
					// Vérifier s'il y a une session active
					var currentPath = window.location.pathname;
					var checkUrl = currentPath + '?page=check_session';
					
					$.ajax({
						url: checkUrl,
						method: 'GET',
						timeout: 3000,
						dataType: 'json',
						success: function(response) {
							if (response && response.connected === true) {
								showLoadingOverlay();
								$('#loadingText').text('Connexion détectée, redirection...');
								
								setTimeout(function() {
									if (response.isAdmin === true) {
										window.location.href = '../admin/';
									} else {
										window.location.href = '../visiteur/';
									}
								}, 1500);
							}
						},
						error: function(xhr, textStatus, errorThrown) {
							// Pas de session active ou erreur, continuer normalement
							console.log('Pas de session active détectée');
						}
					});
				}
				
				function startLoginProcess(form) {
					showLoadingOverlay();
					$('#loadingText').text('Vérification des identifiants...');
					
					// Simuler progression
					setTimeout(function() {
						$('#loadingText').text('Connexion en cours...');
						
						// Soumettre le formulaire de façon normale (pas AJAX)
						setTimeout(function() {
							form.submit(); // Soumission normale du formulaire
						}, 500);
					}, 800);
				}
				
				function showLoadingOverlay() {
					$('#loadingOverlay').fadeIn(300);
				}
				
				function hideLoadingOverlay() {
					$('#loadingOverlay').fadeOut(300);
				}
				
				function showError(message) {
					var alertHtml = '<div class="alert alert-danger alert-dismissible fade show" role="alert">' +
						'<i class="fas fa-exclamation-triangle me-2"></i>' + message +
						'<button type="button" class="btn-close" data-bs-dismiss="alert"></button>' +
						'</div>';
					
					$('.login-right').prepend(alertHtml);
					
					setTimeout(function() {
						$('.alert').fadeOut("slow");
					}, 5000);
				}
			</script>

		</body>
		</html>

<?PHP
	}
} ?>