<?PHP
namespace Views;

class departementHtml
{
	static public function AfficherListeDepartement($result)
	{
		include_once("FunctionHtml.php");
		include_once("Classe/FunctionClasse.php");
		include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");
?>
		<main class="<?php echo $mainClass; ?> ms-sm-auto px-md-4 py-4" id="main-content" style="display: none;">
			<div class="card card-mh-90vh">
				<div class="card-header">
					<b>Liste des rôles</b>
				</div>
				<div class="card-body">

					<?php
					if (isset($_GET["msg"])) {
						$msg = $_GET["msg"];
						$alerts = [
							"updated" => ["success", "fas fa-check-circle", "Département mis à jour avec succès."],
							"deleted" => ["success", "fas fa-check-circle", "Département supprimé avec succès."],
							"added" => ["success", "fas fa-check-circle", "Département ajoutée avec succès."],
							"errorsupr" => ["warning", "fas fa-exclamation-triangle", "Erreur suppression, réessayez plus tard ou contactez ".$errorMsgService."."],
							"erroraddedit" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnue, réessayez plus tard ou contactez ".$errorMsgService."."],
							"errorajax" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnu, réessayez plus tard ou contactez ".$errorMsgService."."]
						];

						if (array_key_exists($msg, $alerts)) {
							list($alertType, $icon, $message) = $alerts[$msg];
							echo '<div class="alert alert-' . $alertType . '" id="alertMessage" role="alert">
					<i class="' . $icon . '"></i> ' . $message . '
				  </div>';
						}
					}
					?>
					<table id="gridDepartements" class="display" style="width:100%">
						<thead>
							<tr>
								<th>ID</th>
								<th>Nom</th>
								<th>Commentaires</th>
								<th>Options</th>
							</tr>
						</thead>
						<tbody>
							<?php
							foreach ($result as $row) {
								echo '
								<tr>
									<td style="text-align: center;" width="100px"><b>' . $row["id_departement"] . '</b></td>
									<td>' . $row["nom_departement"] . '</td>
									<td>' . $row["commentaire"] . '</td>
									<td style="text-align: center;" width="100px">
									<a class="departement-edit-link" title="Modifier département Num : ' . $row["id_departement"] . '" data-id="' . $row["id_departement"] . '"><span class="fas fa-edit m-1" style="color: green;"></span></a>
									<a class="departement-delete-link" title="Supprimer ce département Num : ' . $row["id_departement"] . '" data-id="' . $row["id_departement"] . '"><span class="fas fa-trash m-1" style="color: red;"></span></a>
									</td>
								</tr>';
							}
							?>
						</tbody>
						<tfoot>
							<tr>
								<th>ID</th>
								<th>Nom</th>
								<th>Commentaires</th>
								<th></th>
							</tr>
						</tfoot>
					</table>
				</div>
			</div>

			<div class="modal fade" id="modalFormAddEditDepartement" tabindex="-1" aria-labelledby="modalFormAddEditDepartementLabel"
				aria-hidden="true" data-bs-backdrop="static">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title" id="modalFormAddEditDepartementLabel">Département - Ajout/Modification</h5>
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						</div>
						<form name="formAddEditDepartement" id="formAddEditDepartement" action="#" method="post" enctype="multipart/form-data"
							autocomplete="off">
							<div class="modal-body">
								<input type="hidden" id="idDepartementToEdit" name="idDepartementToEdit" value="" />
								<input type="hidden" id="page" name="page" value="Dep" />
								<input type="hidden" id="typeSend" name="typeSend" value="" />

								<div class="alert alert-warning" id="alertMessageDepartementModal" role="alert"></div>
								<div class="col-md-12 mb-3">
									<label class="form-label" for="departementName">Nom du département <span class="text-danger">*</span></label>
									<input class="form-control" type="text" name="departementName" id="departementName" required
										value="" />
									<div id="departementNameError" class="invalid-feedback">Champ requis.</div>
								</div>
								<div class="col-md-12 mb-3">
									<label class="form-label" for="departementComment">Commentaire (optionnel)</label>
									<textarea class="form-control" name="departementComment" id="departementComment" rows="2"
										style="resize: vertical;"> </textarea>
								</div>
							</div>
						</form>
						<div class="modal-footer d-flex justify-content-between align-items-center">
							<small class="text-muted"><span class="text-danger">*</span> Champs obligatoires</small>
							<div>
								<button type="button" id="confirmSubmitDepartement" class="btn btn-primary">Enregistrer</button>
								<button type="button" id="cancelSubmitDepartement" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
							</div>
						</div>
					</div>
				</div>

				<div class="modal fade" id="confirmDeletionModalDepartement" tabindex="-1" aria-labelledby="confirmDeletionModalLabelDepartement"
					aria-hidden="true" data-bs-backdrop="static">
					<div class="modal-dialog modal-dialog-centered">
						<div class="modal-content">
							<div class="modal-header">
								<h5 class="modal-title" id="confirmDeletionModalLabelDepartement">Confirmer la suppression</h5>
								<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
							</div>
							<div class="alert alert-warning m-3" id="alertMessageModalDeleteDepartement" role="alert"></div>
							<div class="modal-body" id="confirmDeletionBodyDepartement">
								Vouslez-vous vraiment supprimer ce département ?
							</div>
							<div class="modal-footer">
								<input type="hidden" name="typeConfirmDeletionDepartement" value="" />
								<input type="hidden" name="idDepartementToDelete" value="" />
								<button type="button" class="btn btn-danger" id="confirmDeletionDepartement">Oui, Supprimer</button>
								<button type="button" class="btn btn-secondary" id="dismissDeletionDepartement" data-bs-dismiss="modal">Non</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</main>

<?PHP
	}
} ?>
