<?PHP
namespace Views;

class DashboardHtml
{
    /**
     * Obtient les libellés personnalisés selon le rôle de l'utilisateur
     */
    private static function getCustomLabels($userRoles)
    {
        // Labels par défaut pour visiteurs
        $labels = [
            'dashboard' => 'Mon espace',
            'annonces' => 'Mes annonces',
            'contacts' => 'Mes contacts reçus',
            'gestion' => 'Gestion',
            'stats' => 'Mes performances'
        ];

        // Vérifier les rôles pour personnaliser
        if (isset($userRoles) && !empty($userRoles)) {
            foreach ($userRoles as $role) {
                $roleName = $role['role_name'] ?? '';
                $niveauAcces = $role['niveau_acces'] ?? 0;

                // Administrateurs
                if (in_array($roleName, ['Administrateur', 'Super Administrateur']) || $niveauAcces >= 90) {
                    $labels = [
                        'dashboard' => 'Centre de contrôle',
                        'annonces' => 'Toutes les annonces',
                        'contacts' => 'Tous les contacts',
                        'gestion' => 'Administration',
                        'stats' => 'Statistiques globales'
                    ];
                    break;
                }
                // Agents Premium
                elseif (in_array($roleName, ['Agent Premium', 'Modérateur']) || $niveauAcces >= 70) {
                    $labels = [
                        'dashboard' => 'Espace Pro Premium',
                        'annonces' => 'Mon portefeuille Pro',
                        'contacts' => 'Leads clients',
                        'gestion' => 'Gestion avancée',
                        'stats' => 'Analytics Pro'
                    ];
                    break;
                }
                // Agents Standard
                elseif (in_array($roleName, ['Agent Standard', 'Gestionnaire']) || $niveauAcces >= 40) {
                    $labels = [
                        'dashboard' => 'Espace Pro',
                        'annonces' => 'Mes mandats',
                        'contacts' => 'Contacts clients',
                        'gestion' => 'Gestion biens',
                        'stats' => 'Mes statistiques'
                    ];
                    break;
                }
                // Agent Particulier
                elseif (in_array($roleName, ['Agent Particulier']) || $niveauAcces >= 20) {
                    $labels = [
                        'dashboard' => 'Mon espace',
                        'annonces' => 'Mes biens',
                        'contacts' => 'Mes contacts',
                        'gestion' => 'Gestion biens',
                        'stats' => 'Mes performances'
                    ];
                    break;
                }
            }
        }

        return $labels;
    }

    static public function AfficherHtmlDashboard($NomSiteCap, $CounterAnnonces, $CounterUsers, $CounterContacts, $CounterAnnoncesAjd, $resultlisteannonces, $resultlistecontacts, $resultStatMonthly, $resultStatYearly, $resultStatAnnoncesYearly, $userType = 'admin', $stats = null)
    {
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");
        
        // Définir la classe CSS principale - pleine largeur car pas de sidebar
        $mainClass = 'col-12';
        
        // Récupérer les informations de l'utilisateur connecté
        global $NomSite;
        $userName = 'Utilisateur';
        $userRole = 'Visiteur';
        
        if (isset($_SESSION[$NomSite]['nom']) && isset($_SESSION[$NomSite]['prenom'])) {
            $userName = $_SESSION[$NomSite]['prenom'] . ' ' . $_SESSION[$NomSite]['nom'];
        }
        
        if (isset($_SESSION[$NomSite]['userRoles']) && !empty($_SESSION[$NomSite]['userRoles'])) {
            $roles = $_SESSION[$NomSite]['userRoles'];
            $roleNames = array_map(function($role) {
                return $role['role_name'] ?? 'Inconnu';
            }, $roles);
            $userRole = implode(', ', $roleNames);
        }

        // Obtenir les libellés personnalisés selon le rôle
        $userRoles = isset($_SESSION[$NomSite]['userRoles']) ? $_SESSION[$NomSite]['userRoles'] : [];
        $customLabels = self::getCustomLabels($userRoles);
?>

        <main class="<?php echo $mainClass; ?> ms-sm-auto px-md-4 dashboard-main-container" id="main-content">
            <!-- Inclusion du CSS spécifique au dashboard -->
            <?php
            // Détecter le contexte pour les chemins d'assets
            $assetPrefix = (strpos($_SERVER['REQUEST_URI'] ?? '', '/visiteur/') !== false || strpos($_SERVER['REQUEST_URI'] ?? '', '/admin/') !== false) ? '../' : '';
            ?>
            <link rel="stylesheet" type="text/css" href="<?php echo $assetPrefix; ?>assets/css/dashboard.css" />
            
            <div class="card card-mh-90vh">
                <div class="card-body">
                    <!-- En-tête personnalisé -->
                    <div class="dashboard-header border-bottom pb-2 mb-3">
                        <div class="row align-items-center">
                            <div class="col">
                                <h1 class="h5 mb-0">
                                    <i class="fas fa-tachometer-alt text-primary me-2"></i><?php echo $customLabels['dashboard']; ?> - <?= htmlspecialchars($userName) ?>
                                </h1>
                            </div>
                            <div class="col-auto">
                                <span class="badge bg-<?= $userType == 'admin' ? 'success' : ($userType == 'agent' ? 'warning' : 'secondary') ?> dashboard-role-badge">
                                    <?= htmlspecialchars($userRole) ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <?php if ($userType == 'admin'): ?>
                        <!-- Dashboard Administrateur -->
                        <?php self::afficherDashboardAdmin($CounterAnnonces, $CounterUsers, $CounterContacts, $CounterAnnoncesAjd, $resultlisteannonces, $resultlistecontacts, $stats); ?>
                    <?php elseif ($userType == 'agent_premium'): ?>
                        <!-- Dashboard Agent Premium -->
                        <?php self::afficherDashboardAgentPremium($CounterAnnonces, $CounterContacts, $CounterAnnoncesAjd, $resultlisteannonces, $resultlistecontacts, $stats); ?>
                    <?php elseif ($userType == 'agent_particulier'): ?>
                        <!-- Dashboard Agent Particulier -->
                        <?php self::afficherDashboardAgentParticulier($CounterAnnonces, $CounterContacts, $CounterAnnoncesAjd, $resultlisteannonces, $resultlistecontacts, $stats); ?>
                    <?php elseif ($userType == 'agent'): ?>
                        <!-- Dashboard Agent (ancien) -->
                        <?php self::afficherDashboardAgent($CounterAnnonces, $CounterContacts, $CounterAnnoncesAjd, $resultlisteannonces, $resultlistecontacts); ?>
                    <?php else: ?>
                        <!-- Dashboard Visiteur -->
                        <?php self::afficherDashboardVisiteur($CounterAnnonces, $CounterContacts, $resultlisteannonces, $stats); ?>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Script pour afficher le contenu du dashboard -->
            <script>
            $(document).ready(function() {
                console.log("Dashboard script loaded");
                
                // Vérifier si l'élément main-content existe
                var mainContent = $("#main-content");
                if (mainContent.length > 0) {
                    console.log("Element main-content trouvé");
                    
                    // Le contenu est déjà visible, pas besoin de fadeIn
                    console.log("Dashboard content displayed");
                } else {
                    console.error("Element main-content non trouvé");
                }
                
                // Configuration pour les graphiques si nécessaire
                if (typeof Chart !== 'undefined') {
                    console.log("Chart.js disponible");
                }
            });
            </script>
        </main>
<?php
    }

    /**
     * Dashboard pour les administrateurs
     */
    private static function afficherDashboardAdmin($CounterAnnonces, $CounterUsers, $CounterContacts, $CounterAnnoncesAjd, $resultlisteannonces, $resultlistecontacts, $stats = null)
    {
?>
        <!-- Statistiques globales -->
        <div class="row mb-4">
            <!-- Total Annonces -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-primary shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Total Annonces
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    <?php echo number_format($CounterAnnonces ?? 0); ?>
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-home fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Utilisateurs Actifs -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-success shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    Utilisateurs Actifs
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    <?php echo number_format($CounterUsers ?? 0); ?>
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-users fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Contacts -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-info shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                    Total Contacts
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    <?php echo number_format($CounterContacts ?? 0); ?>
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-envelope fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Annonces Aujourd'hui -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-warning shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Annonces Aujourd'hui
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    <?php echo number_format($CounterAnnoncesAjd ?? 0); ?>
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-calendar-day fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistiques avancées -->
        <?php if ($stats && isset($stats['users_by_role'])): ?>
        <div class="row mb-4">
            <!-- Répartition des Utilisateurs -->
            <div class="col-lg-6 mb-4">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-info">
                            <i class="fas fa-users"></i> Répartition des Utilisateurs
                        </h6>
                    </div>
                    <div class="card-body">
                        <?php foreach ($stats['users_by_role'] as $role): ?>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="text-sm font-weight-bold">
                                <?php echo htmlspecialchars($role['nom_role'] ?? 'Non défini'); ?>
                            </span>
                            <span class="badge bg-info"><?php echo $role['count'] ?? 0; ?></span>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Statut des Annonces -->
            <div class="col-lg-6 mb-4">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-warning">
                            <i class="fas fa-chart-pie"></i> Statut des Annonces
                        </h6>
                    </div>
                    <div class="card-body">
                        <?php if (isset($stats['annonces_by_status'])): ?>
                            <?php foreach ($stats['annonces_by_status'] as $status): ?>
                            <?php 
                                $statut = $status['statut'] ?? 'inconnu';
                                $badge = $statut === 'active' ? 'success' : ($statut === 'vendu' ? 'primary' : 'secondary');
                            ?>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-sm font-weight-bold">
                                    <?php echo htmlspecialchars(ucfirst($statut)); ?>
                                </span>
                                <span class="badge bg-<?php echo $badge; ?>">
                                    <?php echo $status['count'] ?? 0; ?>
                                </span>
                            </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Top villes et revenus -->
        <?php if ($stats && isset($stats['top_cities'])): ?>
        <div class="row mb-4">
            <!-- Top 5 Villes -->
            <div class="col-lg-6 mb-4">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-success">
                            <i class="fas fa-map-marker-alt"></i> Top 5 Villes
                        </h6>
                    </div>
                    <div class="card-body">
                        <?php foreach ($stats['top_cities'] as $city): ?>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="text-sm font-weight-bold">
                                <?php echo htmlspecialchars($city['ville'] ?? 'Non défini'); ?>
                            </span>
                            <span class="badge bg-success">
                                <?php echo ($city['count'] ?? 0); ?> annonces
                            </span>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Revenus Mensuels -->
            <div class="col-lg-6 mb-4">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-dark">
                            <i class="fas fa-euro-sign"></i> Revenus Mensuels Estimés
                        </h6>
                    </div>
                    <div class="card-body">
                        <?php if (isset($stats['monthly_revenue'])): ?>
                            <?php 
                            $months = ['Jan', 'Fév', 'Mar', 'Avr', 'Mai', 'Jun', 'Jul', 'Aoû', 'Sep', 'Oct', 'Nov', 'Déc'];
                            foreach ($stats['monthly_revenue'] as $revenue):
                                $monthNum = (int)($revenue['month'] ?? 0);
                                $monthName = $months[$monthNum - 1] ?? ('Mois ' . $monthNum);
                            ?>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-sm font-weight-bold"><?php echo $monthName; ?></span>
                                <span class="badge bg-dark"><?php echo number_format($revenue['revenue'] ?? 0); ?> DA</span>
                            </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Dernières annonces et contacts -->
        <div class="row">
            <!-- Dernières Annonces -->
            <?php if (!empty($resultlisteannonces)): ?>
            <div class="col-lg-6 mb-4">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-primary">
                            <i class="fas fa-list-alt"></i> Dernières Annonces
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Titre</th>
                                        <th>Prix</th>
                                        <th>Ville</th>
                                        <th>Propriétaire</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($resultlisteannonces as $annonce): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($annonce['titre'] ?? ''); ?></td>
                                        <td><?php echo number_format($annonce['prix'] ?? 0); ?> DA</td>
                                        <td><?php echo htmlspecialchars($annonce['ville'] ?? ''); ?></td>
                                        <td><?php echo htmlspecialchars(($annonce['nom'] ?? '') . ' ' . ($annonce['prenom'] ?? '')); ?></td>
                                        <td><?php echo !empty($annonce['date_creation']) ? date('d/m', strtotime($annonce['date_creation'])) : ''; ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <!-- Derniers Contacts -->
            <?php if (!empty($resultlistecontacts)): ?>
            <div class="col-lg-6 mb-4">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-success">
                            <i class="fas fa-envelope-open"></i> Derniers Contacts
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Nom</th>
                                        <th>Email</th>
                                        <th>Annonce</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($resultlistecontacts as $contact): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($contact['nom'] ?? ''); ?></td>
                                        <td><?php echo htmlspecialchars($contact['email'] ?? ''); ?></td>
                                        <td><?php echo htmlspecialchars($contact['annonce_titre'] ?? 'N/A'); ?></td>
                                        <td><?php echo !empty($contact['date_contact']) ? date('d/m', strtotime($contact['date_contact'])) : ''; ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
<?php
    }

    /**
     * Dashboard pour les agents
     */
    private static function afficherDashboardAgent($CounterAnnonces, $CounterContacts, $CounterAnnoncesAjd, $resultlisteannonces, $resultlistecontacts)
    {
?>
        <!-- Statistiques agent -->
        <div class="row mb-4">
            <div class="col-xl-4 col-md-6 mb-4">
                <div class="card border-left-primary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Mes Annonces</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($CounterAnnonces) ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-home fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-4 col-md-6 mb-4">
                <div class="card border-left-success shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    Contacts Reçus</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($CounterContacts) ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-envelope fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-4 col-md-6 mb-4">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Annonces Aujourd'hui</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($CounterAnnoncesAjd) ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-calendar-day fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Actions rapides pour agent -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card shadow">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">
                            <i class="fas fa-plus-circle"></i> Actions Rapides
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <a href="index.php?page=vsts&typePage=vv" class="btn btn-primary btn-lg btn-block">
                                    <i class="fas fa-plus"></i> Ajouter une annonce
                                </a>
                            </div>
                            <div class="col-md-6 mb-3">
                                <a href="index.php?page=vsts&typePage=vv" class="btn btn-success btn-lg btn-block">
                                    <i class="fas fa-list"></i> Voir mes annonces
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mes annonces -->
        <?php if ($resultlisteannonces && count($resultlisteannonces) > 0): ?>
        <div class="row">
            <div class="col-12">
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">
                            <i class="fas fa-list-alt"></i> Mes Dernières Annonces
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Titre</th>
                                        <th>Prix</th>
                                        <th>Surface</th>
                                        <th>Ville</th>
                                        <th>Statut</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($resultlisteannonces as $annonce): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($annonce['titre']) ?></td>
                                        <td><?= number_format($annonce['prix']) ?> DA</td>
                                        <td><?= $annonce['surface'] ?> m²</td>
                                        <td><?= htmlspecialchars($annonce['ville']) ?></td>
                                        <td>
                                            <span class="badge bg-<?= $annonce['statut'] == 'active' ? 'success' : 'warning' ?>">
                                                <?= htmlspecialchars($annonce['statut']) ?>
                                            </span>
                                        </td>
                                        <td><?= date('d/m/Y', strtotime($annonce['date_creation'])) ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

<?php
    }
    /**
     * Dashboard pour les agents premium
     */
    private static function afficherDashboardAgentPremium($CounterAnnonces, $CounterContacts, $CounterAnnoncesAjd, $resultlisteannonces, $resultlistecontacts, $stats = null)
    {
?>
        <!-- Statistiques agent premium -->
        <div class="row mb-4">
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-primary shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Mes Annonces</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($CounterAnnonces) ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-home fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-success shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    Chiffre d'Affaires</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($stats['my_revenue'] ?? 0) ?> DA</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-info shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                    Contacts Reçus</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($CounterContacts) ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-envelope fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-warning shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Performance</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    <?= isset($stats['performance_vs_avg']) ? number_format($stats['performance_vs_avg'], 1) . 'x' : 'N/A' ?>
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Répartition de mes annonces -->
        <?php if ($stats && isset($stats['my_annonces_by_status'])): ?>
        <div class="row mb-4">
            <div class="col-lg-6 mb-4">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-primary">
                            <i class="fas fa-chart-pie"></i> Statut de Mes Annonces
                        </h6>
                    </div>
                    <div class="card-body">
                        <?php foreach ($stats['my_annonces_by_status'] as $status): ?>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="text-sm font-weight-bold">
                                <?= htmlspecialchars(ucfirst($status['statut'])) ?>
                            </span>
                            <span class="badge bg-<?= $status['statut'] == 'active' ? 'success' : ($status['statut'] == 'vendu' ? 'primary' : 'secondary') ?>">
                                <?= $status['count'] ?>
                            </span>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-6 mb-4">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-success">
                            <i class="fas fa-trophy"></i> Mon Niveau Premium
                        </h6>
                    </div>
                    <div class="card-body text-center">
                        <div class="mb-3">
                            <i class="fas fa-crown fa-3x text-warning"></i>
                        </div>
                        <h5 class="text-warning">Agent Premium</h5>
                        <p class="small text-muted">
                            Accès complet aux outils professionnels
                        </p>
                        <div class="row text-center">
                            <div class="col-6">
                                <strong>✅ Statistiques avancées</strong>
                            </div>
                            <div class="col-6">
                                <strong>✅ Outils marketing</strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Mes dernières annonces -->
        <?php if ($resultlisteannonces && count($resultlisteannonces) > 0): ?>
        <div class="row">
            <div class="col-12">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-primary">
                            <i class="fas fa-list-alt"></i> Mes Dernières Annonces
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Titre</th>
                                        <th>Prix</th>
                                        <th>Surface</th>
                                        <th>Ville</th>
                                        <th>Statut</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($resultlisteannonces as $annonce): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($annonce['titre']) ?></td>
                                        <td><?= number_format($annonce['prix']) ?> DA</td>
                                        <td><?= $annonce['surface'] ?> m²</td>
                                        <td><?= htmlspecialchars($annonce['ville']) ?></td>
                                        <td>
                                            <span class="badge bg-<?= $annonce['statut'] == 'active' ? 'success' : 'warning' ?>">
                                                <?= htmlspecialchars($annonce['statut']) ?>
                                            </span>
                                        </td>
                                        <td><?= date('d/m/Y', strtotime($annonce['date_creation'])) ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

<?php
    }
    /**
     * Dashboard pour les agents particuliers
     */
    private static function afficherDashboardAgentParticulier($CounterAnnonces, $CounterContacts, $CounterAnnoncesAjd, $resultlisteannonces, $resultlistecontacts, $stats = null)
    {
?>
        <!-- Statistiques agent particulier -->
        <div class="row mb-4">
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-primary shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Mes Biens</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($CounterAnnonces) ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-home fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-success shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    Prix Moyen</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($stats['avg_price'] ?? 0) ?> DA</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-tag fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-info shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                    Vues Totales</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($stats['total_views'] ?? 0) ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-eye fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-warning shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Durée Moy.</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $stats['avg_duration'] ?? 0 ?> jours</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-clock fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Conseils et suggestions -->
        <div class="row mb-4">
            <div class="col-lg-6 mb-4">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-info">
                            <i class="fas fa-lightbulb"></i> Conseils pour Optimiser
                        </h6>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled mb-0">
                            <li class="mb-2">
                                <i class="fas fa-check-circle text-success mr-2"></i>
                                <small>Ajoutez plus de photos de qualité</small>
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-check-circle text-success mr-2"></i>
                                <small>Rédigez des descriptions détaillées</small>
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-check-circle text-success mr-2"></i>
                                <small>Répondez rapidement aux contacts</small>
                            </li>
                            <li class="mb-0">
                                <i class="fas fa-arrow-up text-warning mr-2"></i>
                                <small><strong>Passez Premium</strong> pour plus de visibilité</small>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 mb-4">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-warning">
                            <i class="fas fa-chart-bar"></i> Mes Performances
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="d-flex justify-content-between">
                                <span class="small">Visibilité</span>
                                <span class="small"><?= min(100, ($stats['total_views'] ?? 0) / 10) ?>%</span>
                            </div>
                            <div class="progress progress-sm">
                                <div class="progress-bar bg-info" style="width: <?= min(100, ($stats['total_views'] ?? 0) / 10) ?>%"></div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="d-flex justify-content-between">
                                <span class="small">Intérêt généré</span>
                                <span class="small"><?= min(100, $CounterContacts * 25) ?>%</span>
                            </div>
                            <div class="progress progress-sm">
                                <div class="progress-bar bg-success" style="width: <?= min(100, $CounterContacts * 25) ?>%"></div>
                            </div>
                        </div>
                        <div class="text-center">
                            <small class="text-muted">Score global : <?= min(100, (($stats['total_views'] ?? 0) / 10 + $CounterContacts * 25) / 2) ?>%</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mes biens -->
        <?php if ($resultlisteannonces && count($resultlisteannonces) > 0): ?>
        <div class="row">
            <div class="col-12">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-primary">
                            <i class="fas fa-list-alt"></i> Mes Biens
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Titre</th>
                                        <th>Prix</th>
                                        <th>Surface</th>
                                        <th>Ville</th>
                                        <th>Statut</th>
                                        <th>Depuis</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($resultlisteannonces as $annonce): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($annonce['titre']) ?></td>
                                        <td><?= number_format($annonce['prix']) ?> DA</td>
                                        <td><?= $annonce['surface'] ?> m²</td>
                                        <td><?= htmlspecialchars($annonce['ville']) ?></td>
                                        <td>
                                            <span class="badge bg-<?= $annonce['statut'] == 'active' ? 'success' : 'warning' ?>">
                                                <?= htmlspecialchars($annonce['statut']) ?>
                                            </span>
                                        </td>
                                        <td><?= date('d/m/Y', strtotime($annonce['date_creation'])) ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

<?php
    }
    /**
     * Dashboard pour les visiteurs (version améliorée)
     */
    private static function afficherDashboardVisiteur($CounterAnnonces, $CounterContacts, $resultlisteannonces, $stats = null)
    {
?>
        <!-- Message de bienvenue pour visiteur -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="alert alert-info shadow dashboard-welcome-alert">
                    <h4 class="alert-heading">
                        <i class="fas fa-user-circle"></i> Bienvenue dans votre espace personnel !
                    </h4>
                    <p>En tant que visiteur, vous pouvez publier et gérer vos annonces immobilières.</p>
                    <hr>
                    <div class="row">
                        <div class="col-md-8">
                            <p class="mb-0">
                                <strong>💡 Conseil :</strong> Passez Agent Premium pour débloquer des fonctionnalités avancées :
                                statistiques détaillées, outils marketing, support prioritaire.
                            </p>
                        </div>
                        <div class="col-md-4 text-end">
                            <button class="btn btn-warning btn-sm">
                                <i class="fas fa-star"></i> Passer Premium
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistiques visiteur -->
        <div class="row mb-4">
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card border-left-primary shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Mes Annonces</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($CounterAnnonces) ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-home fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card border-left-success shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    Contacts Reçus</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($CounterContacts) ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-envelope fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card border-left-info shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                    Vues Totales</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= number_format($stats['total_views'] ?? 0) ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-eye fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card border-left-warning shadow h-100 dashboard-stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Moy/Annonce</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $stats['avg_views_per_annonce'] ?? 0 ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-chart-bar fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Actions et conseils pour visiteur -->
        <div class="row mb-4">
            <div class="col-lg-8 mb-4">
                <div class="card shadow dashboard-actions">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-primary">
                            <i class="fas fa-rocket"></i> Actions Rapides
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <a href="index.php?page=vsts&typePage=vv" class="btn btn-primary btn-block">
                                    <i class="fas fa-plus"></i> Publier une annonce
                                </a>
                            </div>
                            <div class="col-md-6 mb-3">
                                <a href="index.php?page=vsts&typePage=vv" class="btn btn-success btn-block">
                                    <i class="fas fa-list"></i> Voir mes annonces
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 mb-4">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-warning">
                            <i class="fas fa-chart-line"></i> Mon Activité
                        </h6>
                    </div>
                    <div class="card-body text-center">
                        <?php if ($CounterAnnonces > 0): ?>
                            <div class="mb-2">
                                <i class="fas fa-check-circle fa-2x text-success"></i>
                            </div>
                            <h6 class="text-success">Actif</h6>
                            <p class="small text-muted">
                                Vous avez <?= $CounterAnnonces ?> annonce<?= $CounterAnnonces > 1 ? 's' : '' ?> 
                                qui <?= $CounterAnnonces > 1 ? 'ont' : 'a' ?> généré <?= $stats['total_views'] ?? 0 ?> vue<?= ($stats['total_views'] ?? 0) > 1 ? 's' : '' ?>
                            </p>
                        <?php else: ?>
                            <div class="mb-2">
                                <i class="fas fa-plus-circle fa-2x text-primary"></i>
                            </div>
                            <h6 class="text-primary">Prêt à commencer</h6>
                            <p class="small text-muted">
                                Publiez votre première annonce pour commencer à recevoir des contacts
                            </p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mes annonces ou message d'encouragement -->
        <?php if ($resultlisteannonces && count($resultlisteannonces) > 0): ?>
        <div class="row">
            <div class="col-12">
                <div class="card shadow dashboard-table-card">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-primary">
                            <i class="fas fa-list-alt"></i> Mes Annonces
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Titre</th>
                                        <th>Prix</th>
                                        <th>Surface</th>
                                        <th>Ville</th>
                                        <th>Statut</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($resultlisteannonces as $annonce): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($annonce['titre']) ?></td>
                                        <td><?= number_format($annonce['prix']) ?> DA</td>
                                        <td><?= $annonce['surface'] ?> m²</td>
                                        <td><?= htmlspecialchars($annonce['ville']) ?></td>
                                        <td>
                                            <span class="badge bg-<?= $annonce['statut'] == 'active' ? 'success' : 'warning' ?>">
                                                <?= htmlspecialchars($annonce['statut']) ?>
                                            </span>
                                        </td>
                                        <td><?= date('d/m/Y', strtotime($annonce['date_creation'])) ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php else: ?>
        <div class="row">
            <div class="col-12">
                <div class="card shadow dashboard-table-card">
                    <div class="card-body text-center py-5">
                        <i class="fas fa-home fa-4x text-muted mb-3"></i>
                        <h5>Aucune annonce pour le moment</h5>
                        <p class="text-muted">Commencez par publier votre première annonce immobilière</p>
                        <a href="index.php?page=vsts&typePage=vv" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Publier ma première annonce
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
<?php
    }

    // Autres méthodes de la classe...
}
?>
