<?PHP
namespace Views;

use DateTime;

class AnnonceClientHtml
{
    static public function afficheAnnonceClient($result, $showOnlyUserAnnonces = false, $userLevel = 0)
    {
        include_once("FunctionHtml.php");
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");
        
        // Déterminer le titre de la page selon le niveau d'accès
        $pageTitle = "Annonces des clients connectés";
        if ($showOnlyUserAnnonces) {
            $pageTitle = "Mes annonces";
        } elseif ($userLevel >= 80) {
            $pageTitle = "Toutes les annonces (Administration)";
        } elseif ($userLevel >= 40) {
            $pageTitle = "Annonces immobilières";
        }
        ?>
        
        <main class="<?php echo $mainClass; ?> ms-sm-auto px-md-4 py-4" id="main-content" style="display:none;">
            <div class="card card-mh-90vh">
                <div class="card-header">
                    <b><?php echo $pageTitle; ?></b>
                    <?php if ($showOnlyUserAnnonces): ?>
                    <small class="text-muted"> - Vous voyez uniquement vos annonces</small>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <?php
                    if (isset($_GET["msg"])) {
                        $msg = $_GET["msg"];

                        // Define messages, their alert types, and icons
                        $alerts = [
                            "updated" => ["success", "fas fa-check-circle", "Annonce mise à jour avec succès."],
                            "deleted" => ["success", "fas fa-check-circle", "Annonce supprimée avec succès."],
                            "added" => ["success", "fas fa-check-circle", "Annonce ajoutée avec succès."],
                            "published" => ["success", "fas fa-check-circle", "Annonce publiée avec succès."],
                            "featured" => ["success", "fas fa-star", "Annonce mise en avant avec succès."],
                            "errorsupr" => ["warning", "fas fa-exclamation-triangle", "Erreur suppression, réessayez plus tard ou contactez " . $errorMsgService . "."],
                            "erroraddedit" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnu, réessayez plus tard ou contactez " . $errorMsgService . "."],
                            "errorajax" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnu, réessayez plus tard ou contactez " . $errorMsgService . "."]
                        ];

                        // Check if the message exists in the array and display the alert
                        if (array_key_exists($msg, $alerts)) {
                            list($alertType, $icon, $message) = $alerts[$msg];
                            echo '<div class="alert alert-' . $alertType . '" id="alertMessage" role="alert">
                                    <i class="' . $icon . ' me-2"></i> ' . $message . '
                                  </div>';
                        }
                    }

                    ?>
                    <table id="gridAnnonceClient" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Titre</th>
                                <th>Client</th>
                                <th>Contact</th>
                                <th>Type</th>
                                <th>Catégorie</th>
                                <th>Prix</th>
                                <th>Surface</th>
                                <th>Ville</th>
                                <th>Statut</th>
                                <th>Vues</th>
                                <th>Contacts</th>
                                <th>Date création</th>
                                <th>Mise en avant</th>
                                <th>Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            foreach ($result as $row) {
                                echo '<tr>
                                <td style="text-align: center;" width="80px"><b>' . $row["id"] . '</b></td>
                                <td><strong>' . htmlspecialchars($row["titre"]) . '</strong></td>
                                <td>' . htmlspecialchars($row["nom_complet"]) . '<br><span class="text-muted">' . htmlspecialchars($row["nom_role"]) . '</span></td>
                                <td>
                                    <small>📧 ' . htmlspecialchars($row["email"]) . '</small><br>
                                    <small>📱 ' . htmlspecialchars($row["telephone"] ?? 'N/A') . '</small>
                                </td>
                                <td><span class="badge bg-primary">' . htmlspecialchars($row["type_transaction"]) . '</span></td>
                                <td><span class="badge bg-secondary">' . htmlspecialchars($row["categorie_nom"]) . '</span></td>
                                <td style="text-align: right;"><strong>' . number_format($row["prix"], 0, ',', ' ') . ' €</strong></td>
                                <td style="text-align: center;">' . ($row["surface"] ? $row["surface"] . ' m²' : 'N/A') . '</td>
                                <td>' . htmlspecialchars($row["ville"]) . '</td>';

                                // Statut avec couleurs
                                $statutClass = [
                                    'brouillon' => 'secondary',
                                    'en_attente' => 'warning',
                                    'publiee' => 'success',
                                    'vendue' => 'info',
                                    'louee' => 'info',
                                    'expiree' => 'danger',
                                    'supprimee' => 'dark'
                                ];
                                $badgeClass = $statutClass[$row["statut"]] ?? 'secondary';
                                echo '<td><span class="badge bg-' . $badgeClass . '">' . ucfirst(str_replace('_', ' ', $row["statut"])) . '</span></td>';

                                echo '<td style="text-align: center;"><span class="badge bg-light text-dark">' . $row["vues"] . '</span></td>
                                <td style="text-align: center;"><span class="badge bg-light text-dark">' . $row["contacts"] . '</span></td>
                                <td style="text-align: center; white-space: nowrap;"><small>' . date('d/m/Y H:i', strtotime($row["date_creation"])) . '</small></td>';

                                // Mise en avant
                                $miseEnAvant = $row["mise_en_avant"] == 1;
                                echo '<td style="text-align: center;">';
                                if ($miseEnAvant) {
                                    echo '<i class="fas fa-star text-warning" title="Annonce mise en avant"></i>';
                                } else {
                                    echo '<i class="far fa-star text-muted" title="Annonce standard"></i>';
                                }
                                echo '</td>';

                                echo '<td style="text-align: center;">
                                    <a class="annonce-view-link" title="Voir annonce ID : ' . $row["id"] . '" data-id="' . $row["id"] . '" href="#"><span class="fas fa-eye m-1" style="color: blue;"></span></a>
                                    <a class="annonce-edit-link" title="Modifier annonce ID : ' . $row["id"] . '" data-id="' . $row["id"] . '" href="#"><span class="fas fa-edit m-1" style="color: green;"></span></a>
                                    <a class="annonce-delete-link" title="Supprimer annonce ID : ' . $row["id"] . '" data-id="' . $row["id"] . '" href="#"><span class="fas fa-trash m-1" style="color: red;"></span></a>';
                                
                                if (!$miseEnAvant) {
                                    echo '<a class="annonce-feature-link" title="Mettre en avant" data-id="' . $row["id"] . '" href="#"><span class="fas fa-star m-1" style="color: orange;"></span></a>';
                                }
                                
                                echo '</td>
                                </tr>';
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>ID</th>
                                <th>Titre</th>
                                <th>Client</th>
                                <th>Contact</th>
                                <th>Type</th>
                                <th>Catégorie</th>
                                <th>Prix</th>
                                <th>Surface</th>
                                <th>Ville</th>
                                <th>Statut</th>
                                <th>Vues</th>
                                <th>Contacts</th>
                                <th>Date création</th>
                                <th>Mise en avant</th>
                                <th>Options</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>


                <div class="modal fade" id="modalFormAddEditVisite" tabindex="-1" aria-labelledby="myModalLabel"
                    aria-hidden="true" data-bs-backdrop="static">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title text-dark" id="inscriptionModalLabel">Inscription visite fournisseur
                                </h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <form id="FormInscription" name="FormInscription" action="" method="post" action=""
                                    autocomplete="off">
                                    <div class="alert alert-warning" id="alertMessageModal" role="alert"></div>

                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="companyName" class="form-label">Nom de votre entreprise <span style="color: red; font-weight: bold;">*</span></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control capitalize" id="companyName"
                                                    name="companyName" autocomplete="off" required>
                                                <input type="hidden" id="companyId" name="companyId" value="" />
                                                <button type="button" class="btn btn-dark" id="addFournisseurButton"
                                                    title="Ajouter une nouvelle entreprise">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            </div>
                                            <div id="companyNameError" class="invalid-feedback d-none">Ce champ est requis.
                                            </div>
                                            <div id="resultContainer" class="result-list"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row" id="divchampChoixVisiteur">
                                        <div class="col-md-12 mb-3">
                                            <label for="champVisiteur" class="form-label">Choix représentant <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control capitalize" id="champVisiteur"
                                                    name="champVisiteur" autocomplete="off"
                                                    placeholder="Choisissez le représentant ici">
                                                <input type="hidden" id="visiteurId" name="visiteurId" value="" />
                                                <button type="button" class="btn btn-dark" id="addVisiteurButton"
                                                    title="Ajouter un nouveau représentant">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            </div>
                                            <div id="champVisiteurError" class="invalid-feedback d-none">Ce champ est requis.
                                            </div>
                                            <div id="resultContainer-visiteur" class="result-list"></div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="msgchoixvisiteur" class="form-label">Représentant choisi</label>
                                            <p class="msg-normal" id="msgchoixvisiteur">Aucun représentant choisi pour le
                                                moment,
                                                veuillez effectuer
                                                votre recherche sur choix représentant, si le représentant ne se trouve pas sur
                                                la liste
                                                veuillez l'ajouter.</p>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-2 mb-3">
                                            <label for="champCivilite" class="form-label">Civi.. <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <select class="form-control select" id="champCivilite" name="champCivilite"
                                                required></select>
                                            <div id="champCiviliteError" class="invalid-feedback d-none">Requis.</div>
                                        </div>

                                        <div class="col-md-5 mb-3">
                                            <label for="champnom" class="form-label">Nom <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="champnom" name="champnom"
                                                autocomplete="off" required>
                                            <input type="hidden" id="champnomId" name="champnomId" value="" />
                                            <div id="champnomError" class="invalid-feedback d-none">Ce champ est requis.</div>
                                            <div id="resultContainer-nom" class="result-list"></div>
                                        </div>

                                        <div class="col-md-5 mb-3">
                                            <label for="champprenom" class="form-label">Prénom <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="champprenom"
                                                name="champprenom" value="" autocomplete="off" required>
                                            <div id="champprenomError" class="invalid-feedback d-none">Ce champ est requis.
                                            </div>
                                            <div id="resultContainer-prenom" class="result-list"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="champsecteur" class="form-label">Secteur à visiter <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="champsecteur"
                                                name="champsecteur" value="" autocomplete="off" required />
                                            <div id="champsecteurError" class="invalid-feedback d-none">Ce champ est requis.
                                            </div>
                                            <input type="hidden" id="secteurId" name="secteurId" value="" />
                                            <div id="resultContainer-secteur" class="result-list"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="champcontactPerson" class="form-label">Personne à visiter <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="champcontactPerson"
                                                name="champcontactPerson" value="" autocomplete="off">
                                            <div id="champcontactPersonError" class="invalid-feedback d-none">Ce champ est
                                                requis.</div>
                                            <input type="hidden" id="contactId" name="contactId" value="" />
                                            <div id="resultContainer-contactPerson" class="result-list"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">

                                        <?php
                                        if ($useOnlyFirstDate) {
                                            $div1W = '';
                                            $div2W = '<div class="col-md-6 mb-3">';
                                            $div3W = '</div>';
                                            $div4W = '';
                                            $mt3 = '';
                                            $disabled = '';
                                            $div5W = '<div class="col-md-3 mb-3">';
                                            $textLabel1 = "Date <br>visite";
                                        } else {
                                            $div1W = '<div class="col-md-6 mb-3">';
                                            $div2W = '';
                                            $div3W = '';
                                            $div4W = '</div>';
                                            $mt3 = '';
                                            $disabled = '';
                                            $div5W = '';
                                            $textLabel1 = "Date début visite";
                                        }

                                        echo $div1W . '
                                        ' . $div2W . '
                                        <label for="champDateDebut" class="form-label ' . $mt3 . '">' . $textLabel1 . ' <span
                                                style="color: red; font-weight: bold;">*</span></label>
                                        <input type="date" class="form-control" id="champDateDebut" name="champDateDebut"
                                            required ' . $disabled . '>
                                        <input type="hidden" id="hchampdatedebut" name="hchampdatedebut" value="">
                                        <div id="champDateDebutError" class="invalid-feedback d-none">Ce champ est requis.</div>
                                        ' . $div3W . '
                                        ' . $div5W . '
                                        <label for="champHeureDebut" class="form-label ' . $mt3 . '">Heure début visite <span style="color: red; font-weight: bold;">*</span></label>
                                        <select class="form-control select" id="champHeureDebut" name="champHeureDebut" required ' . $disabled . '></select>
                                        <input type="hidden" id="hchampheuredebut" name="hchampheuredebut" value="">
                                        <div id="champHeureDebutError" class="invalid-feedback d-none">Ce champ est requis.</div>
                                        ' . $div3W;

                                        if ($useOnlyFirstDate) {

                                            echo $div5W . '
                                            <label for="champHeurefin" class="form-label ' . $mt3 . '">Heure fin visite <span style="color: red; font-weight: bold;">*</span></label>
                                            <select class="form-control select" id="champHeurefin" name="champHeurefin" required></select>
                                            <input type="hidden" id="hchampheurefin" name="hchampheurefin" value="">
                                            <div id="champHeurefinError" class="invalid-feedback d-none">Ce champ est requis.</div>
                                            ' . $div3W;
                                        }

                                        echo $div4W;

                                        if (!$useOnlyFirstDate) {
                                            echo '<div class="col-md-6">
                                            <label for="champDatefin" class="form-label">Date fin visite <span style="color: red; font-weight: bold;">*</span></label>
                                            <input type="date" class="form-control" id="champDatefin" name="champDatefin" required>
                                            <input type="hidden" id="hchampdatefin" name="hchampdatefin" value="">
                                            <div id="champDatefinError" class="invalid-feedback d-none">Ce champ est requis.
                                            </div>

                                            <label for="champHeurefin" class="form-label">Heure fin visite <span style="color: red; font-weight: bold;">*</span></label>
                                            <select class="form-control select" id="champHeurefin" name="champHeurefin" required></select>
                                            <input type="hidden" id="hchampheurefin" name="hchampheurefin" value="">
                                            <div id="champHeurefinError" class="invalid-feedback d-none">Ce champ est requis.</div>
                                        </div>';
                                        }
                                        ?>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="champobservation" class="form-label">Observation sur la visite</label>
                                            <textarea class="form-control" id="champobservation" name="champobservation"
                                                rows="4" autocomplete="off"></textarea>
                                        </div>
                                    </div>

                                    <input type="hidden" id="typeConfirm" name="typeConfirm" value="" />
                                    <input type="hidden" id="idVisitetodeleteorupd" name="idVisitetodeleteorupd" value="" />
                                </form>
                            </div>
                            <div class="modal-footer d-flex justify-content-between align-items-center">
                                <small class="text-muted"><span class="text-danger">*</span> Champs obligatoires</small>
                                <div>
                                    <button type="button" class="btn btn-success" id="btnSubmit">S'inscrire</button>
                                    <button type="button" class="btn btn-secondary" id="dismissVisiteModal">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true"
                    data-bs-backdrop="static">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="confirmModalLabel">Confirmer l'enregistrement</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body" id="confirmBody">
                                Vouslez-vous vraiment enregister cette visite ?
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-success" id="confirmSubmit">Oui, Enregistrer</button>
                                <button type="button" class="btn btn-secondary" id="dismissSubmit">Non</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="confirmModalVerifie" tabindex="-1" aria-labelledby="confirmModalVerifieLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="confirmModalVerifieLabel">Confirmer le changement</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fermer"></button>
                            </div>
                            <div class="modal-body">
                                Êtes-vous sûr de vouloir changer ce statut ?
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" id="cancelChange" data-bs-dismiss="modal">Annuler</button>
                                <button type="button" class="btn btn-primary" id="confirmChange">Confirmer</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="confirmDeletionModal" tabindex="-1" aria-labelledby="confirmDeletionModalLabel"
                    aria-hidden="true" data-bs-backdrop="static">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="confirmDeletionModalLabel">Confirmer la suppression</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="alert alert-warning m-3" id="alertMessageModalPrint" role="alert"></div>
                            <div class="modal-body" id="confirmDeletionBody">
                                Vouslez-vous vraiment supprimer cette visite ?
                            </div>
                            <div class="modal-footer">
                                <input type="hidden" name="typeConfirmDeletion" value="" />
                                <input type="hidden" name="idVisitetodeleteorprint" value="" />
                                <button type="button" class="btn btn-danger" id="confirmDeletionSubmit">Oui, Supprimer</button>
                                <button type="button" class="btn btn-secondary" id="dismissDeletionSubmit">Non</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

    <?PHP

        if ($useOnlyFirstDate) {
            echo '<script>const useOnlyFirstDate = true; const lastCol = 8;</script>';
        } else {
            echo '<script>const useOnlyFirstDate = false; const lastCol = 9;</script>';
        }
        // Loader JS : affiche le loader, puis le contenu après chargement complet
        ?>
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            var loader = document.getElementById('loadingContainer');
            var main = document.getElementById('main-content');
            if(loader && main) {
                setTimeout(function() {
                    loader.style.display = 'none';
                    main.style.display = 'block';
                }, 600); // 600ms pour l'effet, peut être réduit
            }
        });
        </script>
        <?php
    }
    static public function afficheVisiteurs($resultlistevisiteur, $sqlListvisiteur)
    {
        include_once("FunctionHtml.php");
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php"); ?>


        <main class="<?php echo $mainClass; ?> ms-sm-auto px-md-4 py-4" id="main-content" style="display: none;">
            <div class="card card-mh-90vh">
                <div class="card-header">
                    <b>Liste des représentants</b>
                </div>
                <div class="card-body">
                    <?php

                    if (isset($_GET["msg"])) {
                        $msg = $_GET["msg"];
                        $alerts = [
                            "updated" => ["success", "fas fa-check-circle", "Représentant mis à jour avec succès."],
                            "deleted" => ["success", "fas fa-check-circle", "Représentant supprimé avec succès."],
                            "added" => ["success", "fas fa-check-circle", "Représentant ajouté avec succès."],
                            "banni" => ["success", "fas fa-check-circle", "Représentant banni avec succès."],
                            "errorsupr" => ["warning", "fas fa-exclamation-triangle", "Erreur suppression représentant, réessayez plus tard ou contactez " . $errorMsgService . "."],
                            "errorbann" => ["warning", "fas fa-exclamation-triangle", "Erreur bannissement représentant, réessayez plus tard ou contactez " . $errorMsgService . "."],
                            "message" => ["warning", "fas fa-exclamation-triangle", "Erreur suppression, réessayez plus tard ou contactez " . $errorMsgService . "."],
                            "errorajax" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnue, réessayez plus tard ou contactez " . $errorMsgService . "."]
                        ];

                        if (array_key_exists($msg, $alerts)) {
                            list($alertType, $icon, $message) = $alerts[$msg];
                            echo '<div class="alert alert-' . $alertType . '" id="alertMessage" role="alert">
                <i class="' . $icon . '"></i> ' . $message . '
              </div>';
                        }
                    }
                    ?>

                    <table id="gridVisiteurs" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th style="width:60px;">ID Représentant</th>
                                <th>Nom Complet</th>
                                <th>Courriel</th>
                                <th>Téléphone</th>
                                <th>Nom de l'entreprise</th>
                                <th>Banni</th>
                                <th>Supprimé</th>
                                <th>Total visites</th>
                                <th>Observation</th>
                                <th>Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            foreach ($resultlistevisiteur as $rowvisiteur) {
                                echo '<tr>
                        <td style="text-align: center;"><b>' . $rowvisiteur["id_visiteur"] . '</b></td>
                        <td>' . $rowvisiteur["NomComplet"] . '</td>
                        <td>' . $rowvisiteur["email"] . '</td>
                        <td style="text-align: center;"><b>' . $rowvisiteur["tel"] . '</b></td>
                        <td>' . $rowvisiteur["nom_compagnie"] . '</td>';

                                echo '<td style="text-align: center;">';
                                if ($rowvisiteur["banni"] == 1) {
                                    echo '<span class="badge badge-danger">Oui</span>';
                                } else {
                                    echo '<span class="badge badge-success">Non</span>';
                                }
                                echo '</td>';

                                echo '<td style="text-align: center;">';
                                if ($rowvisiteur["deleted"] == 1) {
                                    echo '<span class="badge badge-danger">Oui</span>';
                                } else {
                                    echo '<span class="badge badge-success">Non</span>';
                                }
                                echo '</td>';

                                echo '
                        <td style="text-align: center;"><b>' . $rowvisiteur["CounVisite"] . '</b></td>
                        <td>' . $rowvisiteur["observation"] . '</td>
                        <td style="text-align: center;" width="100px">' . '
                        <a class="visiteur-edit-link" title="Modifier le représentant Numéro : ' . $rowvisiteur["id_visiteur"] . '" data-id="' . $rowvisiteur["id_visiteur"] . '"><span class="fas fa-edit m-1" style="color: green;"></span></a> 
                             <a class="visiteur-delete-link ' . ($rowvisiteur["deleted"] ? '1' : 'disabled') . '" title="Supprimer le représentant Numéro : ' . $rowvisiteur["id_visiteur"] . '" data-id="' . $rowvisiteur["id_visiteur"] . '" data-deleted="' . $rowvisiteur["deleted"] . '"><span class="fas fa-trash m-1" style="color: red;"></span></a>
                             <a class="visiteur-bannir-link" title="Bannir le représentant Numéro : ' . $rowvisiteur["id_visiteur"] . '" data-id="' . $rowvisiteur["id_visiteur"] . '" data-banni="' . $rowvisiteur["banni"] . '"><span class="fas fa-ban m-1" style="color: orange;"></span></a>
                        </tr>';
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>ID Représentant</th>
                                <th>Nom Complet</th>
                                <th>Courriel</th>
                                <th>Téléphone</th>
                                <th>Nom de l'entreprise</th>
                                <th>Banni</th>
                                <th>Supprimé</th>
                                <th>Total visites</th>
                                <th>Observation</th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="modal fade" id="modalFormAddEditVisiteur" tabindex="-1" aria-labelledby="modalLabel"
                    aria-hidden="true" data-bs-backdrop="static">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title text-dark" id="inscriptionModalLabelVisiteur">Inscription représentant
                                </h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <form id="FormInscriptionVisiteur" name="FormInscriptionVisiteur" method="post" action="">
                                    <div class="alert alert-warning" id="alertMessageModalVisiteur" role="alert"></div>

                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="companyNameVisiteur" class="form-label">Nom de votre entreprise <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control capitalize" id="companyNameVisiteur"
                                                    name="companyNameVisiteur" autocomplete="off" required>
                                                <input type="hidden" id="companyIdVisiteur" name="companyIdVisiteur" value="" />
                                                <button type="button" class="btn btn-dark" id="addFournisseurButton"
                                                    title="Ajouter une nouvelle entreprise">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            </div>

                                            <div id="companyNameVisiteurError" class="invalid-feedback">Ce champ est requis.
                                            </div>
                                            <div id="resultContainerVisiteur" class="result-list"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-3 mb-3">
                                            <label for="champCiviliteVisiteur" class="form-label">Civi.. <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <select class="form-control select" id="champCiviliteVisiteur" name="champCiviliteVisiteur"
                                                required></select>
                                            <div id="champCiviliteVisiteurError" class="invalid-feedback">Requis.</div>
                                        </div>
                                        <div class="col-md-5 mb-3">
                                            <label for="champnomVisiteur" class="form-label">Nom <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="champnomVisiteur"
                                                name="champnomVisiteur" autocomplete="off" required>
                                            <div id="champnomVisiteurError" class="invalid-feedback">Ce champ est requis.</div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label for="champprenomVisiteur" class="form-label">Prénom <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="champprenomVisiteur"
                                                name="champprenomVisiteur" autocomplete="off" required>
                                            <div id="champprenomVisiteurError" class="invalid-feedback">Ce champ est requis.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="champemailVisiteur" class="form-label">Courriel</label>
                                            <input type="email" class="form-control uncapitalize" id="champemailVisiteur"
                                                name="champemailVisiteur" autocomplete="off">
                                            <div id="champemailVisiteurError" class="invalid-feedback">Ce champ est requis.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-6 mb-3">
                                            <label for="champtelVisiteur" class="form-label">Téléphone</label>
                                            <input type="tel" class="form-control capitalize" id="champtelVisiteur"
                                                name="champtelVisiteur" autocomplete="off">
                                            <div id="champtelVisiteurError" class="invalid-feedback">Ce champ est requis.</div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="banVisitorCheckbox" class="form-label">
                                                Voulez-vous bannir ce représentant ?
                                            </label>
                                            <input type="checkbox" class="icheck" id="banVisitorCheckbox"
                                                name="banVisitorCheckbox">
                                            <div>
                                                Veuillez cocher cette case si vous souhaitez bannir ce représentant.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12 mb-3">
                                            <label for="champobservationVisiteur" class="form-label">Observation</label>
                                            <textarea class="form-control" id="champobservationVisiteur"
                                                name="champobservationVisiteur" rows="4" autocomplete="off"></textarea>
                                        </div>
                                    </div>
                                    <input type="hidden" id="typeConfirmVisiteur" name="typeConfirmVisiteur" value="" />
                                    <input type="hidden" id="idVisiteurtodeleteorupd" name="idVisiteurtodeleteorupd" value="" />
                                </form>

                            </div>
                            <div class="modal-footer d-flex justify-content-between align-items-center">
                                <small class="text-muted"><span class="text-danger">*</span> Champs obligatoires</small>
                                <div>
                                    <button type="button" class="btn btn-dark" id="btnSubmitVisiteur">S'inscrire</button>
                                    <button type="button" class="btn btn-secondary" id="dismissVisiteurModal">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="confirmModalVisiteur" tabindex="-1" aria-labelledby="confirmModalLabelVisiteur"
                    aria-hidden="true" data-bs-backdrop="static">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="confirmModalLabelVisiteur">Confirmer l'enregistrement</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body" id="confirmBodyVisiteur">
                                Vouslez-vous vraiment enregister ce représentant ?
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-success" id="confirmSubmitVisiteur">Oui,
                                    Enregistrer</button>
                                <button type="button" class="btn btn-secondary" id="dismissSubmitVisiteur">Non</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="confirmDeletionModalVisiteur" tabindex="-1"
                    aria-labelledby="confirmDeletionModalLabelVisiteur" aria-hidden="true" data-bs-backdrop="static">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="confirmDeletionModalLabelVisiteur">Confirmer la suppression</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body py-4" id="confirmDeletionBodyVisiteur">
                                Vouslez-vous vraiment supprimer ce représentant ?
                            </div>
                            <div class="modal-footer">
                                <input type="hidden" name="typeConfirmDeletionVisiteur" value="" />
                                <input type="hidden" name="idVisiteurtodelete" value="" />
                                <button type="button" class="btn btn-danger" id="confirmDeletionSubmitVisiteur">Oui,
                                    supprimer</button>
                                <button type="button" class="btn btn-secondary" id="dismissDeletionSubmitVisiteur">Non</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

    <?PHP
    }

    static public function afficherFournisseurs($visiteurStatus, $result, $offset, $rowCount, $N, $sortBy, $sortDir, $filtrePrenom, $lastTime, $lastUrl, $lastHost, $filtreCompagnie, $firstname, $lastname, $filtreNom, $get, $depClass, $sql)
    {
        include_once("FunctionHtml.php");
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php"); ?>


        <main class="<?php echo $mainClass; ?> ms-sm-auto px-md-4 py-4" id="main-content" style="display: none;">
            <div class="card card-mh-90vh">
                <div class="card-header">
                    <b>Liste des fournisseurs</b>
                </div>
                <div class="card-body">
                    <?php
                    if (isset($_GET["msg"])) {
                        $msg = $_GET["msg"];
                        $alerts = [
                            "updated" => ["success", "fas fa-check-circle", "Fournisseur mis à jour avec succès."],
                            "deleted" => ["success", "fas fa-check-circle", "Fournisseur supprimé avec succès."],
                            "added" => ["success", "fas fa-check-circle", "Fournisseur ajouté avec succès."],
                            "banni" => ["success", "fas fa-check-circle", "Fournisseur banni avec succès."],
                            "errorsupr" => ["warning", "fas fa-exclamation-triangle", "Erreur suppression fournisseur, réessayez plus tard ou contactez " . $errorMsgService . "."],
                            "errorbann" => ["warning", "fas fa-exclamation-triangle", "Erreur bannissement fournisseur, réessayez plus tard ou contactez " . $errorMsgService . "."],
                            "message" => ["warning", "fas fa-exclamation-triangle", "Erreur suppression, réessayez plus tard ou contactez " . $errorMsgService . "."],
                            "errorajax" => ["warning", "fas fa-exclamation-triangle", "Erreur inconnue, réessayez plus tard ou contactez " . $errorMsgService . "."]
                        ];

                        if (array_key_exists($msg, $alerts)) {
                            list($alertType, $icon, $message) = $alerts[$msg];
                            echo '<div class="alert alert-' . $alertType . '" id="alertMessage" role="alert">
                <i class="' . $icon . '"></i> ' . $message . '
              </div>';
                        }
                    }
                    ?>

                    <table id="gridFournisseurs" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th style="width:60px;">ID Fournisseur</th>
                                <th>Nom de l'entreprise</th>
                                <th>Activité</th>
                                <th>Courriel</th>
                                <th>Téléphone</th>
                                <th>Banni</th>
                                <th>Supprimé</th>
                                <th>Total visites</th>
                                <th>Total représentants</th>
                                <th>Observation</th>
                                <th>Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            foreach ($result as $row) {
                                echo '<tr>
                        <td style="text-align: center;"><b>' . $row["id_fournisseur"] . '</a>' . '</b></td>
                        <td>' . $row["nom_compagnie"] . '</td>
                        <td>' . $row["activite"] . '</td>';

                                if (!empty($row["email"]))
                                    echo '<td><span onclick="confirmEmail(\'' . $row["email"] . '\')" style="cursor: pointer;">' . $row["email"] . '</span></td>';
                                else
                                    echo '<td>' . $row["email"] . '</td>';

                                if (!empty($row["tel"]))
                                    echo '<td style="text-align: center;"><b><span onclick="callFunction(\'' . $row["tel"] . '\')" style="cursor: pointer;">' . $row["tel"] . '</span></td>';
                                else
                                    echo '<td style="text-align: center;"><b>' . $row["tel"] . '</b></td>';

                                echo '<td style="text-align: center;">';
                                if ($row["banni"] == 1) {
                                    echo '<span class="badge badge-danger">Oui</span>';
                                } else {
                                    echo '<span class="badge badge-success">Non</span>';
                                }
                                echo '</td>';

                                echo '<td style="text-align: center;">';
                                if ($row["deleted"] == 1) {
                                    echo '<span class="badge badge-danger">Oui</span>';
                                } else {
                                    echo '<span class="badge badge-success">Non</span>';
                                }
                                echo '</td>';

                                echo '
                        <td style="text-align: center;"><b>' . $row["CounVisite"] . '</b></td>
                        <td style="text-align: center;"><b>' . $row["CounVisiteur"] . '</b></td>
                        <td>' . $row["observation"] . '</td>
                        <td style="text-align: center;">' . '<a class="fournisseur-edit-link" title="Modifier le fournisseur" data-id="' . $row["id_fournisseur"] . '"><span class="fas fa-edit m-1" width="50" style="color: green;"></span></a> 
                             <a class="fournisseur-delete-link" title="Supprimer le fournisseur" data-id="' . $row["id_fournisseur"] . '"><span class="fas fa-trash m-1" style="color: red;"></span></a>
                             <a class="fournisseur-bannir-link" title="Bannir le fournisseur" data-id="' . $row["id_fournisseur"] . '"><span class="fas fa-ban m-1" style="color: orange;"></span></a>
                        </tr>';
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>ID Fournisseur</th>
                                <th>Nom de l'entreprise</th>
                                <th>Activité</th>
                                <th>Courriel</th>
                                <th>Téléphone</th>
                                <th>Banni</th>
                                <th>Supprimé</th>
                                <th>Total visites</th>
                                <th>Total représentants</th>
                                <th>Observation</th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="modal fade" id="modalFormAddEditFournisseur" tabindex="-1" aria-labelledby="modalLabel"
                    aria-hidden="true" data-bs-backdrop="static">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title text-dark" id="inscriptionModalLabelFournisseur">Inscription représentant
                                </h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <form id="FormInscriptionFournisseur" name="FormInscriptionFournisseur" action="" method="post">
                                    <div class="alert alert-warning" id="alertMessageModalFournisseur" role="alert"></div>

                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="companyNameFournisseur" class="form-label">Nom de votre entreprise <span
                                                    style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="companyNameFournisseur"
                                                name="companyNameFournisseur" autocomplete="off" required>
                                            <div id="companyNameFournisseurError" class="invalid-feedback">Ce champ est requis.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="champActiviteFournisseur" class="form-label">Activité de votre entreprise
                                                <span style="color: red; font-weight: bold;">*</span></label>
                                            <input type="text" class="form-control capitalize" id="champActiviteFournisseur"
                                                name="champActiviteFournisseur" autocomplete="off" required>
                                            <div id="champActiviteFournisseurError" class="invalid-feedback">Ce champ est
                                                requis.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="champemailFournisseur" class="form-label">Courriel</label>
                                            <input type="email" class="form-control uncapitalize" id="champemailFournisseur"
                                                name="champemailFournisseur" autocomplete="off">
                                            <div id="champemailFournisseurError" class="invalid-feedback">Ce champ est requis.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-6 mb-3">
                                            <label for="champtelFournisseur" class="form-label">Téléphone</label>
                                            <input type="tel" class="form-control capitalize" id="champtelFournisseur"
                                                name="champtelFournisseur" autocomplete="off">
                                            <div id="champtelFournisseurError" class="invalid-feedback">Ce champ est requis.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <div class="col-md-12 mb-3">
                                            <label for="banCompanyCheckbox" class="form-label">
                                                Voulez-vous bannir cette entreprise ?
                                            </label>
                                            <input type="checkbox" class="icheck" id="banCompanyCheckbox"
                                                name="banCompanyCheckbox">
                                            <div>
                                                Veuillez cocher cette case si vous souhaitez bannir l'entreprise.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12 mb-3">
                                            <label for="champobservationFournisseur" class="form-label">Observation</label>
                                            <textarea class="form-control" id="champobservationFournisseur"
                                                name="champobservationFournisseur" rows="4" autocomplete="off"></textarea>
                                        </div>
                                    </div>
                                    <input type="hidden" id="typeConfirmFournisseur" name="typeConfirmFournisseur" value="" />
                                    <input type="hidden" id="idFournisseurtodeleteorupd" name="idFournisseurtodeleteorupd" value="" />

                                </form>
                            </div>
                            <div class="modal-footer d-flex justify-content-between align-items-center">
                                <small class="text-muted"><span class="text-danger">*</span> Champs obligatoires</small>
                                <div>
                                    <button type="button" class="btn btn-success" id="btnSubmitFournisseur">Enregistrer</button>
                                    <button type="button" class="btn btn-secondary" id="dismissFournisseurModal">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Confirmation Modal -->
                <div class="modal fade" id="confirmModalFournisseur" tabindex="-1"
                    aria-labelledby="confirmModalLabelFournisseur" aria-hidden="true" data-bs-backdrop="static">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="confirmModalLabelFournisseur">Confirmer l'enregistrement</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body" id="confirmBodyFournisseur">
                                Vouslez-vous vraiment enregister ce fournisseur ?
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-success" id="confirmSubmitFournisseur">Oui,
                                    Enregistrer</button>
                                <button type="button" class="btn btn-secondary" id="dismissSubmitFournisseur">Non</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Confirmation Modal -->
                <div class="modal fade" id="confirmDeletionModalFournisseur" tabindex="-1"
                    aria-labelledby="confirmDeletionModalLabelFournisseur" aria-hidden="true" data-bs-backdrop="static">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="confirmDeletionModalLabelFournisseur">Confirmer la suppression</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body" id="confirmDeletionBodyFournisseur">
                                Vouslez-vous vraiment supprimer cette visite ?
                            </div>
                            <div class="modal-footer">
                                <input type="hidden" name="typeConfirmDeletionFournisseur" value="" />
                                <input type="hidden" name="idFournisseurtodelete" value="" />
                                <button type="button" class="btn btn-danger" id="confirmDeletionSubmitFournisseur">Oui,
                                    Supprimer</button>
                                <button type="button" class="btn btn-secondary"
                                    id="dismissDeletionSubmitFournisseur">Non</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

<?PHP
    }
}
?>
