<?php

namespace Views;

// Classe modifiée pour gérer les chemins depuis admin/
class AdminVariousViewsHtml {
    
    public function generateHeader($useChart, $useDataTables, $title, $type)
    {
        // Déterminer le préfixe de chemin - on est dans admin/, donc on remonte d'un niveau
        $pathPrefix = '../';
    ?>
        <!DOCTYPE html>
        <html lang="fr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
            <meta name="author" content="Ahmed ZERZIH">
            <title><?= $title ?></title>
            <link rel="icon" href="<?= $pathPrefix ?>assets/images/favicon.ico" type="image/x-icon">
            <link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/vendor/bootstrap-5.2.3/css/bootstrap.min.css" />
            <!-- FontAwesome from CDN (more reliable than local incomplete installation) -->
            <link rel="stylesheet" href="assets/vendor/fontawesome-free-5.2.0-web/css/all.min.css" crossorigin="anonymous" />
            <link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/vendor/bootstrap-icons-1.11.3/font/bootstrap-icons.min.css">

            <?PHP
            if ($useDataTables) {
            ?>
                <link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/vendor/DataTables/datatables.min.css" />
                <link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/vendor/DataTables/jquery.dataTables.min.css" />
                <link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/vendor/DataTables/buttons.dataTables.css" />
                <link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/vendor/DataTables/fixedColumns.dataTables.min.css">
            <?PHP
            }
            ?>

            <?PHP
            if ($type == 'visiteur') {
            ?>
                <link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/css/visiteur.css" />
            <?PHP
            } else {
            ?>
                <link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/css/utils.css" />
            <?PHP
            }
            ?>
            <link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/vendor/jquery-ui-1.14.1/jquery-ui.min.css">
            <?PHP
            if ($useChart) {
            ?>
                <link rel="stylesheet" type="text/css" href="<?= $pathPrefix ?>assets/vendor/Highcharts-6.1.1/css/highcharts.css">
            <?PHP
            }
            ?>
        </head>
        <body>
    <?PHP
    }

    public function generateFooter($useChart, $useDataTables, $type)
    {
        // On est dans admin/, donc on remonte d'un niveau
        $pathPrefix = '../';
    ?>
        <!-- Scripts -->
        <script src="<?= $pathPrefix ?>assets/vendor/jQuery-3.7.1/jquery-3.7.1.min.js"></script>
        <script src="<?= $pathPrefix ?>assets/vendor/bootstrap-5.2.3/js/bootstrap.bundle.min.js"></script>
        <script>
            $(document).ready(function() {
                console.log("jQuery loaded successfully");
            });
        </script>

        <?PHP
        if ($useDataTables) {
        ?>
            <script src="<?= $pathPrefix ?>assets/vendor/DataTables/datatables.min.js"></script>
            <script src="<?= $pathPrefix ?>assets/vendor/DataTables/jquery.dataTables.min.js"></script>
            <script src="<?= $pathPrefix ?>assets/vendor/DataTables/dataTables.buttons.min.js"></script>
            <script src="<?= $pathPrefix ?>assets/vendor/DataTables/buttons.html5.min.js"></script>
            <script src="<?= $pathPrefix ?>assets/vendor/DataTables/buttons.print.min.js"></script>
            <script src="<?= $pathPrefix ?>assets/vendor/DataTables/dataTables.fixedColumns.min.js"></script>
        <?PHP
        }
        ?>

        <script src="<?= $pathPrefix ?>assets/vendor/jquery-ui-1.14.1/jquery-ui.min.js"></script>

        <?PHP
        if ($useChart) {
        ?>
            <script src="<?= $pathPrefix ?>assets/vendor/Highcharts-6.1.1/highcharts.js"></script>
            <script src="<?= $pathPrefix ?>assets/vendor/Highcharts-6.1.1/modules/exporting.js"></script>
        <?PHP
        }
        ?>

        <?php
        // Ajout du JS spécifique pour la page Annonces (vsts)
        if (isset($_GET['page']) && $_GET['page'] === 'vsts') {
        ?>
            <script src="<?= $pathPrefix ?>assets/js/AnnonceClient.js"></script>
        <?php
        }
        // Ajout du JS spécifique pour la page Utilisateurs (user)
        if (isset($_GET['page']) && $_GET['page'] === 'user') {
        ?>
            <script src="<?= $pathPrefix ?>assets/js/Users.js"></script>
        <?php
        }
        ?>
        </body>
        </html>
    <?PHP
    }

    // Méthodes d'erreur simplifiées
    public function showInstallError($type) {
        echo "<div class='container mt-5'>";
        echo "<div class='alert alert-danger'>";
        echo "<h3>Erreur d'installation</h3>";
        echo "<p>Type d'erreur: " . htmlspecialchars($type) . "</p>";
        echo "</div>";
        echo "</div>";
    }

    public function showMysqlError() {
        echo "<div class='container mt-5'>";
        echo "<div class='alert alert-danger'>";
        echo "<h3>Erreur de base de données</h3>";
        echo "<p>Impossible de se connecter à la base de données.</p>";
        echo "</div>";
        echo "</div>";
    }

    public function showMaintenance($host) {
        echo "<div class='container mt-5'>";
        echo "<div class='alert alert-warning'>";
        echo "<h3>Maintenance en cours</h3>";
        echo "<p>Le site est actuellement en maintenance. Host: " . htmlspecialchars($host) . "</p>";
        echo "</div>";
        echo "</div>";
    }
}
?>
