<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

echo "<h2>🔄 Test de la Séparation Admin/Visiteur</h2>";

echo "<h3>🏗️ Structure créée :</h3>";
echo "<ul>";
echo "<li><strong>Page d'accueil publique :</strong> <a href='index.php' target='_blank'>index.php</a></li>";
echo "<li><strong>Interface visiteur :</strong> <a href='visiteur/index.php' target='_blank'>visiteur/index.php</a></li>";
echo "<li><strong>Interface administrateur :</strong> <a href='admin/index.php' target='_blank'>admin/index.php</a></li>";
echo "<li><strong>Connexion automatique :</strong> <a href='connexion_auto.php' target='_blank'>connexion_auto.php</a></li>";
echo "</ul>";

echo "<h3>🎯 Logique de redirection :</h3>";
echo "<ul>";
echo "<li><strong>Niveau 10-50 (Visiteurs) :</strong> Redirigés vers <code>visiteur/index.php</code></li>";
echo "<li><strong>Niveau 60-100 (Admins/Agents) :</strong> Redirigés vers <code>admin/index.php</code></li>";
echo "</ul>";

echo "<h3>👥 Comptes de test :</h3>";
echo "<table border='1' style='border-collapse: collapse; padding: 5px;'>";
echo "<tr><th>Username</th><th>Password</th><th>Niveau</th><th>Interface</th></tr>";
echo "<tr><td>tarssinas</td><td>123456789</td><td>100</td><td>Admin</td></tr>";
echo "<tr><td>user7</td><td>123456789</td><td>10</td><td>Visiteur</td></tr>";
echo "</table>";

echo "<h3>🧪 Tests à effectuer :</h3>";
echo "<ol>";
echo "<li>Tester la connexion automatique avec tarssinas → doit aller vers admin/</li>";
echo "<li>Tester la connexion automatique avec user7 → doit aller vers visiteur/</li>";
echo "<li>Tester l'accès direct à admin/ avec user7 → doit être redirigé vers visiteur/</li>";
echo "<li>Tester l'accès direct à visiteur/ avec tarssinas → doit être redirigé vers admin/</li>";
echo "</ol>";

echo "<h3>📊 Session actuelle :</h3>";
if (isset($_SESSION)) {
    echo "<pre>";
    print_r($_SESSION);
    echo "</pre>";
} else {
    echo "<p>Aucune session active</p>";
}

echo "<h3>🔗 Liens de test rapide :</h3>";
echo "<p><a href='index.php' class='btn'>🏠 Page d'accueil</a> | ";
echo "<a href='connexion_auto.php' class='btn'>🔑 Connexion auto</a> | ";
echo "<a href='visiteur/index.php' class='btn'>👤 Visiteur</a> | ";
echo "<a href='admin/index.php' class='btn'>🛡️ Admin</a></p>";
?>

<style>
.btn {
    display: inline-block;
    padding: 8px 16px;
    margin: 4px;
    background: #007bff;
    color: white;
    text-decoration: none;
    border-radius: 4px;
}
.btn:hover {
    background: #0056b3;
    color: white;
}
</style>