<?php
/**
 * Script de test de connexion à la base de données
 * À exécuter sur le serveur pour diagnostiquer les problèmes de connexion
 */

echo "<!DOCTYPE html><html><head><title>Test de connexion DB</title>";
echo "<style>body{font-family:Arial;padding:20px;} .success{color:green;} .error{color:red;} .info{color:blue;} pre{background:#f5f5f5;padding:10px;border-radius:5px;}</style>";
echo "</head><body>";

echo "<h1>🔍 Test de Connexion à la Base de Données</h1>";

// 1. Informations serveur
echo "<h2>📊 Informations Serveur</h2>";
echo "<ul>";
echo "<li><strong>HTTP_HOST:</strong> " . (isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : 'Non défini') . "</li>";
echo "<li><strong>DOCUMENT_ROOT:</strong> " . (isset($_SERVER['DOCUMENT_ROOT']) ? $_SERVER['DOCUMENT_ROOT'] : 'Non défini') . "</li>";
echo "<li><strong>Script Directory:</strong> " . __DIR__ . "</li>";
echo "</ul>";

// 2. Vérifier si config.php existe
echo "<h2>📁 Recherche de config.php</h2>";
$configPaths = [
    __DIR__ . '/config.php',
    __DIR__ . '/../config.php',
    __DIR__ . '/../../config.php',
];

$configFound = false;
foreach ($configPaths as $path) {
    $exists = file_exists($path);
    echo "<li>" . ($exists ? "✅" : "❌") . " $path</li>";
    if ($exists && !$configFound) {
        require_once $path;
        $configFound = true;
        echo "<p class='success'>✓ Config chargé depuis: $path</p>";
    }
}

if (!$configFound) {
    echo "<p class='error'>❌ Aucun fichier config.php trouvé!</p>";
    echo "</body></html>";
    exit;
}

// 3. Afficher les constantes de configuration
echo "<h2>⚙️ Configuration Détectée</h2>";
echo "<ul>";
echo "<li><strong>DB_SYSTEM:</strong> " . (defined('DB_SYSTEM') ? DB_SYSTEM : 'Non défini') . "</li>";
echo "<li><strong>DB_HOST:</strong> " . (defined('DB_HOST') ? DB_HOST : 'Non défini') . "</li>";
echo "<li><strong>DB_NAME:</strong> " . (defined('DB_NAME') ? DB_NAME : 'Non défini') . "</li>";
echo "<li><strong>DB_USER:</strong> " . (defined('DB_USER') ? DB_USER : 'Non défini') . "</li>";
echo "<li><strong>DB_PASS:</strong> " . (defined('DB_PASS') ? str_repeat('*', strlen(DB_PASS)) : 'Non défini') . "</li>";
echo "</ul>";

// 4. Test de connexion MySQLi
echo "<h2>🔌 Test de Connexion MySQLi</h2>";

if (!defined('DB_HOST') || !defined('DB_NAME') || !defined('DB_USER')) {
    echo "<p class='error'>❌ Constantes de base de données non définies</p>";
} else {
    $mysqli = @mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if (!$mysqli) {
        echo "<p class='error'>❌ Échec de connexion MySQLi</p>";
        echo "<p><strong>Erreur:</strong> " . mysqli_connect_error() . "</p>";
        echo "<p><strong>Code d'erreur:</strong> " . mysqli_connect_errno() . "</p>";
    } else {
        echo "<p class='success'>✅ Connexion MySQLi réussie!</p>";
        echo "<p><strong>Version MySQL:</strong> " . mysqli_get_server_info($mysqli) . "</p>";
        echo "<p><strong>Charset:</strong> " . mysqli_character_set_name($mysqli) . "</p>";
        
        // Test d'une requête simple
        $result = mysqli_query($mysqli, "SELECT COUNT(*) as total FROM annonces");
        if ($result) {
            $row = mysqli_fetch_assoc($result);
            echo "<p class='success'>✅ Requête de test réussie!</p>";
            echo "<p><strong>Nombre d'annonces:</strong> " . $row['total'] . "</p>";
        } else {
            echo "<p class='error'>❌ Échec de la requête de test</p>";
            echo "<p><strong>Erreur:</strong> " . mysqli_error($mysqli) . "</p>";
        }
        
        mysqli_close($mysqli);
    }
}

// 5. Test avec la classe mysqlDB
echo "<h2>🔧 Test avec la classe mysqlDB</h2>";

// Chercher dbConnect.php
$dbConnectPaths = [
    __DIR__ . '/Parametre/taghilt/dbConnect.php',
    __DIR__ . '/../Parametre/taghilt/dbConnect.php',
];

$dbConnectFound = false;
foreach ($dbConnectPaths as $path) {
    if (file_exists($path)) {
        require_once $path;
        $dbConnectFound = true;
        echo "<p class='success'>✓ dbConnect.php trouvé: $path</p>";
        break;
    }
}

if ($dbConnectFound) {
    $conn = dbConnect(true);
    
    if ($conn === false) {
        echo "<p class='error'>❌ La fonction dbConnect() a retourné false</p>";
        echo "<p>Cela signifie que soit config.php n'a pas été trouvé, soit la connexion a échoué.</p>";
    } else {
        echo "<p class='success'>✅ Connexion dbConnect() réussie!</p>";
        echo "<p><strong>Type d'objet:</strong> " . get_class($conn) . "</p>";
        echo "<p><strong>Connecté:</strong> " . ($conn->connected ? 'Oui' : 'Non') . "</p>";
        
        if ($conn->connected) {
            // Test d'une requête
            $rows = $conn->exec("SELECT COUNT(*) as total FROM annonces");
            if ($rows > 0) {
                $data = $conn->getData();
                echo "<p class='success'>✅ Requête exec() réussie!</p>";
                echo "<p><strong>Nombre d'annonces:</strong> " . $data[0]['total'] . "</p>";
            } else {
                echo "<p class='error'>❌ Échec de la requête exec()</p>";
            }
        }
    }
} else {
    echo "<p class='error'>❌ dbConnect.php non trouvé</p>";
}

// 6. Extensions PHP
echo "<h2>🔌 Extensions PHP</h2>";
echo "<ul>";
echo "<li><strong>mysqli:</strong> " . (extension_loaded('mysqli') ? '✅ Activé' : '❌ Désactivé') . "</li>";
echo "<li><strong>pdo_mysql:</strong> " . (extension_loaded('pdo_mysql') ? '✅ Activé' : '❌ Désactivé') . "</li>";
echo "</ul>";

echo "<hr>";
echo "<p class='info'>💡 Si la connexion échoue, vérifiez les informations dans config.php</p>";
echo "</body></html>";
?>
