<?php
// Test rapide pour vérifier les annonces dans la base de données
include_once 'Parametre/taghilt/taghilt.php';
include_once 'Parametre/taghilt/LoadDirClass.php';
include_once 'Parametre/taghilt/dbConnect.php';
include_once 'api_public.php';

try {
    $conn = dbConnect(false);
    
    echo "<h2>Test des données</h2>";
    
    // Test des types de propriétés
    echo "<h3>Types de propriétés :</h3>";
    $types = getTypesProprietes($conn);
    echo "<pre>";
    print_r($types);
    echo "</pre>";
    
    // Test des annonces récentes
    echo "<h3>Annonces récentes :</h3>";
    $annonces = getAnnoncesRecentes($conn, 3);
    echo "<pre>";
    print_r($annonces);
    echo "</pre>";
    
    // Test des villes
    echo "<h3>Villes avec annonces :</h3>";
    $villes = getVillesAvecAnnonces($conn);
    echo "<pre>";
    print_r($villes);
    echo "</pre>";
    
} catch (Exception $e) {
    echo "Erreur : " . $e->getMessage();
}
?>