<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Test de Connexion Simple</h1>";

// Test 1: Vérifier que config.php existe et peut être chargé
echo "<h2>1. Chargement de config.php</h2>";
if (file_exists('config.php')) {
    echo "✅ config.php trouvé<br>";
    require_once 'config.php';
    echo "✅ config.php chargé<br>";
    echo "DB_NAME = " . (defined('DB_NAME') ? DB_NAME : 'NON DÉFINI') . "<br>";
    echo "DB_HOST = " . (defined('DB_HOST') ? DB_HOST : 'NON DÉFINI') . "<br>";
    echo "DB_USER = " . (defined('DB_USER') ? DB_USER : 'NON DÉFINI') . "<br>";
} else {
    echo "❌ config.php NON trouvé<br>";
}

// Test 2: Test de connexion MySQLi direct
echo "<h2>2. Test MySQLi Direct</h2>";
$mysqli = @mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($mysqli) {
    echo "✅ Connexion MySQLi réussie<br>";
    echo "Version MySQL: " . mysqli_get_server_info($mysqli) . "<br>";
    
    // Test d'une requête
    $result = mysqli_query($mysqli, "SELECT COUNT(*) as total FROM annonces");
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        echo "✅ Requête réussie - Nombre d'annonces: " . $row['total'] . "<br>";
    } else {
        echo "❌ Erreur de requête: " . mysqli_error($mysqli) . "<br>";
    }
    
    mysqli_close($mysqli);
} else {
    echo "❌ Échec de connexion MySQLi<br>";
    echo "Erreur: " . mysqli_connect_error() . "<br>";
}

// Test 3: Test avec dbConnect
echo "<h2>3. Test avec dbConnect()</h2>";
include_once 'Parametre/taghilt/taghilt.php';
include_once 'Parametre/taghilt/LoadDirClass.php';
include_once 'Parametre/taghilt/dbConnect.php';

$conn = dbConnect(true);
if ($conn) {
    echo "✅ dbConnect() a réussi<br>";
    echo "Type d'objet: " . get_class($conn) . "<br>";
    echo "Connecté: " . ($conn->connected ? 'OUI' : 'NON') . "<br>";
    
    // Test d'une requête
    try {
        $rows = $conn->exec("SELECT COUNT(*) as total FROM annonces");
        if ($rows > 0) {
            $data = $conn->getData();
            echo "✅ Requête exec() réussie - Nombre d'annonces: " . $data[0]['total'] . "<br>";
        } else {
            echo "⚠️ Aucun résultat de la requête<br>";
        }
    } catch (Exception $e) {
        echo "❌ Erreur lors de l'exécution de la requête: " . $e->getMessage() . "<br>";
    }
} else {
    echo "❌ dbConnect() a retourné FALSE<br>";
}

echo "<h2>Résumé</h2>";
echo "<p>Si tous les tests sont ✅, la connexion fonctionne correctement.</p>";
?>
