-- Script pour mettre à jour les annonces existantes avec des villes algériennes
-- À exécuter après avoir importé taghtil.sql et localites_algerie.sql

-- Mettre à jour les annonces avec des villes algériennes
UPDATE annonces SET 
    ville = 'Alger', 
    departement = 'Alger', 
    region = 'Alger',
    pays = 'Algérie',
    latitude = 36.737232,
    longitude = 3.086472
WHERE id IN (1, 7, 13, 26, 28, 29, 34);

UPDATE annonces SET 
    ville = 'Oran', 
    departement = 'Oran', 
    region = 'Oran',
    pays = 'Algérie',
    latitude = 35.696111,
    longitude = -0.641667
WHERE id IN (2, 8, 18);

UPDATE annonces SET 
    ville = 'Constantine', 
    departement = 'Constantine', 
    region = 'Constantine',
    pays = 'Algérie',
    latitude = 36.365,
    longitude = 6.614722
WHERE id IN (3, 9, 14, 30);

UPDATE annonces SET 
    ville = 'Annaba', 
    departement = 'Annaba', 
    region = 'Annaba',
    pays = 'Algérie',
    latitude = 36.9,
    longitude = 7.766667
WHERE id IN (4, 10, 15, 31);

UPDATE annonces SET 
    ville = 'Blida', 
    departement = 'Blida', 
    region = 'Blida',
    pays = 'Algérie',
    latitude = 36.470278,
    longitude = 2.828056
WHERE id IN (5, 11, 16, 32);

UPDATE annonces SET 
    ville = 'Sétif', 
    departement = 'Sétif', 
    region = 'Sétif',
    pays = 'Algérie',
    latitude = 36.191111,
    longitude = 5.410278
WHERE id IN (6, 12, 17, 33);

UPDATE annonces SET 
    ville = 'Batna', 
    departement = 'Batna', 
    region = 'Batna',
    pays = 'Algérie',
    latitude = 35.555833,
    longitude = 6.174167
WHERE id IN (19, 35);

UPDATE annonces SET 
    ville = 'Béjaïa', 
    departement = 'Béjaïa', 
    region = 'Béjaïa',
    pays = 'Algérie',
    latitude = 36.752222,
    longitude = 5.055556
WHERE id IN (20, 36, 38);

UPDATE annonces SET 
    ville = 'Tlemcen', 
    departement = 'Tlemcen', 
    region = 'Tlemcen',
    pays = 'Algérie',
    latitude = 34.878056,
    longitude = -1.315
WHERE id IN (21, 37, 39);

UPDATE annonces SET 
    ville = 'Tizi Ouzou', 
    departement = 'Tizi Ouzou', 
    region = 'Tizi Ouzou',
    pays = 'Algérie',
    latitude = 36.716667,
    longitude = 4.05
WHERE id IN (22, 40);

UPDATE annonces SET 
    ville = 'Béchar', 
    departement = 'Béchar', 
    region = 'Béchar',
    pays = 'Algérie',
    latitude = 31.616667,
    longitude = -2.216667
WHERE id IN (23, 24);

UPDATE annonces SET 
    ville = 'Mostaganem', 
    departement = 'Mostaganem', 
    region = 'Mostaganem',
    pays = 'Algérie',
    latitude = 35.933333,
    longitude = 0.088889
WHERE id IN (25, 41);

UPDATE annonces SET 
    ville = 'Tipaza', 
    departement = 'Tipaza', 
    region = 'Tipaza',
    pays = 'Algérie',
    latitude = 36.589722,
    longitude = 2.445556
WHERE id IN (27, 42);

-- Mettre à jour les adresses pour correspondre aux villes algériennes
UPDATE annonces SET adresse = 'Rue Didouche Mourad' WHERE id = 1;
UPDATE annonces SET adresse = 'Cité Dergana' WHERE id = 2;
UPDATE annonces SET adresse = 'Place de la Brèche' WHERE id = 3;
UPDATE annonces SET adresse = 'Avenue de l''ALN' WHERE id = 4;
UPDATE annonces SET adresse = 'Boulevard Larbi Tebessi' WHERE id = 5;
UPDATE annonces SET adresse = 'Rue du 1er Novembre' WHERE id = 6;
UPDATE annonces SET adresse = 'Rue Hassiba Ben Bouali' WHERE id = 7;
UPDATE annonces SET adresse = 'Cité des Amandiers' WHERE id = 8;
UPDATE annonces SET adresse = 'Rue Larbi Ben M''hidi' WHERE id = 9;
UPDATE annonces SET adresse = 'Avenue Souidani Boudjemaa' WHERE id = 10;
UPDATE annonces SET adresse = 'Cité Bouchaoui' WHERE id = 11;
UPDATE annonces SET adresse = 'Rue Khemisti' WHERE id = 12;
UPDATE annonces SET adresse = 'Rue Didouche Mourad' WHERE id = 13;
UPDATE annonces SET adresse = 'Cité Bel Air' WHERE id = 14;
UPDATE annonces SET adresse = 'Boulevard Zighout Youcef' WHERE id = 15;
UPDATE annonces SET adresse = 'Avenue de la Liberté' WHERE id = 16;
UPDATE annonces SET adresse = 'Place Audin' WHERE id = 17;
UPDATE annonces SET adresse = 'Cité des Palmiers' WHERE id = 18;
UPDATE annonces SET adresse = 'Rue Emir Abdelkader' WHERE id = 19;
UPDATE annonces SET adresse = 'Boulevard de la Liberté' WHERE id = 20;
UPDATE annonces SET adresse = 'Cité Nouvelle Ville' WHERE id = 21;
UPDATE annonces SET adresse = 'Bord de mer' WHERE id = 22;
UPDATE annonces SET adresse = 'Corniche' WHERE id = 23;
UPDATE annonces SET adresse = 'Lotissement El Amel' WHERE id = 24;
UPDATE annonces SET adresse = 'Zone d''activité' WHERE id = 25;
UPDATE annonces SET adresse = 'Rue Larbi Ben M''hidi' WHERE id = 26;
UPDATE annonces SET adresse = 'Zone industrielle' WHERE id = 27;
UPDATE annonces SET adresse = 'Centre-ville' WHERE id = 28;
UPDATE annonces SET adresse = 'Cité universitaire' WHERE id = 29;
UPDATE annonces SET adresse = 'Nouvelle ville' WHERE id = 30;
UPDATE annonces SET adresse = 'Cité des Pins' WHERE id = 31;
UPDATE annonces SET adresse = 'Quartier résidentiel' WHERE id = 32;
UPDATE annonces SET adresse = 'Villa avec piscine' WHERE id = 33;
UPDATE annonces SET adresse = 'Rue Abane Ramdane' WHERE id = 34;
UPDATE annonces SET adresse = 'Loft moderne' WHERE id = 35;
UPDATE annonces SET adresse = 'Résidence étudiante' WHERE id = 36;
UPDATE annonces SET adresse = 'Nouveau quartier' WHERE id = 37;
UPDATE annonces SET adresse = 'Maison écologique' WHERE id = 38;
UPDATE annonces SET adresse = 'Quartier résidentiel' WHERE id = 39;
UPDATE annonces SET adresse = 'Écoquartier' WHERE id = 40;
UPDATE annonces SET adresse = 'Résidence touristique' WHERE id = 41;
UPDATE annonces SET adresse = 'Bord de mer' WHERE id = 42;

-- Ajuster les prix en dinars algériens (conversion approximative : 1 EUR = 145 DA)
-- Ventes
UPDATE annonces SET prix = prix * 145 WHERE type_transaction_id = 1 AND id <= 42;

-- Locations (garder des prix plus réalistes)
UPDATE annonces SET prix = prix * 120 WHERE type_transaction_id = 2 AND id <= 42;

-- Locations saisonnières (type_transaction_id = 3)
UPDATE annonces SET prix = prix * 100 WHERE type_transaction_id = 3 AND id <= 42;

-- Mettre à jour quelques titres pour l'Algérie
UPDATE annonces SET titre = 'Appartement F3 moderne - Alger Centre' WHERE id = 1;
UPDATE annonces SET titre = 'Villa contemporaine avec piscine - Oran' WHERE id = 2;
UPDATE annonces SET titre = 'Studio meublé centre-ville - Constantine' WHERE id = 3;
UPDATE annonces SET titre = 'Bureau moderne 100m² - Annaba' WHERE id = 4;
UPDATE annonces SET titre = 'Penthouse d''exception avec terrasse - Blida' WHERE id = 5;
UPDATE annonces SET titre = 'Maison de ville à rénover - Sétif' WHERE id = 6;
UPDATE annonces SET titre = 'F3 lumineux centre-ville Alger' WHERE id = 7;
UPDATE annonces SET titre = 'Villa moderne quartier résidentiel Oran' WHERE id = 8;
UPDATE annonces SET titre = 'Studio meublé proche université Constantine' WHERE id = 9;
UPDATE annonces SET titre = 'Espace bureau équipé Annaba' WHERE id = 10;
UPDATE annonces SET titre = 'Penthouse luxe avec vue panoramique Blida' WHERE id = 11;
UPDATE annonces SET titre = 'Maison traditionnelle à rénover Sétif' WHERE id = 12;
UPDATE annonces SET titre = 'F3 rénové avec balcon Alger' WHERE id = 13;
UPDATE annonces SET titre = 'F2 moderne quartier Bel Air Constantine' WHERE id = 14;
UPDATE annonces SET titre = 'F4 avec terrasse Annaba' WHERE id = 15;
UPDATE annonces SET titre = 'Duplex F5 quartier résidentiel Blida' WHERE id = 16;
UPDATE annonces SET titre = 'F2 investissement locatif Sétif' WHERE id = 17;
UPDATE annonces SET titre = 'Villa avec jardin Oran' WHERE id = 18;
UPDATE annonces SET titre = 'Villa contemporaine Batna' WHERE id = 19;
UPDATE annonces SET titre = 'Maison familiale rénovée Béjaïa' WHERE id = 20;
UPDATE annonces SET titre = 'Maison à rénover Tlemcen' WHERE id = 21;
UPDATE annonces SET titre = 'Villa vue mer Tizi Ouzou' WHERE id = 22;
UPDATE annonces SET titre = 'Villa d''architecte Béchar' WHERE id = 23;
UPDATE annonces SET titre = 'Terrain constructible 1000m²' WHERE id = 24;
UPDATE annonces SET titre = 'Terrain vue mer Mostaganem' WHERE id = 25;
UPDATE annonces SET titre = 'Local commercial centre-ville Alger' WHERE id = 26;
UPDATE annonces SET titre = 'Bureau 150m² zone d''affaires Tipaza' WHERE id = 27;
UPDATE annonces SET titre = 'F2 meublé hyper-centre Alger' WHERE id = 28;
UPDATE annonces SET titre = 'Studio étudiant proche université Alger' WHERE id = 29;
UPDATE annonces SET titre = 'F3 familial avec parking Constantine' WHERE id = 30;
UPDATE annonces SET titre = 'F4 avec terrasse Annaba' WHERE id = 31;
UPDATE annonces SET titre = 'Maison avec jardin Blida' WHERE id = 32;
UPDATE annonces SET titre = 'Villa avec piscine Sétif' WHERE id = 33;
UPDATE annonces SET titre = 'F3 quartier résidentiel Alger' WHERE id = 34;
UPDATE annonces SET titre = 'Loft atypique centre Batna' WHERE id = 35;
UPDATE annonces SET titre = 'Studio proche université Béjaïa' WHERE id = 36;
UPDATE annonces SET titre = 'F2 neuf résidence moderne Tlemcen' WHERE id = 37;
UPDATE annonces SET titre = 'Maison écologique Béjaïa' WHERE id = 38;
UPDATE annonces SET titre = 'Villa traditionnelle Tlemcen' WHERE id = 39;
UPDATE annonces SET titre = 'F4 neuf quartier moderne Tizi Ouzou' WHERE id = 40;
UPDATE annonces SET titre = 'Studio résidence touristique Mostaganem' WHERE id = 41;
UPDATE annonces SET titre = 'Villa vacances bord de mer Tipaza' WHERE id = 42;

-- Afficher un message de confirmation
SELECT 'Mise à jour terminée ! Les annonces ont été adaptées pour l''Algérie.' as Message;
SELECT COUNT(*) as 'Nombre d''annonces mises à jour' FROM annonces WHERE pays = 'Algérie';
