-- Mise à jour des mots de passe de tous les utilisateurs
-- Date: 26 octobre 2025
-- Nouveau mot de passe: 123456789
-- Hash bcrypt: $2y$10$SfIlv2C5Moqtl1Bd.OlL9e.1LiXxh2VJpQII1FoFyuJrzJwV/L/AK

-- Sauvegarde des anciens mots de passe (pour rollback si nécessaire)
-- CREATE TABLE users_password_backup AS 
-- SELECT id, username, password FROM users;

-- Mise à jour de tous les mots de passe
UPDATE users 
SET password = '$2y$10$SfIlv2C5Moqtl1Bd.OlL9e.1LiXxh2VJpQII1FoFyuJrzJwV/L/AK'
WHERE actif = 1;

-- Vérification des utilisateurs mis à jour
SELECT 
    id,
    username, 
    nom, 
    prenom,
    CASE 
        WHEN password = '$2y$10$SfIlv2C5Moqtl1Bd.OlL9e.1LiXxh2VJpQII1FoFyuJrzJwV/L/AK' 
        THEN '✅ Mis à jour' 
        ELSE '❌ Non mis à jour' 
    END as statut_password
FROM users 
ORDER BY id;

-- Informations de connexion après mise à jour:
-- ┌─────────────┬────────────┬─────────────────────┐
-- │ Utilisateur │ Mot passe  │ Rôle                │
-- ├─────────────┼────────────┼─────────────────────┤
-- │ tarssinas   │ 123456789  │ Super Administrateur│
-- │ jdupont     │ 123456789  │ Agent Standard      │
-- │ mmartin     │ 123456789  │ Agent Premium       │
-- │ pbernard    │ 123456789  │ Particulier         │
-- │ sdurand     │ 123456789  │ Modérateur          │
-- │ rleroy      │ 123456789  │ Administrateur      │
-- │ lmichel     │ 123456789  │ Visiteur            │
-- └─────────────┴────────────┴─────────────────────┘