-- Script de mise à jour des utilisateurs existants
-- Applique les nouvelles fonctionnalités aux données existantes

-- 1. Mettre à jour les limites d'annonces selon les rôles
UPDATE users u
INNER JOIN roles r ON u.role_id = r.id
SET u.max_annonces = CASE 
    WHEN r.nom_role = 'Super Administrateur' THEN -1  -- Illimité
    WHEN r.nom_role = 'Administrateur' THEN -1        -- Illimité
    WHEN r.nom_role = 'Modérateur' THEN 50            -- Limité pour test
    WHEN r.nom_role = 'Agent Premium' THEN -1         -- Illimité
    WHEN r.nom_role = 'Agent Standard' THEN 10        -- Limité selon params
    WHEN r.nom_role = 'Particulier' THEN 3            -- Limité selon params
    WHEN r.nom_role = 'Visiteur' THEN 0               -- Aucune annonce
    ELSE 1
END;

-- 2. Définir les préférences de notification par défaut
UPDATE users 
SET preferences_notifications = '{"email_nouvelles_annonces": true, "email_messages": true, "email_alertes": true, "sms_messages": false}'
WHERE preferences_notifications IS NULL;

-- 3. Activer les abonnements pour les agents existants
UPDATE users u
INNER JOIN roles r ON u.role_id = r.id
SET 
    u.date_abonnement = u.date_creation,
    u.date_expiration_abonnement = DATE_ADD(u.date_creation, INTERVAL 1 YEAR)
WHERE r.niveau_acces >= 40 -- Agents et plus
AND u.date_abonnement IS NULL;

-- 4. Créer quelques données de test pour les nouveaux champs
UPDATE users 
SET siret = CONCAT('1234567890', LPAD(id, 4, '0'))
WHERE role_id IN (SELECT id FROM roles WHERE niveau_acces >= 40)
AND siret IS NULL;

UPDATE users 
SET nom_agence = CONCAT('Agence Immobilière ', UPPER(LEFT(nom, 1)), UPPER(LEFT(prenom, 1)))
WHERE role_id IN (SELECT id FROM roles WHERE niveau_acces >= 40)
AND nom_agence IS NULL;

-- 5. Ajouter des spécialités par défaut
UPDATE users u
INNER JOIN roles r ON u.role_id = r.id
SET u.specialites = CASE 
    WHEN r.nom_role LIKE '%Premium%' THEN '["Vente", "Location", "Gestion locative", "Estimation"]'
    WHEN r.nom_role LIKE '%Standard%' THEN '["Vente", "Location"]'
    ELSE '["Vente"]'
END
WHERE r.niveau_acces >= 40
AND u.specialites IS NULL;