-- Migration pour adapter la table users pour la nouvelle structure Taghilt
-- À exécuter dans phpMyAdmin ou ligne de commande MySQL

-- Ajouter les nouvelles colonnes nécessaires
ALTER TABLE `users` 
ADD COLUMN `nom` VARCHAR(255) NULL AFTER `id_user`,
ADD COLUMN `telephone` VARCHAR(20) NULL AFTER `email`,
ADD COLUMN `mot_de_passe` VARCHAR(255) NULL AFTER `telephone`,
ADD COLUMN `role_id` INT(11) NULL AFTER `mot_de_passe`,
ADD COLUMN `date_creation` TIMESTAMP DEFAULT CURRENT_TIMESTAMP AFTER `role_id`,
ADD COLUMN `actif` TINYINT(1) DEFAULT 1 AFTER `date_creation`,
ADD COLUMN `remember_token` VARCHAR(100) NULL AFTER `actif`,
ADD COLUMN `remember_expires` DATETIME NULL AFTER `remember_token`;

-- Créer un rôle par défaut pour les clients
INSERT INTO `roles` (`role_name`, `role_comment`) VALUES 
('Administrateur', 'Accès complet au système'),
('Agent', 'Accès limité pour les agents immobiliers'),
('Client', 'Accès client pour les propriétaires');

-- Créer un utilisateur admin par défaut
-- Mot de passe : 123456789
INSERT INTO `users` (
    `nom`, 
    `email`, 
    `telephone`, 
    `mot_de_passe`, 
    `role_id`, 
    `actif`
) VALUES (
    'Administrateur Taghilt',
    'admin@taghilt.com',
    '0123456789',
    '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi',
    1,
    1
);

-- Ajouter un index sur remember_token pour les performances
ALTER TABLE `users` ADD INDEX `idx_remember_token` (`remember_token`);

-- Ajouter une clé étrangère vers la table roles
ALTER TABLE `users` ADD CONSTRAINT `fk_users_role` 
FOREIGN KEY (`role_id`) REFERENCES `roles`(`id_role`) ON DELETE SET NULL;