-- Script pour insérer des annonces de test

-- Assurez-vous que les tables categories_biens et types_transaction existent
INSERT INTO categories_biens (id, nom, description) VALUES
(1, 'Appartement', 'Appartements et studios'),
(2, 'Maison', 'Maisons individuelles'),
(3, 'Villa', 'Villas de luxe'),
(4, 'Terrain', 'Terrains constructibles'),
(5, 'Local Commercial', 'Locaux commerciaux'),
(6, 'Bureau', 'Espaces de bureau')
ON DUPLICATE KEY UPDATE nom=VALUES(nom);

INSERT INTO types_transaction (id, nom, description) VALUES
(1, 'Vente', 'Achat de propriété'),
(2, 'Location', 'Location de propriété')
ON DUPLICATE KEY UPDATE nom=VALUES(nom);

-- Annonces de test (assurez-vous que user_id=1 existe)
INSERT INTO annonces (
    user_id, categorie_id, type_transaction_id, titre, description, prix,
    surface, nb_pieces, nb_chambres, nb_salles_bain, ville, region, departement,
    statut, actif, date_publication
) VALUES
-- Alger
(1, 1, 1, 'Bel appartement F3 à Hydra', 
 'Magnifique appartement de 3 pièces dans un quartier résidentiel calme. Vue dégagée, cuisine équipée, parking sécurisé.',
 25000000, 95, 3, 2, 1, 'Alger', 'Alger', 'Alger', 'publiee', 1, NOW()),

(1, 2, 1, 'Villa moderne à Cheraga',
 'Villa de standing avec jardin et piscine. 5 chambres, salon spacieux, finitions haut de gamme.',
 85000000, 350, 7, 5, 2, 'Cheraga', 'Alger', 'Alger', 'publiee', 1, NOW()),

(1, 1, 2, 'Appartement F4 à louer Bab Ezzouar',
 'Appartement lumineux de 4 pièces, proche université et commodités. Idéal pour familles.',
 80000, 120, 4, 3, 2, 'Bab Ezzouar', 'Alger', 'Alger', 'publiee', 1, NOW()),

-- Oran
(1, 1, 1, 'Appartement vue mer à Ain El Turck',
 'Superbe appartement avec vue panoramique sur la mer. 3 chambres, balcon spacieux.',
 18000000, 110, 4, 3, 2, 'Ain El Turck', 'Oran', 'Oran', 'publiee', 1, NOW()),

(1, 3, 1, 'Villa de luxe aux Andalouses',
 'Villa d\'exception face à la mer. Architecture moderne, 6 chambres, piscine à débordement.',
 120000000, 450, 8, 6, 3, 'Les Andalouses', 'Oran', 'Oran', 'publiee', 1, NOW()),

(1, 5, 2, 'Local commercial à louer centre ville Oran',
 'Local commercial bien situé en plein centre. Idéal pour commerce ou bureau.',
 150000, 80, NULL, NULL, 1, 'Oran', 'Oran', 'Oran', 'publiee', 1, NOW()),

-- Constantine
(1, 2, 1, 'Maison traditionnelle à Constantine',
 'Belle maison de style colonial avec jardin. 4 chambres, garage double.',
 32000000, 200, 5, 4, 2, 'Constantine', 'Constantine', 'Constantine', 'publiee', 1, NOW()),

(1, 1, 2, 'F2 meublé proche université Constantine',
 'Appartement meublé et équipé. Idéal pour étudiants ou jeunes couples.',
 40000, 60, 2, 1, 1, 'Constantine', 'Constantine', 'Constantine', 'publiee', 1, NOW()),

-- Annaba
(1, 1, 1, 'Appartement neuf Annaba centre',
 'Appartement flambant neuf dans résidence moderne avec ascenseur et parking.',
 15000000, 85, 3, 2, 1, 'Annaba', 'Annaba', 'Annaba', 'publiee', 1, NOW()),

(1, 4, 1, 'Terrain constructible Annaba',
 'Terrain viabilisé de 500m² dans zone résidentielle. Certificat d\'urbanisme disponible.',
 8000000, 500, NULL, NULL, NULL, 'Annaba', 'Annaba', 'Annaba', 'publiee', 1, NOW()),

-- Tizi Ouzou
(1, 2, 1, 'Maison de campagne à Tizi Ouzou',
 'Charmante maison entourée d\'oliviers. Calme absolu, vue montagne.',
 22000000, 180, 5, 3, 2, 'Tizi Ouzou', 'Tizi Ouzou', 'Tizi Ouzou', 'publiee', 1, NOW()),

-- Sétif
(1, 1, 2, 'Appartement F3 Sétif centre',
 'Appartement bien situé proche de toutes commodités. Lumineux et spacieux.',
 45000, 90, 3, 2, 1, 'Sétif', 'Sétif', 'Sétif', 'publiee', 1, NOW()),

-- Béjaïa
(1, 3, 1, 'Villa vue mer Béjaïa',
 'Villa exceptionnelle avec accès direct à la plage. Architecture contemporaine.',
 95000000, 380, 7, 5, 3, 'Béjaïa', 'Béjaïa', 'Béjaïa', 'publiee', 1, NOW()),

-- Blida
(1, 1, 1, 'F4 résidence standing Blida',
 'Appartement de standing dans résidence sécurisée avec espaces verts.',
 20000000, 105, 4, 3, 2, 'Blida', 'Blida', 'Blida', 'publiee', 1, NOW()),

-- Tlemcen
(1, 2, 1, 'Maison ancienne rénovée Tlemcen',
 'Maison de caractère entièrement rénovée. Mélange d\'ancien et de moderne.',
 28000000, 190, 5, 4, 2, 'Tlemcen', 'Tlemcen', 'Tlemcen', 'publiee', 1, NOW());

-- Ajouter quelques photos principales (optionnel)
-- Vous devrez remplacer les chemins par de vraies photos ou utiliser des URLs externes
INSERT INTO photos_annonces (annonce_id, nom_fichier, chemin_fichier, principale, ordre_affichage)
SELECT id, 'default.jpg', 'https://images.unsplash.com/photo-1560518883-ce09059eeffa?w=800', 1, 1
FROM annonces
WHERE id NOT IN (SELECT annonce_id FROM photos_annonces WHERE principale = 1)
LIMIT 15;

SELECT 'Annonces de test insérées avec succès!' as message;
