-- Suggestions d'améliorations pour la table users
-- (À ajouter à la structure existante)

-- 1. Ajout de champs spécifiques pour les professionnels
ALTER TABLE `users` ADD COLUMN `siret` varchar(14) NULL AFTER `description`;
ALTER TABLE `users` ADD COLUMN `nom_agence` varchar(100) NULL AFTER `siret`;
ALTER TABLE `users` ADD COLUMN `licence_immobiliere` varchar(50) NULL AFTER `nom_agence`;
ALTER TABLE `users` ADD COLUMN `specialites` text NULL AFTER `licence_immobiliere`;

-- 2. Ajout de métadonnées pour la gestion avancée
ALTER TABLE `users` ADD COLUMN `max_annonces` int(11) NULL AFTER `specialites`;
ALTER TABLE `users` ADD COLUMN `date_abonnement` datetime NULL AFTER `max_annonces`;
ALTER TABLE `users` ADD COLUMN `date_expiration_abonnement` datetime NULL AFTER `date_abonnement`;

-- 3. Champs pour la géolocalisation et préférences
ALTER TABLE `users` ADD COLUMN `zones_intervention` text NULL AFTER `date_expiration_abonnement`;
ALTER TABLE `users` ADD COLUMN `preferences_notifications` text NULL AFTER `zones_intervention`;

-- 4. Index pour optimiser les performances
CREATE INDEX idx_users_role_actif ON users (role_id, actif);
CREATE INDEX idx_users_email_verified ON users (email, email_verifie);
CREATE INDEX idx_users_subscription ON users (date_abonnement, date_expiration_abonnement);

-- 5. Vue pour simplifier l'accès aux données professionnelles
CREATE VIEW vue_professionnels AS
SELECT 
    u.*,
    r.nom_role,
    r.niveau_acces,
    r.permissions
FROM users u
INNER JOIN roles r ON u.role_id = r.id
WHERE r.niveau_acces >= 40; -- Agents et plus