-- Script pour ajouter les champs "promoteur vedette" à la table users
-- Date: 2025-11-01

-- Ajouter le champ is_featured pour marquer les promoteurs vedettes
ALTER TABLE `users` 
ADD COLUMN `is_featured` TINYINT(1) DEFAULT 0 COMMENT 'Promoteur vedette (1=oui, 0=non)' AFTER `telephone`;

-- Ajouter le champ user_type pour identifier le type d'utilisateur
ALTER TABLE `users` 
ADD COLUMN `user_type` ENUM('user', 'promoter', 'agent', 'admin') DEFAULT 'user' COMMENT 'Type d''utilisateur' AFTER `is_featured`;

-- Ajouter le champ company_name pour les promoteurs
ALTER TABLE `users` 
ADD COLUMN `company_name` VARCHAR(255) NULL COMMENT 'Nom de la société (pour promoteurs)' AFTER `user_type`;

-- Ajouter le champ total_properties pour compter les annonces
ALTER TABLE `users` 
ADD COLUMN `total_properties` INT DEFAULT 0 COMMENT 'Nombre total de propriétés' AFTER `company_name`;

-- Créer un index pour optimiser les requêtes
CREATE INDEX idx_featured_promoters ON `users` (`is_featured`, `user_type`);

-- Exemple de mise à jour pour marquer un utilisateur comme promoteur vedette
-- UPDATE `users` SET `is_featured` = 1, `user_type` = 'promoter', `company_name` = 'Immobilière Alger' WHERE `id` = 1;

-- Requête pour récupérer les promoteurs vedettes avec le nombre d'annonces
/*
SELECT 
    u.id,
    u.username,
    u.email,
    u.company_name,
    u.total_properties,
    COUNT(a.id) as active_properties
FROM users u
LEFT JOIN annonces a ON u.id = a.user_id AND a.statut = 'active'
WHERE u.is_featured = 1 AND u.user_type = 'promoter'
GROUP BY u.id
ORDER BY u.total_properties DESC
LIMIT 5;
*/
