# Installation de la base de données des localités algériennes

## Méthode 1 : Via phpMyAdmin (Recommandé)

1. Ouvrez phpMyAdmin : http://localhost/phpmyadmin
2. Sélectionnez votre base de données `taghtil`
3. Cliquez sur l'onglet "Importer"
4. Cliquez sur "Choisir un fichier" et sélectionnez : `src/localites_algerie.sql`
5. Cliquez sur "Exécuter"

## Méthode 2 : Via ligne de commande

```bash
# Depuis le dossier du projet
cd c:\xampp\htdocs\taghtil

# Importer le fichier SQL
c:\xampp\mysql\bin\mysql.exe -u root -p taghtil < src\localites_algerie.sql
```

## Vérification

Après l'import, vérifiez que la table existe :

```sql
SELECT COUNT(*) as total_localites FROM localites_algerie;
-- Devrait retourner environ 150+ localités

SELECT COUNT(*) as total_wilayas FROM localites_algerie WHERE type='wilaya';
-- Devrait retourner 58 wilayas

SELECT COUNT(*) as total_communes FROM localites_algerie WHERE type='commune';
-- Devrait retourner les communes importées
```

## Structure de la table

La table `localites_algerie` contient :
- **58 wilayas** complètes avec coordonnées GPS
- **100+ communes principales** des grandes villes
- Support de la recherche full-text pour l'autocomplétion
- Codes postaux et codes wilaya

## Fonctionnalités

✅ Autocomplétion intelligente dans le formulaire de recherche
✅ Recherche par nom français ou arabe
✅ Hiérarchie wilaya > commune
✅ Codes postaux pour chaque localité
✅ Optimisé pour les performances (index + fulltext)

## API disponible

Une fois importé, l'API est accessible via :

- `api_localites.php?action=search&q=alger` - Recherche de villes
- `api_localites.php?action=wilayas` - Liste toutes les wilayas
- `api_localites.php?action=communes&wilaya=16` - Communes d'une wilaya
