<?php
/**
 * Script de migration pour ajouter les colonnes remember_token aux users
 * et initialiser les données de base nécessaires pour Taghilt
 * Accès : http://localhost/taghtil/migrate_remember_me.php
 */

require_once "Classeconfig.php";

echo "<h2>🏠 Migration Taghilt - Mise à jour de la base de données</h2>";

try {
    // 1. Vérifier et ajouter les colonnes remember_token
    $stmt = $pdo->query("SHOW COLUMNS FROM users LIKE 'remember_token'");
    $columnExists = $stmt->rowCount() > 0;
    
    if (!$columnExists) {
        echo "<p>🔧 Ajout des colonnes remember_token...</p>";
        
        $pdo->exec("
            ALTER TABLE users 
            ADD COLUMN remember_token VARCHAR(100) NULL,
            ADD COLUMN remember_expires DATETIME NULL
        ");
        
        $pdo->exec("ALTER TABLE users ADD INDEX idx_remember_token (remember_token)");
        
        echo "<p style='color: green;'>✅ Colonnes remember_token ajoutées avec succès</p>";
    } else {
        echo "<p style='color: green;'>✅ Les colonnes remember_token existent déjà</p>";
    }
    
    // 2. Vérifier et ajouter les nouvelles colonnes utilisateur
    $stmt = $pdo->query("SHOW COLUMNS FROM users LIKE 'nom'");
    $nomExists = $stmt->rowCount() > 0;
    
    if (!$nomExists) {
        echo "<p>🔧 Ajout des nouvelles colonnes utilisateur...</p>";
        
        $pdo->exec("
            ALTER TABLE users 
            ADD COLUMN nom VARCHAR(255) NULL AFTER id_user,
            ADD COLUMN telephone VARCHAR(20) NULL AFTER email,
            ADD COLUMN mot_de_passe VARCHAR(255) NULL AFTER telephone,
            ADD COLUMN role_id INT(11) NULL AFTER mot_de_passe,
            ADD COLUMN date_creation TIMESTAMP DEFAULT CURRENT_TIMESTAMP AFTER role_id,
            ADD COLUMN actif TINYINT(1) DEFAULT 1 AFTER date_creation
        ");
        
        echo "<p style='color: green;'>✅ Nouvelles colonnes utilisateur ajoutées</p>";
    } else {
        echo "<p style='color: green;'>✅ Les nouvelles colonnes utilisateur existent déjà</p>";
    }
    
    // 3. Vérifier et ajouter les rôles de base
    $stmt = $pdo->query("SELECT COUNT(*) FROM roles");
    $roleCount = $stmt->fetchColumn();
    
    if ($roleCount == 0) {
        echo "<p>🔧 Ajout des rôles de base...</p>";
        
        $pdo->exec("
            INSERT INTO roles (id_role, role_name, role_comment) VALUES 
            (1, 'Administrateur', 'Accès complet au système Taghilt'),
            (2, 'Agent', 'Accès limité pour les agents immobiliers'),
            (3, 'Client', 'Accès client pour les propriétaires')
        ");
        
        echo "<p style='color: green;'>✅ Rôles de base ajoutés avec succès</p>";
    } else {
        echo "<p style='color: green;'>✅ Les rôles de base existent déjà ($roleCount rôles)</p>";
    }
    
    // 4. Vérifier et créer l'utilisateur admin
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE email = ?");
    $stmt->execute(['admin@taghilt.com']);
    $adminExists = $stmt->fetchColumn() > 0;
    
    if (!$adminExists) {
        echo "<p>🔧 Création de l'utilisateur administrateur...</p>";
        
        $hashedPassword = password_hash('123456789', PASSWORD_DEFAULT);
        
        $stmt = $pdo->prepare("
            INSERT INTO users (nom, email, telephone, mot_de_passe, role_id, actif) 
            VALUES (?, ?, ?, ?, ?, 1)
        ");
        
        $stmt->execute([
            'Administrateur Taghilt',
            'admin@taghilt.com',
            '0123456789',
            $hashedPassword,
            1
        ]);
        
        echo "<p style='color: green;'>✅ Utilisateur administrateur créé avec succès</p>";
        echo "<div style='background: #f0f0f0; padding: 10px; border-radius: 5px; margin: 10px 0;'>";
        echo "<strong>Informations de connexion admin :</strong><br>";
        echo "Email: <code>admin@taghilt.com</code><br>";
        echo "Mot de passe: <code>123456789</code>";
        echo "</div>";
    } else {
        echo "<p style='color: green;'>✅ L'utilisateur administrateur existe déjà</p>";
    }
    
    // 5. Afficher la structure finale
    echo "<h3>📋 Structure finale de la table users :</h3>";
    $stmt = $pdo->query("DESCRIBE users");
    $columns = $stmt->fetchAll();
    
    echo "<table border='1' cellpadding='8' cellspacing='0' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background: #007bff; color: white;'>";
    echo "<th>Colonne</th><th>Type</th><th>Null</th><th>Clé</th><th>Défaut</th>";
    echo "</tr>";
    
    foreach ($columns as $column) {
        echo "<tr>";
        echo "<td><strong>" . htmlspecialchars($column['Field']) . "</strong></td>";
        echo "<td>" . htmlspecialchars($column['Type']) . "</td>";
        echo "<td>" . htmlspecialchars($column['Null']) . "</td>";
        echo "<td>" . htmlspecialchars($column['Key']) . "</td>";
        echo "<td>" . htmlspecialchars($column['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<h2 style='color: green;'>🎉 Migration Taghilt terminée avec succès !</h2>";
    echo "<p>La base de données est maintenant prête pour :</p>";
    echo "<ul>";
    echo "<li>✅ Fonctionnalité 'Se souvenir de moi'</li>";
    echo "<li>✅ Gestion des rôles utilisateur</li>";
    echo "<li>✅ Inscription des nouveaux utilisateurs</li>";
    echo "<li>✅ Interface d'administration</li>";
    echo "</ul>";
    
    echo "<div style='background: #d4edda; padding: 15px; border-radius: 5px; margin: 20px 0; border-left: 4px solid #28a745;'>";
    echo "<strong>Prochaines étapes :</strong><br>";
    echo "1. Testez la connexion admin : <a href='index.php?page=login' target='_blank'>Se connecter</a><br>";
    echo "2. Testez l'inscription : <a href='index.php?page=register' target='_blank'>S'inscrire</a><br>";
    echo "3. Accédez à l'interface visiteur : <a href='visiteur/' target='_blank'>Interface visiteur</a>";
    echo "</div>";
    
} catch (PDOException $e) {
    echo "<div style='background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<strong>❌ Erreur lors de la migration :</strong><br>";
    echo htmlspecialchars($e->getMessage());
    echo "</div>";
    
    echo "<p><strong>Vérifiez que :</strong></p>";
    echo "<ul>";
    echo "<li>XAMPP est démarré</li>";
    echo "<li>MySQL fonctionne</li>";
    echo "<li>La base de données existe</li>";
    echo "<li>Les paramètres de connexion dans Classeconfig.php sont corrects</li>";
    echo "</ul>";
}
?>