<?php
// Chargement automatique des classes
require_once 'Classeconfig.php';

// Autoloader pour les classes
spl_autoload_register(function ($className) {
    $classPath = str_replace('\\', DIRECTORY_SEPARATOR, $className) . '.php';
    
    // Chercher dans le dossier racine
    if (file_exists($classPath)) {
        require_once $classPath;
        return;
    }
    
    // Chercher dans les dossiers Classe et Views
    $searchPaths = ['Classe/', 'views/', ''];
    foreach ($searchPaths as $path) {
        $fullPath = $path . $classPath;
        if (file_exists($fullPath)) {
            require_once $fullPath;
            return;
        }
    }
});

// Instancier la classe PublicIndex et traiter la demande
use Classe\PublicIndex;

try {
    $publicIndex = new PublicIndex();
    $publicIndex->processPageRequest();
} catch (Exception $e) {
    // En cas d'erreur, afficher une page d'erreur simple
    echo "<!DOCTYPE html><html><head><title>Erreur</title></head><body>";
    echo "<h1>Erreur</h1><p>Une erreur s'est produite. Veuillez réessayer plus tard.</p>";
    echo "</body></html>";
}
?>

function showUnifiedLoginPage() {
    ?>
    <!DOCTYPE html>
    <html lang="fr">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Taghilt - Connexion</title>
        
        <!-- Bootstrap CSS -->
        <link href="assets/vendor/bootstrap-5.3.3/css/bootstrap.min.css" rel="stylesheet">
        <!-- Font Awesome -->
        <link href="assets/vendor/fontawesome-6.4.0-all.min.css" rel="stylesheet">
        
        <style>
            body {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            }
            
            .login-container {
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            
            .login-card {
                background: rgba(255, 255, 255, 0.95);
                backdrop-filter: blur(10px);
                border-radius: 20px;
                box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
                border: 1px solid rgba(255, 255, 255, 0.2);
                overflow: hidden;
                max-width: 500px;
                width: 100%;
                padding: 3rem;
                text-align: center;
            }
            
            .brand-logo {
                width: 80px;
                height: 80px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 20px;
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto 2rem;
            }
            
            .login-option {
                margin: 1rem 0;
            }
            
            .btn-login-option {
                width: 100%;
                padding: 1rem;
                border-radius: 12px;
                border: 2px solid #e9ecef;
                background: white;
                text-decoration: none;
                color: #333;
                transition: all 0.3s ease;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            
            .btn-login-option:hover {
                transform: translateY(-2px);
                box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
                border-color: #667eea;
                color: #667eea;
                text-decoration: none;
            }
            
            .btn-back {
                background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
                border: none;
                border-radius: 12px;
                padding: 0.75rem 2rem;
                color: white;
                text-decoration: none;
                transition: all 0.3s ease;
            }
            
            .btn-back:hover {
                transform: translateY(-2px);
                color: white;
                text-decoration: none;
            }
        </style>
    </head>
    <body>
        <div class="login-container">
            <div class="login-card">
                <div class="brand-logo">
                    <i class="fas fa-home fa-2x text-white"></i>
                </div>
                
                <h2 class="fw-bold mb-3">Taghilt</h2>
                <p class="text-muted mb-4">Votre plateforme immobilière de confiance</p>
                
                <div class="login-option">
                    <a href="visiteur/index.php?page=log" class="btn-login-option">
                        <i class="fas fa-sign-in-alt fa-2x me-3"></i>
                        <div>
                            <h5 class="mb-1">Connexion</h5>
                            <small class="text-muted">Accès à votre espace personnel</small>
                        </div>
                    </a>
                </div>
                
                <div class="login-option">
                    <a href="visiteur/index.php?page=register" class="btn-login-option">
                        <i class="fas fa-user-plus fa-2x me-3"></i>
                        <div>
                            <h5 class="mb-1">Créer un Compte</h5>
                            <small class="text-muted">Publiez vos annonces immobilières</small>
                        </div>
                    </a>
                </div>
                
                <div class="text-center mt-3">
                    <small class="text-muted">
                        <i class="fas fa-info-circle me-1"></i>
                        Créez votre compte pour vendre ou louer vos propriétés
                    </small>
                </div>
                
                <div class="mt-4">
                    <a href="index.php" class="btn-back">
                        <i class="fas fa-arrow-left me-2"></i>
                        Retour à l'accueil
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Bootstrap JS -->
        <script src="assets/vendor/bootstrap-5.3.3/js/bootstrap.bundle.min.js"></script>
        
        <script>
            // Accès admin secret (Ctrl+Alt+A)
            document.addEventListener('keydown', function(event) {
                if (event.ctrlKey && event.altKey && event.key === 'a') {
                    if (confirm('Accès administrateur - Êtes-vous sûr ?')) {
                        window.location.href = 'admin/index.php?page=log';
                    }
                }
            });
            
            // Accès admin par URL secrète
            if (window.location.search.includes('admin_access=true')) {
                const adminButton = document.createElement('div');
                adminButton.className = 'login-option';
                adminButton.innerHTML = `
                    <a href="admin/index.php?page=log" class="btn-login-option" style="border-color: #dc3545; color: #dc3545;">
                        <i class="fas fa-shield-alt fa-2x me-3"></i>
                        <div>
                            <h5 class="mb-1">Administration</h5>
                            <small class="text-muted">Accès système</small>
                        </div>
                    </a>
                `;
                document.querySelector('.login-option:last-of-type').after(adminButton);
            }
        </script>
    </body>
    </html>
    <?php
}

function showRegisterPage() {
    ?>
    <!DOCTYPE html>
    <html lang="fr">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Taghilt - Créer un Compte</title>
        
        <!-- Bootstrap CSS -->
        <link href="assets/vendor/bootstrap-5.3.3/css/bootstrap.min.css" rel="stylesheet">
        <!-- Font Awesome -->
        <link href="assets/vendor/fontawesome-6.4.0-all.min.css" rel="stylesheet">
        
        <style>
            body {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            }
            
            .register-container {
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            
            .register-card {
                background: rgba(255, 255, 255, 0.95);
                backdrop-filter: blur(10px);
                border-radius: 20px;
                box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
                border: 1px solid rgba(255, 255, 255, 0.2);
                overflow: hidden;
                max-width: 600px;
                width: 100%;
                padding: 3rem;
            }
            
            .brand-logo {
                width: 80px;
                height: 80px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 20px;
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto 2rem;
            }
            
            .form-floating label {
                color: #666;
            }
            
            .form-control {
                border-radius: 12px;
                border: 2px solid #e9ecef;
                padding: 0.75rem 1rem;
                transition: all 0.3s ease;
            }
            
            .form-control:focus {
                border-color: #667eea;
                box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
            }
            
            .btn-register {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border: none;
                border-radius: 12px;
                padding: 0.75rem 2rem;
                font-weight: 600;
                text-transform: uppercase;
                letter-spacing: 1px;
                transition: all 0.3s ease;
            }
            
            .btn-register:hover {
                transform: translateY(-2px);
                box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
            }
            
            .btn-back {
                background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
                border: none;
                border-radius: 12px;
                padding: 0.75rem 2rem;
                color: white;
                text-decoration: none;
                transition: all 0.3s ease;
            }
            
            .btn-back:hover {
                transform: translateY(-2px);
                color: white;
                text-decoration: none;
            }
            
            .feature-list {
                background: rgba(102, 126, 234, 0.1);
                border-radius: 12px;
                padding: 1.5rem;
                margin: 1rem 0;
            }
            
            .feature-item {
                display: flex;
                align-items: center;
                margin-bottom: 0.75rem;
            }
            
            .feature-item:last-child {
                margin-bottom: 0;
            }
            
            .feature-icon {
                width: 40px;
                height: 40px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 8px;
                display: flex;
                align-items: center;
                justify-content: center;
                margin-right: 1rem;
                color: white;
            }
        </style>
    </head>
    <body>
        <div class="register-container">
            <div class="register-card">
                <div class="text-center">
                    <div class="brand-logo">
                        <i class="fas fa-home fa-2x text-white"></i>
                    </div>
                    
                    <h2 class="fw-bold mb-2">Rejoignez Taghilt</h2>
                    <p class="text-muted mb-4">Créez votre compte et commencez à vendre</p>
                </div>

                <!-- Avantages -->
                <div class="feature-list">
                    <h6 class="fw-bold mb-3 text-center">
                        <i class="fas fa-star text-warning me-2"></i>
                        Avec votre compte Taghilt :
                    </h6>
                    
                    <div class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-plus"></i>
                        </div>
                        <div>
                            <strong>Publiez vos annonces</strong><br>
                            <small class="text-muted">Maisons, appartements, terrains...</small>
                        </div>
                    </div>
                    
                    <div class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <div>
                            <strong>Gérez vos ventes</strong><br>
                            <small class="text-muted">Suivi des visites et négociations</small>
                        </div>
                    </div>
                    
                    <div class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <div>
                            <strong>Contactez les acheteurs</strong><br>
                            <small class="text-muted">Messagerie intégrée sécurisée</small>
                        </div>
                    </div>
                </div>

                <!-- Formulaire d'inscription -->
                <form class="needs-validation" novalidate method="POST" action="process_register.php">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="prenom" name="prenom" placeholder="Prénom" required>
                                <label for="prenom"><i class="fas fa-user me-2"></i>Prénom</label>
                                <div class="invalid-feedback">
                                    Veuillez saisir votre prénom.
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="nom" name="nom" placeholder="Nom" required>
                                <label for="nom"><i class="fas fa-user me-2"></i>Nom</label>
                                <div class="invalid-feedback">
                                    Veuillez saisir votre nom.
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-floating mb-3">
                        <input type="email" class="form-control" id="email" name="email" placeholder="Email" required>
                        <label for="email"><i class="fas fa-envelope me-2"></i>Adresse Email</label>
                        <div class="invalid-feedback">
                            Veuillez saisir une adresse email valide.
                        </div>
                    </div>

                    <div class="form-floating mb-3">
                        <input type="tel" class="form-control" id="telephone" name="telephone" placeholder="Téléphone" required>
                        <label for="telephone"><i class="fas fa-phone me-2"></i>Numéro de Téléphone</label>
                        <div class="invalid-feedback">
                            Veuillez saisir votre numéro de téléphone.
                        </div>
                    </div>

                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" id="password" name="password" placeholder="Mot de passe" required minlength="6">
                        <label for="password"><i class="fas fa-lock me-2"></i>Mot de Passe</label>
                        <div class="invalid-feedback">
                            Le mot de passe doit contenir au moins 6 caractères.
                        </div>
                    </div>

                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" placeholder="Confirmer le mot de passe" required>
                        <label for="confirm_password"><i class="fas fa-lock me-2"></i>Confirmer le Mot de Passe</label>
                        <div class="invalid-feedback">
                            Les mots de passe ne correspondent pas.
                        </div>
                    </div>

                    <div class="form-check mb-4">
                        <input class="form-check-input" type="checkbox" id="accept_terms" name="accept_terms" required>
                        <label class="form-check-label" for="accept_terms">
                            J'accepte les <a href="#" target="_blank">Conditions d'Utilisation</a> et la <a href="#" target="_blank">Politique de Confidentialité</a>
                        </label>
                        <div class="invalid-feedback">
                            Vous devez accepter les conditions d'utilisation.
                        </div>
                    </div>

                    <div class="d-grid mb-3">
                        <button type="submit" class="btn btn-register text-white fw-bold">
                            <i class="fas fa-user-plus me-2"></i>
                            Créer Mon Compte
                        </button>
                    </div>

                    <div class="text-center">
                        <small class="text-muted">
                            Vous avez déjà un compte ? 
                            <a href="index.php?page=log" class="text-decoration-none">Se connecter</a>
                        </small>
                    </div>
                </form>

                <div class="text-center mt-4">
                    <a href="index.php" class="btn-back">
                        <i class="fas fa-arrow-left me-2"></i>
                        Retour à l'accueil
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Bootstrap JS -->
        <script src="assets/vendor/bootstrap-5.3.3/js/bootstrap.bundle.min.js"></script>
        
        <script>
            // Validation du formulaire
            (function() {
                'use strict';
                window.addEventListener('load', function() {
                    var forms = document.getElementsByClassName('needs-validation');
                    var validation = Array.prototype.filter.call(forms, function(form) {
                        form.addEventListener('submit', function(event) {
                            // Vérifier que les mots de passe correspondent
                            var password = document.getElementById('password').value;
                            var confirmPassword = document.getElementById('confirm_password').value;
                            var confirmPasswordField = document.getElementById('confirm_password');
                            
                            if (password !== confirmPassword) {
                                confirmPasswordField.setCustomValidity('Les mots de passe ne correspondent pas');
                            } else {
                                confirmPasswordField.setCustomValidity('');
                            }
                            
                            if (form.checkValidity() === false) {
                                event.preventDefault();
                                event.stopPropagation();
                            }
                            form.classList.add('was-validated');
                        }, false);
                    });
                }, false);
            })();

            // Vérification en temps réel des mots de passe
            document.getElementById('confirm_password').addEventListener('input', function() {
                var password = document.getElementById('password').value;
                var confirmPassword = this.value;
                
                if (password !== confirmPassword && confirmPassword !== '') {
                    this.setCustomValidity('Les mots de passe ne correspondent pas');
                } else {
                    this.setCustomValidity('');
                }
            });
        </script>
    </body>
    </html>
    <?php
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Taghilt - Plateforme Immobilière Algérienne</title>
    
    <!-- Bootstrap CSS -->
    <link href="assets/vendor/bootstrap-5.3.3/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="assets/vendor/fontawesome-6.4.0-all.min.css" rel="stylesheet">
    <!-- CSS personnalisé -->
    <link href="assets/css/public-style.css" rel="stylesheet">
</head>
<body>
    <!-- Header avec menu -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary fixed-top">
        <div class="container">
            <!-- Logo -->
            <a class="navbar-brand fw-bold" href="#">
                <i class="fas fa-home me-2"></i>
                Taghilt
            </a>

            <!-- Menu mobile toggle -->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <!-- Menu principal -->
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="#accueil">Accueil</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#proprietes">Propriétés</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#services">Services</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#contact">Contact</a>
                    </li>
                </ul>

                <!-- Sélecteurs langue et monnaie -->
                <div class="d-flex align-items-center me-3">
                    <!-- Sélecteur de langue -->
                    <div class="dropdown me-3">
                        <button class="btn btn-outline-light btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-globe me-1"></i>
                            <span id="current-lang">FR</span>
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" onclick="changeLanguage('fr')">
                                <img src="assets/images/flag-dz.png" class="me-2"> Français
                            </a></li>
                            <li><a class="dropdown-item" href="#" onclick="changeLanguage('en')">
                                <img src="assets/images/flag-us.png" class="me-2"> English
                            </a></li>
                        </ul>
                    </div>

                    <!-- Sélecteur de monnaie -->
                    <div class="dropdown me-3">
                        <button class="btn btn-outline-light btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-coins me-1"></i>
                            <span id="current-currency">DZD</span>
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" onclick="changeCurrency('DZD', '🇩🇿')">🇩🇿 Dinar Algérien (DZD)</a></li>
                            <li><a class="dropdown-item" href="#" onclick="changeCurrency('EUR', '🇪🇺')">🇪🇺 Euro (EUR)</a></li>
                            <li><a class="dropdown-item" href="#" onclick="changeCurrency('USD', '🇺🇸')">🇺🇸 Dollar (USD)</a></li>
                        </ul>
                    </div>
                </div>

                <!-- Bouton de connexion -->
                <a href="index.php?page=log" class="btn btn-light">
                    <i class="fas fa-sign-in-alt me-1"></i>
                    <span data-translate="login">Connexion</span>
                </a>
            </div>
        </div>
    </nav>

    <!-- Section Hero avec recherche -->
    <section id="accueil" class="hero-section d-flex align-items-center justify-content-center">
        <div class="hero-overlay">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-10 text-center">
                        <!-- Titre principal -->
                        <div class="text-center text-white mb-5">
                            <h1 class="display-4 fw-bold mb-3" data-translate="hero_title">
                                Trouvez votre propriété idéale en Algérie
                            </h1>
                            <p class="lead" data-translate="hero_subtitle">
                                Des milliers de biens immobiliers à vendre et à louer partout en Algérie
                            </p>
                        </div>

                        <!-- Barre de recherche principale -->
                        <div class="search-box bg-white rounded-4 p-4 shadow-lg">
                            <form id="search-form" class="row g-3">
                                <!-- Type de transaction -->
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold" data-translate="transaction_type">Type de transaction</label>
                                    <select class="form-select" name="transaction_type" id="transaction_type">
                                        <option value="" data-translate="all_types">Tous types</option>
                                        <option value="vente" data-translate="sale">Vente</option>
                                        <option value="location" data-translate="rent">Location</option>
                                    </select>
                                </div>

                                <!-- Type de propriété -->
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold" data-translate="property_type">Type de propriété</label>
                                    <select class="form-select" name="property_type" id="property_type">
                                        <option value="" data-translate="all_properties">Toutes propriétés</option>
                                        <?php if (!empty($typesProprietes)): ?>
                                            <?php foreach ($typesProprietes as $type): ?>
                                                <option value="<?= htmlspecialchars($type['nom']) ?>">
                                                    <?= htmlspecialchars($type['nom']) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <!-- Types par défaut si pas de connexion DB -->
                                            <option value="appartement" data-translate="apartment">Appartement</option>
                                            <option value="maison" data-translate="house">Maison</option>
                                            <option value="villa" data-translate="villa">Villa</option>
                                            <option value="terrain" data-translate="land">Terrain</option>
                                            <option value="commercial" data-translate="commercial">Commercial</option>
                                        <?php endif; ?>
                                    </select>
                                </div>

                                <!-- Ville -->
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold" data-translate="city">Ville</label>
                                    <select class="form-select" name="ville" id="ville">
                                        <option value="" data-translate="all_cities">Toutes les villes</option>
                                        <?php if (!empty($villes)): ?>
                                            <?php foreach ($villes as $ville): ?>
                                                <option value="<?= htmlspecialchars($ville['ville']) ?>">
                                                    <?= htmlspecialchars($ville['ville']) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <!-- Villes par défaut si pas de connexion DB -->
                                            <option value="Alger">Alger</option>
                                            <option value="Oran">Oran</option>
                                            <option value="Constantine">Constantine</option>
                                            <option value="Annaba">Annaba</option>
                                            <option value="Blida">Blida</option>
                                            <option value="Batna">Batna</option>
                                            <option value="Djelfa">Djelfa</option>
                                            <option value="Sétif">Sétif</option>
                                            <option value="Sidi Bel Abbès">Sidi Bel Abbès</option>
                                            <option value="Biskra">Biskra</option>
                                        <?php endif; ?>
                                    </select>
                                </div>

                                <!-- Prix -->
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold" data-translate="price_range">Gamme de prix</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="prix_min" placeholder="Min" data-translate-placeholder="min">
                                        <input type="number" class="form-control" name="prix_max" placeholder="Max" data-translate-placeholder="max">
                                    </div>
                                </div>

                                <!-- Bouton de recherche -->
                                <div class="col-12 text-center">
                                    <button type="submit" class="btn btn-primary btn-lg px-5">
                                        <i class="fas fa-search me-2"></i>
                                        <span data-translate="search">Rechercher</span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Section Statistiques -->
    <section class="py-4 bg-primary text-white">
        <div class="container">
            <div class="row text-center">
                <div class="col-md-3 col-6 mb-3">
                    <div class="stat-item">
                        <h3 class="fw-bold mb-1" id="stat-total"><?= $statistiques['total_annonces'] ?></h3>
                        <p class="mb-0" data-translate="total_properties">Propriétés disponibles</p>
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                    <div class="stat-item">
                        <h3 class="fw-bold mb-1" id="stat-ventes"><?= $statistiques['total_ventes'] ?></h3>
                        <p class="mb-0" data-translate="for_sale">À vendre</p>
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                    <div class="stat-item">
                        <h3 class="fw-bold mb-1" id="stat-locations"><?= $statistiques['total_locations'] ?></h3>
                        <p class="mb-0" data-translate="for_rent">À louer</p>
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                    <div class="stat-item">
                        <h3 class="fw-bold mb-1" id="stat-villes"><?= $statistiques['total_villes'] ?></h3>
                        <p class="mb-0" data-translate="cities_covered">Villes couvertes</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Section Types de propriétés -->
    <section id="proprietes" class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold" data-translate="property_types_title">Types de Propriétés</h2>
                <p class="lead text-muted" data-translate="property_types_subtitle">
                    Découvrez nos différents types de biens immobiliers
                </p>
            </div>

            <div class="row g-4">
                <!-- Appartements -->
                <div class="col-md-6 col-lg-4">
                    <div class="property-type-card">
                        <div class="card h-100 border-0 shadow-sm">
                            <div class="property-type-img">
                                <img src="https://images.unsplash.com/photo-1560448204-e02f11c3d0e2?w=400" 
                                     class="card-img-top" alt="Appartements">
                                <div class="property-type-overlay">
                                    <i class="fas fa-building fa-3x text-white"></i>
                                </div>
                            </div>
                            <div class="card-body text-center">
                                <h5 class="card-title" data-translate="apartments">Appartements</h5>
                                <p class="card-text text-muted" data-translate="apartments_desc">
                                    Modernes et confortables en centre-ville
                                </p>
                                <a href="#" class="btn btn-outline-primary" data-translate="view_all">Voir tout</a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Maisons -->
                <div class="col-md-6 col-lg-4">
                    <div class="property-type-card">
                        <div class="card h-100 border-0 shadow-sm">
                            <div class="property-type-img">
                                <img src="https://images.unsplash.com/photo-1570129477492-45c003edd2be?w=400" 
                                     class="card-img-top" alt="Maisons">
                                <div class="property-type-overlay">
                                    <i class="fas fa-home fa-3x text-white"></i>
                                </div>
                            </div>
                            <div class="card-body text-center">
                                <h5 class="card-title" data-translate="houses">Maisons</h5>
                                <p class="card-text text-muted" data-translate="houses_desc">
                                    Familiales avec jardin et garage
                                </p>
                                <a href="#" class="btn btn-outline-primary" data-translate="view_all">Voir tout</a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Villas -->
                <div class="col-md-6 col-lg-4">
                    <div class="property-type-card">
                        <div class="card h-100 border-0 shadow-sm">
                            <div class="property-type-img">
                                <img src="https://images.unsplash.com/photo-1564013799919-ab600027ffc6?w=400" 
                                     class="card-img-top" alt="Villas">
                                <div class="property-type-overlay">
                                    <i class="fas fa-crown fa-3x text-white"></i>
                                </div>
                            </div>
                            <div class="card-body text-center">
                                <h5 class="card-title" data-translate="villas">Villas</h5>
                                <p class="card-text text-muted" data-translate="villas_desc">
                                    Luxueuses avec piscine et grand jardin
                                </p>
                                <a href="#" class="btn btn-outline-primary" data-translate="view_all">Voir tout</a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Terrains -->
                <div class="col-md-6 col-lg-4">
                    <div class="property-type-card">
                        <div class="card h-100 border-0 shadow-sm">
                            <div class="property-type-img">
                                <img src="https://images.unsplash.com/photo-1500382017468-9049fed747ef?w=400" 
                                     class="card-img-top" alt="Terrains">
                                <div class="property-type-overlay">
                                    <i class="fas fa-map fa-3x text-white"></i>
                                </div>
                            </div>
                            <div class="card-body text-center">
                                <h5 class="card-title" data-translate="lands">Terrains</h5>
                                <p class="card-text text-muted" data-translate="lands_desc">
                                    Constructibles dans toute l'Algérie
                                </p>
                                <a href="#" class="btn btn-outline-primary" data-translate="view_all">Voir tout</a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Commerces -->
                <div class="col-md-6 col-lg-4">
                    <div class="property-type-card">
                        <div class="card h-100 border-0 shadow-sm">
                            <div class="property-type-img">
                                <img src="https://images.unsplash.com/photo-1497366216548-37526070297c?w=400" 
                                     class="card-img-top" alt="Commerces">
                                <div class="property-type-overlay">
                                    <i class="fas fa-store fa-3x text-white"></i>
                                </div>
                            </div>
                            <div class="card-body text-center">
                                <h5 class="card-title" data-translate="commercial">Commerces</h5>
                                <p class="card-text text-muted" data-translate="commercial_desc">
                                    Locaux commerciaux et bureaux
                                </p>
                                <a href="#" class="btn btn-outline-primary" data-translate="view_all">Voir tout</a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Bureaux -->
                <div class="col-md-6 col-lg-4">
                    <div class="property-type-card">
                        <div class="card h-100 border-0 shadow-sm">
                            <div class="property-type-img">
                                <img src="https://images.unsplash.com/photo-1497366811353-6870744d04b2?w=400" 
                                     class="card-img-top" alt="Bureaux">
                                <div class="property-type-overlay">
                                    <i class="fas fa-briefcase fa-3x text-white"></i>
                                </div>
                            </div>
                            <div class="card-body text-center">
                                <h5 class="card-title" data-translate="offices">Bureaux</h5>
                                <p class="card-text text-muted" data-translate="offices_desc">
                                    Espaces professionnels équipés
                                </p>
                                <a href="#" class="btn btn-outline-primary" data-translate="view_all">Voir tout</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Section Propriétés à proximité -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold" data-translate="nearby_properties">Propriétés à Proximité</h2>
                <p class="lead text-muted" data-translate="nearby_properties_subtitle">
                    Découvrez les biens immobiliers près de chez vous
                </p>
            </div>

            <div id="nearby-properties" class="row g-4">
                <?php if (!empty($proprietesVedette)): ?>
                    <?php foreach ($proprietesVedette as $propriete): ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="property-card">
                                <div class="property-image">
                                    <img src="<?= getImageParDefaut($propriete['categorie_nom']) ?>" 
                                         alt="<?= htmlspecialchars($propriete['titre']) ?>" loading="lazy">
                                    <div class="property-badge"><?= htmlspecialchars($propriete['type_transaction']) ?></div>
                                    <div class="property-price" data-price="<?= $propriete['prix'] ?>">
                                        <?= number_format($propriete['prix'], 0, ',', ' ') ?> DZD
                                    </div>
                                </div>
                                <div class="property-info">
                                    <h5 class="property-title"><?= htmlspecialchars(substr($propriete['titre'], 0, 50)) ?><?= strlen($propriete['titre']) > 50 ? '...' : '' ?></h5>
                                    <div class="property-location">
                                        <i class="fas fa-map-marker-alt me-1"></i>
                                        <?= htmlspecialchars($propriete['ville']) ?>
                                    </div>
                                    <div class="property-features">
                                        <div class="feature">
                                            <i class="fas fa-expand-arrows-alt"></i>
                                            <span><?= $propriete['surface'] ?> m²</span>
                                        </div>
                                        <?php if ($propriete['nb_pieces'] > 0): ?>
                                            <div class="feature">
                                                <i class="fas fa-bed"></i>
                                                <span><?= $propriete['nb_pieces'] ?> pièces</span>
                                            </div>
                                        <?php endif; ?>
                                        <?php if ($propriete['nb_chambres'] > 0): ?>
                                            <div class="feature">
                                                <i class="fas fa-door-open"></i>
                                                <span><?= $propriete['nb_chambres'] ?> ch.</span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="property-actions">
                                        <button class="btn btn-primary btn-sm" onclick="voirDetails(<?= $propriete['id'] ?>)">
                                            <i class="fas fa-eye me-1"></i>
                                            Voir détails
                                        </button>
                                        <button class="btn btn-outline-primary btn-sm" onclick="ajouterFavoris(<?= $propriete['id'] ?>)">
                                            <i class="fas fa-heart me-1"></i>
                                            Favoris
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <!-- Message si aucune propriété -->
                    <div class="col-12 text-center">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            Aucune propriété en vedette pour le moment.
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="text-center mt-4">
                <button class="btn btn-primary btn-lg" onclick="loadMoreProperties()">
                    <i class="fas fa-plus me-2"></i>
                    <span data-translate="load_more">Voir plus de propriétés</span>
                </button>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-dark text-light py-5">
        <div class="container">
            <div class="row g-4">
                <!-- À propos -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="fw-bold mb-3" data-translate="about_us">À Propos</h5>
                    <p class="text-light-50" data-translate="about_description">
                        taghtil est la plateforme immobilière de référence en Algérie. 
                        Nous facilitons l'achat, la vente et la location de biens immobiliers.
                    </p>
                    <div class="social-links">
                        <a href="#" class="text-light me-3"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="text-light me-3"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="text-light me-3"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="text-light me-3"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>

                <!-- Liens rapides -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="fw-bold mb-3" data-translate="quick_links">Liens Rapides</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#" class="text-light-75" data-translate="search_properties">Rechercher des propriétés</a></li>
                        <li class="mb-2"><a href="#" class="text-light-75" data-translate="post_ad">Déposer une annonce</a></li>
                        <li class="mb-2"><a href="#" class="text-light-75" data-translate="become_agent">Devenir agent</a></li>
                        <li class="mb-2"><a href="#" class="text-light-75" data-translate="price_estimate">Estimation gratuite</a></li>
                        <li class="mb-2"><a href="#" class="text-light-75" data-translate="help">Aide</a></li>
                    </ul>
                </div>

                <!-- Types de biens -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="fw-bold mb-3" data-translate="property_types">Types de Biens</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#" class="text-light-75" data-translate="apartments_for_sale">Appartements à vendre</a></li>
                        <li class="mb-2"><a href="#" class="text-light-75" data-translate="houses_for_sale">Maisons à vendre</a></li>
                        <li class="mb-2"><a href="#" class="text-light-75" data-translate="villas_for_sale">Villas à vendre</a></li>
                        <li class="mb-2"><a href="#" class="text-light-75" data-translate="apartments_for_rent">Appartements à louer</a></li>
                        <li class="mb-2"><a href="#" class="text-light-75" data-translate="commercial_properties">Biens commerciaux</a></li>
                    </ul>
                </div>

                <!-- Contact -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="fw-bold mb-3" data-translate="contact">Contact</h5>
                    <div class="contact-info">
                        <div class="mb-2">
                            <i class="fas fa-map-marker-alt me-2"></i>
                            <span data-translate="address">Alger, Algérie</span>
                        </div>
                        <div class="mb-2">
                            <i class="fas fa-phone me-2"></i>
                            <a href="tel:+213123456789" class="text-light-75">+213 123 456 789</a>
                        </div>
                        <div class="mb-2">
                            <i class="fas fa-envelope me-2"></i>
                            <a href="mailto:contact@taghtil.com" class="text-light-75">contact@taghtil.com</a>
                        </div>
                        <div class="mb-2">
                            <i class="fas fa-clock me-2"></i>
                            <span data-translate="hours">Lun - Ven: 8h - 18h</span>
                        </div>
                    </div>
                </div>
            </div>

            <hr class="my-4">

            <!-- Copyright -->
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="mb-0" data-translate="copyright">
                        &copy; 2024 taghtil. Tous droits réservés.
                    </p>
                </div>
                <div class="col-md-6 text-md-end">
                    <ul class="list-inline mb-0">
                        <li class="list-inline-item">
                            <a href="#" class="text-light-75" data-translate="privacy">Confidentialité</a>
                        </li>
                        <li class="list-inline-item">|</li>
                        <li class="list-inline-item">
                            <a href="#" class="text-light-75" data-translate="terms">Conditions</a>
                        </li>
                        <li class="list-inline-item">|</li>
                        <li class="list-inline-item">
                            <a href="#" class="text-light-75" data-translate="sitemap">Plan du site</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="assets/vendor/bootstrap-5.3.3/js/bootstrap.bundle.min.js"></script>
    <!-- Script personnalisé -->
    <script src="assets/js/public-script.js"></script>
</body>
</html>



