<?php
// Démarrer la session si ce n'est pas déjà fait
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Charger la configuration (détecte automatiquement l'environnement)
require_once 'config.php';

// Les erreurs sont configurées dans config.php selon l'environnement

// Autoloader pour les classes
spl_autoload_register(function ($className) {
    $classPath = str_replace('\\', DIRECTORY_SEPARATOR, $className) . '.php';
    
    // Chercher dans le dossier racine
    if (file_exists($classPath)) {
        require_once $classPath;
        return;
    }
    
    // Chercher dans les dossiers Classe et Views
    $searchPaths = ['Classe/', 'views/', ''];
    foreach ($searchPaths as $path) {
        $fullPath = $path . $classPath;
        if (file_exists($fullPath)) {
            require_once $fullPath;
            return;
        }
    }
});

// Instancier la classe PublicIndex et traiter la demande
use Classe\PublicIndex;

try {
    $publicIndex = new PublicIndex();
    $publicIndex->processPageRequest();
} catch (Exception $e) {
    // En cas d'erreur, afficher une page d'erreur simple
    echo "<!DOCTYPE html><html><head><title>Erreur</title></head><body>";
    echo "<h1>Erreur</h1><p>Une erreur s'est produite : " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
    echo "</body></html>";
}
?>