# 📋 Personnalisation des Libellés par Rôle

## 🎯 Objectif
Ce système permet d'adapter automatiquement les libellés du menu et du dashboard selon le rôle de l'utilisateur connecté, offrant une expérience utilisateur personnalisée et professionnelle.

## 🏷️ Mapping des Libellés par Rôle

### 👤 **Visiteurs / Utilisateurs de base**
- **Dashboard :** "Mon espace"
- **Annonces :** "Mes annonces"
- **Contacts :** "Mes contacts reçus"
- **Gestion :** "Gestion"
- **Statistiques :** "Mes performances"

### 🏠 **Agent Particulier** (Niveau 20+)
- **Dashboard :** "Mon espace"
- **Annonces :** "Mes biens"
- **Contacts :** "Mes contacts"
- **Gestion :** "Gestion biens"
- **Statistiques :** "Mes performances"

### 🏢 **Agent Standard / Gestionnaire** (Niveau 40+)
- **Dashboard :** "Espace Pro"
- **Annonces :** "Mes mandats"
- **Contacts :** "Contacts clients"
- **Gestion :** "Gestion biens"
- **Statistiques :** "Mes statistiques"

### 👑 **Agent Premium / Modérateur** (Niveau 70+)
- **Dashboard :** "Espace Pro Premium"
- **Annonces :** "Mon portefeuille Pro"
- **Contacts :** "Leads clients"
- **Gestion :** "Gestion avancée"
- **Statistiques :** "Analytics Pro"

### ⚡ **Administrateur / Super Administrateur** (Niveau 90+)
- **Dashboard :** "Centre de contrôle"
- **Annonces :** "Toutes les annonces"
- **Contacts :** "Tous les contacts"
- **Gestion :** "Administration"
- **Statistiques :** "Statistiques globales"

## 🛠️ Fichiers Modifiés

### 1. **views/NavBarHtml.php**
- ✅ Ajout de la méthode `getCustomLabels()`
- ✅ Personnalisation du menu principal
- ✅ Application des libellés dynamiques

### 2. **views/DashboardHtml.php**
- ✅ Ajout de la méthode `getCustomLabels()` statique
- ✅ Personnalisation du titre du dashboard
- ✅ Utilisation des libellés cohérents

## 🎨 Avantages UX

### **Pour les Visiteurs :**
- Terminologie simple et personnelle
- Sensation de propriété avec "Mes..."

### **Pour les Agents :**
- Vocabulaire professionnel adapté
- Distinction claire des niveaux (Standard vs Premium)

### **Pour les Administrateurs :**
- Terminologie de supervision
- Visibilité sur la portée globale

## 🔧 Comment Étendre

Pour ajouter de nouveaux libellés ou rôles :

1. **Modifier la méthode `getCustomLabels()`** dans les deux fichiers
2. **Ajouter les nouveaux rôles** avec leurs niveaux d'accès
3. **Définir les libellés** correspondants
4. **Tester** avec différents types d'utilisateurs

## ✨ Résultat
- **UX Améliorée :** Chaque utilisateur voit des termes adaptés à son contexte
- **Professionnalisme :** Vocabulaire métier approprié selon le niveau
- **Clarté :** Élimination de l'ambiguïté sur le périmètre d'action
- **Engagement :** Interface plus personnalisée et motivante

---
**📅 Dernière mise à jour :** 26 octobre 2025  
**👤 Développé par :** GitHub Copilot & Ahmed ZERZIH