# Migration des Assets Externes vers Local

## Résumé des changements

Tous les liens externes (CDN) ont été remplacés par des versions locales pour améliorer :
- **Performance** : Pas de dépendance réseau externe
- **Sécurité** : Contrôle total sur les versions
- **Fiabilité** : Pas de risque de CDN indisponible
- **Conformité RGPD** : Pas de connexion à des serveurs tiers

## Assets téléchargés

### Font Awesome 6.4.0
- **Emplacement** : `assets/vendor/fontawesome-6.4.0-all.min.css`
- **Webfonts** : `assets/vendor/fontawesome-6.4.0-webfonts/`
  - fa-solid-900.woff2
  - fa-regular-400.woff2
  - fa-brands-400.woff2
- **Ancien CDN** : https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css

### Bootstrap 5.3.3
- **Emplacement** : `assets/vendor/bootstrap-5.3.3/`
- **Déjà présent** : Oui ✓
- **Ancien CDN** : https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/

## Fichiers modifiés

### 1. views/PublicHeaderFooter.php
**Avant** :
```php
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
```

**Après** :
```php
<link href="<?= $pathPrefix ?>assets/vendor/bootstrap-5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="<?= $pathPrefix ?>assets/vendor/fontawesome-6.4.0-all.min.css" rel="stylesheet">
<script src="<?= $pathPrefix ?>assets/vendor/bootstrap-5.3.3/dist/js/bootstrap.bundle.min.js"></script>
```

### 2. assets-config.php (Nouveau)
Fichier de configuration centralisée pour gérer les chemins des assets.

## Fichiers restants à modifier

Les fichiers suivants contiennent encore des liens CDN et doivent être mis à jour :

1. **visiteur/index.php**
2. **index_backup.php**  
3. **install2/index.php**
4. **views/VariousViewsHtml.php**
5. **views/AdminVariousViewsHtml.php**
6. **views/VisiteursHtml.php**

## Instructions pour finaliser

### Commande de remplacement globale :

```powershell
# Remplacer Bootstrap CSS
Get-ChildItem -Path . -Include *.php -Recurse | ForEach-Object {
    (Get-Content $_.FullName) -replace 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css', 'assets/vendor/bootstrap-5.3.3/dist/css/bootstrap.min.css' | Set-Content $_.FullName
}

# Remplacer Font Awesome CSS
Get-ChildItem -Path . -Include *.php -Recurse | ForEach-Object {
    (Get-Content $_.FullName) -replace 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', 'assets/vendor/fontawesome-6.4.0-all.min.css' | Set-Content $_.FullName
}

# Remplacer Bootstrap JS
Get-ChildItem -Path . -Include *.php -Recurse | ForEach-Object {
    (Get-Content $_.FullName) -replace 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js', 'assets/vendor/bootstrap-5.3.3/dist/js/bootstrap.bundle.min.js' | Set-Content $_.FullName
}
```

## Vérification

Après modification, vérifier qu'aucun lien externe ne subsiste :

```powershell
Get-ChildItem -Path . -Include *.php -Recurse | Select-String -Pattern "https?://(cdn|cdnjs|jsdelivr|unpkg|googleapis)" | Select-Object Path, LineNumber, Line
```

## Avantages

✅ **Pas de dépendance réseau externe**
✅ **Meilleure performance (pas de latence CDN)**
✅ **Contrôle des versions**
✅ **Conformité RGPD**
✅ **Fiabilité accrue**

## Structure finale des assets

```
assets/
├── vendor/
│   ├── bootstrap-5.3.3/
│   │   └── dist/
│   │       ├── css/
│   │       │   └── bootstrap.min.css
│   │       └── js/
│   │           └── bootstrap.bundle.min.js
│   ├── fontawesome-6.4.0-all.min.css
│   ├── fontawesome-6.4.0-webfonts/
│   │   ├── fa-solid-900.woff2
│   │   ├── fa-regular-400.woff2
│   │   └── fa-brands-400.woff2
│   ├── jQuery-3.7.1/
│   ├── fontawesome-free-5.2.0-web/ (ancien, peut être supprimé)
│   └── ...
├── css/
├── js/
└── images/
```
