# Modal de Connexion Requise - Documentation

## 📋 Vue d'ensemble

Le modal de connexion requise est un composant réutilisable qui s'affiche lorsqu'un utilisateur non connecté tente d'accéder à des fonctionnalités nécessitant une authentification (favoris, alertes, etc.).

## 🎯 Fonctionnalités

- ✅ Détection automatique de l'état de connexion
- 🎨 Design cohérent avec les couleurs du site (dégradé violet)
- 🔄 Réutilisable sur plusieurs pages
- 📱 Responsive et accessible
- ⚡ Animations fluides
- 🔗 Redirection vers login ou register

## 📁 Fichiers

### 1. **Classe PHP** : `views/LoginModalHtml.php`
Génère le HTML et JavaScript du modal.

### 2. **CSS** : `assets/css/login-modal.css`
Styles partagés pour le modal (à inclure dans vos pages).

## 🚀 Utilisation

### Étape 1 : Importer la classe

```php
use Views\LoginModalHtml;
```

### Étape 2 : Afficher le modal

```php
// À la fin de votre contenu HTML, avant la fermeture de la fonction
LoginModalHtml::renderLoginModal();
LoginModalHtml::renderLoginModalScript('.btn-favorite');
```

### Étape 3 : Inclure le CSS

Ajoutez dans votre `<head>` ou dans vos includes CSS :

```html
<link rel="stylesheet" href="assets/css/login-modal.css">
```

### Étape 4 : Ajouter l'attribut aux boutons

Pour que le modal fonctionne, ajoutez l'attribut `data-annonce-id` à vos boutons :

```html
<button class="btn-favorite" data-annonce-id="<?= $annonce['id'] ?>">
    <i class="far fa-heart"></i>
</button>
```

## 🎨 Personnalisation du sélecteur

Par défaut, le modal est déclenché par les éléments avec la classe `.btn-favorite`. 
Vous pouvez spécifier un autre sélecteur :

```php
// Pour plusieurs sélecteurs
LoginModalHtml::renderLoginModalScript('.btn-favorite, .btn-alert, .btn-save-search');
```

## 📄 Pages utilisant le modal

1. ✅ **page=annonce** (détails d'une annonce)
2. ✅ **page=search** (résultats de recherche)
3. 🔜 Ajoutez-le facilement à d'autres pages

## 🔧 Méthodes disponibles

### `renderLoginModal()`
Affiche le HTML du modal Bootstrap.

**Utilisation :**
```php
LoginModalHtml::renderLoginModal();
```

### `renderLoginModalScript($triggerSelector)`
Génère le JavaScript pour gérer l'affichage du modal.

**Paramètres :**
- `$triggerSelector` (string) : Sélecteur CSS des éléments déclencheurs (défaut: `.btn-favorite`)

**Utilisation :**
```php
LoginModalHtml::renderLoginModalScript('.btn-favorite');
```

## 🎯 Logique de fonctionnement

1. **Utilisateur non connecté** → Affiche le modal
2. **Utilisateur connecté** → Toggle la classe `active` + appel AJAX possible

```javascript
// Dans le script, vous pouvez ajouter votre logique AJAX
if (annonceId) {
    // Exemple: saveFavorite(annonceId);
}
```

## 💡 Best Practices

1. ✅ **Toujours inclure le CSS** `login-modal.css`
2. ✅ **Appeler le modal une seule fois** par page
3. ✅ **Utiliser `data-annonce-id`** pour identifier les annonces
4. ✅ **Vérifier la session** : `$_SESSION['user_id']`
5. ✅ **Ne pas dupliquer le code** du modal

## 🌈 Contenu du modal

### En-tête
- Titre : "Connectez-vous pour continuer"
- Sous-titre : "Accédez à toutes les fonctionnalités"

### Corps
Trois avantages présentés :
1. 💾 Sauvegardez vos recherches
2. ❤️ Enregistrez vos propriétés favorites
3. 🔔 Recevez des alertes en temps réel

### Actions
- Bouton "Se connecter" → `index.php?page=login`
- Bouton "Créer un compte" → `index.php?page=register`

## 🔄 Exemple complet

```php
<?php
namespace Views;

use Views\LoginModalHtml;

class MaPage {
    public static function afficher() {
        ?>
        <div class="container">
            <h1>Ma page</h1>
            
            <button class="btn-favorite" data-annonce-id="123">
                <i class="far fa-heart"></i> Ajouter aux favoris
            </button>
        </div>

        <?php
        // Afficher le modal et son script
        LoginModalHtml::renderLoginModal();
        LoginModalHtml::renderLoginModalScript('.btn-favorite');
        ?>
        <?php
    }
}
```

## 📝 Notes importantes

- Le modal utilise **Bootstrap 5** (assurez-vous que Bootstrap est inclus)
- Les animations CSS sont automatiques
- Le modal est **accessible** (ARIA labels)
- Compatible avec les **icônes Font Awesome**

## 🎨 Couleurs utilisées

- Dégradé violet : `#667eea` → `#764ba2`
- Check vert : Bootstrap `text-success`
- Texte muted : Bootstrap `text-muted`

---

**Dernière mise à jour** : 2 novembre 2025
