# 🚀 Guide de Déploiement sur le Serveur de Production

## ❌ Problème Résolu

**Erreur rencontrée :**
```
Fatal error: Call to a member function exec() on bool in PublicSearch.php:53
```

**Cause :** La connexion à la base de données échouait car `config.php` n'était pas trouvé ou contenait de mauvaises informations.

---

## ✅ Solutions Appliquées

### 1. **Configuration Auto-Détectée** (`config.php`)

Le fichier `config.php` détecte maintenant automatiquement l'environnement :
- **Local (XAMPP)** : Utilise `taghilt` / `root` / ``
- **Production** : Utilise `dzhostco_taghilt` / `dzhostco_taghilt` / `ccGaDyDVQEVf5WyQkstP`

### 2. **Chemins de Recherche Améliorés** (`dbConnect.php`)

La fonction `dbConnect()` cherche maintenant `config.php` dans plusieurs emplacements :
```php
$configPaths = [
    __DIR__ . '/../../config.php',
    dirname(dirname(__DIR__)) . '/config.php',
    '../config.php',
    './config.php',
    '../../config.php'
];
```

---

## 📋 Étapes de Déploiement

### Étape 1 : Télécharger les Fichiers

Uploadez tous les fichiers du projet sur votre serveur dans :
```
/home/dzhostco/domains/reoleweb.com/public_html/public/taghilt/
```

### Étape 2 : Vérifier la Base de Données

Assurez-vous que la base de données existe avec les informations :
- **Nom** : `dzhostco_taghilt`
- **Utilisateur** : `dzhostco_taghilt`
- **Mot de passe** : `ccGaDyDVQEVf5WyQkstP`

### Étape 3 : Importer la Base de Données

Importez le fichier SQL dans phpMyAdmin :
```bash
src/taghilt.sql
```

Ou via ligne de commande :
```bash
mysql -u dzhostco_taghilt -p dzhostco_taghilt < src/taghilt.sql
```

### Étape 4 : Tester la Connexion

Accédez au script de test :
```
https://reoleweb.com/public/taghilt/test_db_connection.php
```

Vous devriez voir :
- ✅ Config chargé
- ✅ Connexion MySQLi réussie
- ✅ Connexion dbConnect() réussie

### Étape 5 : Configurer les Permissions

Assurez-vous que les dossiers suivants sont accessibles en écriture :
```bash
chmod 755 assets/images/annonces
chmod 755 assets/images/users
chmod 644 config.php
```

### Étape 6 : Supprimer le Fichier de Test

Une fois tout testé, supprimez le fichier de test pour des raisons de sécurité :
```bash
rm test_db_connection.php
```

---

## 🔧 Dépannage

### Problème : "config.php introuvable"

**Solution :**
1. Vérifiez que `config.php` est bien à la racine du projet
2. Vérifiez les permissions du fichier (644)
3. Exécutez `test_db_connection.php` pour voir les chemins testés

### Problème : "Access denied for user"

**Solution :**
1. Vérifiez les identifiants dans cPanel > MySQL Databases
2. Assurez-vous que l'utilisateur a les permissions sur la base
3. Testez la connexion avec phpMyAdmin

### Problème : "Table 'annonces' doesn't exist"

**Solution :**
1. Importez le fichier SQL : `src/taghilt.sql`
2. Vérifiez dans phpMyAdmin que les tables sont créées

### Problème : "Can't connect to MySQL server"

**Solution :**
1. Vérifiez que MySQL est en cours d'exécution
2. Essayez avec `127.0.0.1` au lieu de `localhost` dans `config.php`
3. Contactez votre hébergeur si le problème persiste

---

## 📝 Fichiers Modifiés

1. ✅ **config.php** - Détection automatique de l'environnement
2. ✅ **Parametre/taghilt/dbConnect.php** - Recherche améliorée de config.php
3. ✅ **test_db_connection.php** - Script de diagnostic (à supprimer après test)

---

## 🔒 Sécurité

### En Production

Le fichier `config.php` désactive automatiquement l'affichage des erreurs :
```php
error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
```

### Fichiers Sensibles

Protégez ces fichiers avec `.htaccess` :
```apache
<Files "config.php">
    Order Allow,Deny
    Deny from all
</Files>
```

---

## 📞 Support

Si vous rencontrez des problèmes après avoir suivi ce guide :

1. Exécutez `test_db_connection.php` et notez les erreurs
2. Vérifiez les logs d'erreur du serveur
3. Vérifiez que toutes les extensions PHP nécessaires sont activées :
   - mysqli
   - pdo_mysql
   - json
   - mbstring

---

**Dernière mise à jour** : 2 novembre 2025
