<?php
// Page de connexion automatique qui redirige selon le niveau d'utilisateur

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Inclusion des classes nécessaires
include_once 'Parametre/taghilt/taghilt.php';
include_once 'Parametre/taghilt/LoadDirClass.php';
include_once 'Parametre/taghilt/dbConnect.php';
include_once 'Classe/FunctionClasse.php';

use Classe\Login;

$conn = dbConnect(false);

if (!$conn) {
    header('Location: index.php');
    exit;
}

extract($_REQUEST, EXTR_PREFIX_ALL | EXTR_REFS, 'v');

// Si l'utilisateur est déjà connecté, rediriger selon son niveau
if (isset($_SESSION[$NomSite]['userConnected']) && $_SESSION[$NomSite]['userConnected']) {
    
    if (isset($_SESSION[$NomSite]['userRoles'])) {
        $roles = $_SESSION[$NomSite]['userRoles'];
        $userLevel = 0;
        
        foreach ($roles as $role) {
            if (isset($role['role_level'])) {
                $userLevel = max($userLevel, $role['role_level']);
            }
        }
        
        // Redirection selon le niveau
        if ($userLevel >= 60) {
            // Administrateur ou Agent
            header('Location: admin/index.php');
            exit;
        } else {
            // Visiteur
            header('Location: visiteur/index.php');
            exit;
        }
    }
}

// Si pas connecté, traiter la connexion
$login = new Login($conn, 'log');

// Après connexion, rediriger selon le niveau
if (isset($_SESSION[$NomSite]['userConnected']) && $_SESSION[$NomSite]['userConnected']) {
    
    if (isset($_SESSION[$NomSite]['userRoles'])) {
        $roles = $_SESSION[$NomSite]['userRoles'];
        $userLevel = 0;
        
        foreach ($roles as $role) {
            if (isset($role['role_level'])) {
                $userLevel = max($userLevel, $role['role_level']);
            }
        }
        
        // Redirection selon le niveau
        if ($userLevel >= 60) {
            // Administrateur ou Agent
            header('Location: admin/index.php');
            exit;
        } else {
            // Visiteur
            header('Location: visiteur/index.php');
            exit;
        }
    }
}
?>