// Script global pour l'interface utilisateur
// Ce fichier contient les fonctions JavaScript communes à toutes les interfaces

$(document).ready(function() {
    console.log("Script global chargé");
    
    // Initialisation générale
    initializeCommonComponents();
});

function initializeCommonComponents() {
    // Initialisation des tooltips Bootstrap si disponibles
    if (typeof bootstrap !== 'undefined' && bootstrap.Tooltip) {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    }
    
    // Initialisation des popovers Bootstrap si disponibles
    if (typeof bootstrap !== 'undefined' && bootstrap.Popover) {
        var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));
        var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
            return new bootstrap.Popover(popoverTriggerEl);
        });
    }
    
    // Gestion des alertes auto-disparaissantes
    setTimeout(function() {
        $('.alert.auto-dismiss').fadeOut('slow');
    }, 5000);
}

// Fonction utilitaire pour afficher des notifications
function showNotification(message, type = 'info', duration = 3000) {
    const alertClass = `alert-${type}`;
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    `;
    
    // Ajouter la notification au top de la page
    $('body').prepend(alertHtml);
    
    // Auto-suppression après la durée spécifiée
    setTimeout(function() {
        $('.alert').first().fadeOut('slow', function() {
            $(this).remove();
        });
    }, duration);
}

// Fonction utilitaire pour confirmer les actions de suppression
function confirmDelete(message = "Êtes-vous sûr de vouloir supprimer cet élément ?") {
    return confirm(message);
}

// Fonction pour gérer les formulaires AJAX
function handleAjaxForm(formSelector, successCallback = null, errorCallback = null) {
    $(formSelector).on('submit', function(e) {
        e.preventDefault();
        
        const form = $(this);
        const formData = new FormData(this);
        const url = form.attr('action') || window.location.href;
        
        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (successCallback) {
                    successCallback(response);
                } else {
                    showNotification('Opération réussie', 'success');
                }
            },
            error: function(xhr, status, error) {
                if (errorCallback) {
                    errorCallback(xhr, status, error);
                } else {
                    showNotification('Erreur lors de l\'opération', 'danger');
                }
            }
        });
    });
}