// Script pour la gestion du formulaire d'inscription
document.addEventListener('DOMContentLoaded', function() {
    const registerForm = document.getElementById('registerForm');
    const registerAlert = document.getElementById('registerAlert');
    const registerLoading = document.getElementById('registerLoading');
    
    if (registerForm) {
        // Validation en temps réel des mots de passe
        const password = document.getElementById('password');
        const confirmPassword = document.getElementById('confirmPassword');
        
        function validatePasswords() {
            if (confirmPassword.value && password.value !== confirmPassword.value) {
                confirmPassword.setCustomValidity('Les mots de passe ne correspondent pas');
            } else {
                confirmPassword.setCustomValidity('');
            }
        }
        
        password.addEventListener('input', validatePasswords);
        confirmPassword.addEventListener('input', validatePasswords);
        
        // Soumission du formulaire
        registerForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            if (!registerForm.checkValidity()) {
                e.stopPropagation();
                registerForm.classList.add('was-validated');
                return;
            }
            
            // Afficher le chargement
            if (registerLoading) {
                registerLoading.classList.remove('d-none');
            }
            if (registerAlert) {
                registerAlert.classList.add('d-none');
            }
            
            // Préparer les données
            const formData = new FormData(registerForm);
            
            // Envoyer la requête
            fetch('process_register.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (registerLoading) {
                    registerLoading.classList.add('d-none');
                }
                
                if (data.success) {
                    if (registerAlert) {
                        registerAlert.className = 'alert alert-success mt-3';
                        registerAlert.textContent = data.message;
                        registerAlert.classList.remove('d-none');
                    }
                    
                    // Redirection après un délai
                    setTimeout(() => {
                        window.location.href = data.redirect || '/taghtil/visiteur/';
                    }, 2000);
                } else {
                    if (registerAlert) {
                        registerAlert.className = 'alert alert-danger mt-3';
                        registerAlert.textContent = data.message;
                        registerAlert.classList.remove('d-none');
                    }
                }
            })
            .catch(error => {
                if (registerLoading) {
                    registerLoading.classList.add('d-none');
                }
                if (registerAlert) {
                    registerAlert.className = 'alert alert-danger mt-3';
                    registerAlert.textContent = 'Erreur de connexion. Veuillez réessayer.';
                    registerAlert.classList.remove('d-none');
                }
                console.error('Erreur:', error);
            });
        });
    }
});