// Fonctions pour le drag and drop
function allowDrop(ev) {
    ev.preventDefault();
}

function drag(ev) {
    ev.dataTransfer.setData("text", ev.target.id);
    var parent = document.getElementById(ev.target.id).parentNode.id;
    ev.dataTransfer.setData("source", parent);
}

function drop(ev, dest) {
    var source = ev.dataTransfer.getData("source");

    if (source.substr(0, 1) === dest.substr(0, 1)) {
        ev.preventDefault();
        var elementDestination = document.getElementById(dest);
        if (elementDestination.childNodes.length > 1) {
            document.getElementById(source).appendChild(elementDestination.childNodes[1]);
        }

        var data = ev.dataTransfer.getData("text");
        document.getElementById(dest).appendChild(document.getElementById(data));
        if (document.getElementById(source).childNodes.length > 2) {
            document.getElementById(source).removeChild(document.getElementById(source).childNodes[1]);
        }
        if (document.getElementById(dest).childNodes.length > 2) {
            document.getElementById(dest).removeChild(document.getElementById(dest).childNodes[1]);
        }
    }
}