<?php

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
//error_reporting(E_ALL);

// Définir le répertoire racine du projet
$rootDir = dirname(__DIR__);
chdir($rootDir);

// Variables essentielles
$installDontExists = false;
$userConnected = false;

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Récupérer le nom du projet depuis le chemin
$directory = new DirectoryIterator($rootDir);
$path = explode(DIRECTORY_SEPARATOR, $directory->getPath());
$path = $path[count($path) - 1];


// Définir les chemins des fichiers
$installFolder = $rootDir . DIRECTORY_SEPARATOR . 'install';
$configFile = $rootDir . DIRECTORY_SEPARATOR . 'config.php';

// Vérifier si les fichiers essentiels existent
$paramFile = $rootDir . "/Parametre/" . $path . "/" . $path . ".php";
$loadDirFile = $rootDir . "/Parametre/" . $path . "/LoadDirClass.php";
$dbConnectFile = $rootDir . "/Parametre/" . $path . "/dbConnect.php";
$functionFile = $rootDir . "/Classe/FunctionClasse.php";

// Inclusions essentielles
if (file_exists($paramFile)) {
    include $paramFile;
} else {
    die("Erreur: Fichier de paramètres manquant: $paramFile");
}

if (file_exists($loadDirFile)) {
    include $loadDirFile;
} else {
    die("Erreur: Fichier LoadDirClass manquant: $loadDirFile");
}

if (file_exists($dbConnectFile)) {
    include $dbConnectFile;
} else {
    die("Erreur: Fichier dbConnect manquant: $dbConnectFile");
}

if (file_exists($functionFile)) {
    include_once $functionFile;
} else {
    die("Erreur: Fichier FunctionClasse manquant: $functionFile");
}

// Utiliser les namespaces après l'autoload
use Enum\PageSite;
use Classe\NavBar;
use Classe\Login;
use Views\VariousViewsHtml;
use Views\AdminVariousViewsHtml;

extract($_REQUEST, EXTR_PREFIX_ALL | EXTR_REFS, 'v');

// Gestion de la vérification de session AJAX
if (isset($v_page) && $v_page === 'check_session') {
    header('Content-Type: application/json');
    
    $response = ['connected' => false, 'isAdmin' => false];
    
    if (isset($_SESSION[$NomSite]['userConnected']) && $_SESSION[$NomSite]['userConnected']) {
        $response['connected'] = true;
        
        // Vérifier si l'utilisateur est admin
        if (isset($_SESSION[$NomSite]['userRoles'])) {
            $roles = $_SESSION[$NomSite]['userRoles'];
            foreach ($roles as $role) {
                if (isset($role['role_level']) && $role['role_level'] >= 60) {
                    $response['isAdmin'] = true;
                    break;
                }
            }
        }
    }
    
    echo json_encode($response);
    exit;
}

    // Créer une instance pour les vues avec les chemins adaptés
    $variousViews = new AdminVariousViewsHtml();

// Vérifications d'installation
$pathInstallExists = is_dir($installFolder);

if ($pathInstallExists && !file_exists($configFile)) {
    $title = 'Taghilt - Vérification de l\'installation';
    $variousViews->generateHeader(false, false,  $title, 'db');
    $variousViews->showInstallError('pathinstallExists');
    $variousViews->generateFooter(false, false, 'db');
    exit;
} else if (!$pathInstallExists && !file_exists($configFile)) {
    $installDontExists = true;
    $title = 'Taghilt - Erreur d\'installation';
    $variousViews->generateHeader(false, false,  $title, 'db');
    $variousViews->showInstallError('pathinstallnotExists');
    $variousViews->generateFooter(false, false, 'db');
    exit;
} else if ($pathInstallExists && file_exists($configFile)) {
    $title = 'Taghilt - Configuration requise';
    $variousViews->generateHeader(false, false,  $title, 'db');
    $variousViews->showInstallError('renameinstall');
    $variousViews->generateFooter(false, false, 'db');
    exit;
} else if (file_exists($configFile) && !$pathInstallExists) {

    $showParam = defined('SHOW_PARAM') ? SHOW_PARAM : 'false';

    $conn = dbConnect(false);
    if (!$conn) {
        $title = 'Taghilt - Erreur de base de données';
        $userConnected = false;
        $variousViews->generateHeader(false, false,  $title, 'db');
        $variousViews->showMysqlError();
        $variousViews->generateFooter(false, false, 'db');
        exit;
    } else {
        $conn = dbConnect(false);
        if (!isset($v_page)) {
            $v_page = "";
            $pageSite = "";
        } else {
            $pageSite = PageSite::tryFromName($v_page);
            if ($pageSite == "E9999")
                $pageSite = "";
        }
        if (!isset($v_typePage))
            $v_typePage = "";

        // Définir les titres spécifiques pour chaque page
        $pageTitles = [
            'hv' => 'Taghilt - Gestion des Agents Immobiliers',
            'vsts' => 'Taghilt - Gestion des Annonces',
            'dep' => 'Taghilt - Gestion des Départements',
            'page' => 'Taghilt - Gestion des Pages',
            'role' => 'Taghilt - Gestion des Rôles',
            'user' => 'Taghilt - Gestion des Utilisateurs',
            'wdw' => 'Taghilt - Journal d\'Activité',
            'ab' => 'Taghilt - À Propos',
            'msg' => 'Taghilt - Messages et Suggestions',
            'param' => 'Taghilt - Paramètres du Système',
            'po' => 'Taghilt - Gestion des Postes'
        ];

        $title = isset($pageTitles[$v_page]) ? $pageTitles[$v_page] : $NomSiteCap . ' - Administration';

        $connectedHost = getClientHostname();
        
        // Interface admin uniquement
        $login = new Login($conn, $pageSite);
        $userConnected = $login->userConnected;

        // Vérifier si l'utilisateur a les droits administrateur
        if ($userConnected && isset($_SESSION[$NomSite]['userRoles'])) {
            $roles = $_SESSION[$NomSite]['userRoles'];
            $userLevel = 0;
            foreach ($roles as $role) {
                if (isset($role['role_level'])) {
                    $userLevel = max($userLevel, $role['role_level']);
                }
            }
            
            // Si niveau visiteur simple (< 60), rediriger vers interface visiteur
            if ($userLevel < 60) {
                header('Location: ../visiteur/index.php');
                exit;
            }
        }
    }
}

//On vérifie si c'est une borne qui se connecte sur l'application
if (in_array($connectedHost, $BorneMachine)) {
    // Rediriger les bornes vers l'interface visiteur
    header('Location: ../visiteur/index.php');
    exit;
} else {
    // Interface administrateur uniquement (niveau >= 60)
    if ($userConnected) {
        
        if ($v_page == "lsl" || $v_page == "log" || $v_page == "d" || $v_page == "hv") {
            $pageSite = "";
        }

        $useChart = ($useChartMonthly || $useChartYearly) ? true : false;

        $variousViews->generateHeader($useChart, true, $title, 'db');

        if ($showParam === 'true'  && $pageSite != 'param' && !$pathInstallExists && $v_page != 'param') {
            if ($v_page != 'param') {
                header('Location: index.php?page=param');
                exit;
            }
        } else if ($SiteEnMaintenance && !in_array($connectedHost, $AllowedMachineOnMaintenance)) {
            $variousViews->showMaintenance($connectedHost);
        } else {
            $navBar = new NavBar($conn);
            $navBar->getHeader();
            echo '
            <div class="container-fluid-taghilt">
                <div class="row">';
            $navBar->getSideBar();

            if ($pageSite != Null) {
                include($rootDir . "/SitePage/" . $pageSite);
            } else {
                $navBar->getDashBoard($NomSiteCap);
            }
            echo '
                </div>
            </div>';
        }

        $variousViews->generateFooter($useChart, true, 'db');
    } else {
        // Page de connexion administrateur
        $login = new Login($conn, 'log');
    }
}
?>
