<?php
// Initialisation de la page de recherche

use Classe\PublicSearch;
use views\PublicSearchHtml;
use views\PublicHeaderFooter;
use views\SearchBarCompact;

// Vérifier que la connexion existe
if (!isset($conn)) {
    die("Erreur: Connexion à la base de données non disponible");
}

// Gérer la suppression d'un filtre spécifique via POST
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['remove_filter'])) {
    $filterType = $_POST['filter_type'] ?? '';
    $filterValue = $_POST['filter_value'] ?? '';
    
    if (isset($_SESSION['last_search_params'])) {
        if ($filterType === 'city' && !empty($filterValue)) {
            // Supprimer une ville spécifique
            if (isset($_SESSION['last_search_params']['cities'])) {
                $cities = explode(',', $_SESSION['last_search_params']['cities']);
                $cities = array_map('trim', $cities);
                $cities = array_filter($cities, function($city) use ($filterValue) {
                    return trim($city) !== trim($filterValue);
                });
                $_SESSION['last_search_params']['cities'] = implode(',', $cities);
                
                // Mettre à jour city_ids aussi - Trouver et supprimer l'ID correspondant
                if (isset($_SESSION['last_search_params']['city_ids']) && is_array($_SESSION['last_search_params']['city_ids'])) {
                    // Chercher l'ID de la ville supprimée dans la base de données
                    $escapedValue = mysqli_real_escape_string($conn->link_id, $filterValue);
                    $query = "SELECT id FROM localites_algerie WHERE nom = '$escapedValue' LIMIT 1";
                    $conn->exec($query);
                    
                    if (!empty($conn->data) && isset($conn->data[0]['id'])) {
                        $cityIdToRemove = $conn->data[0]['id'];
                        // Supprimer cet ID du tableau city_ids
                        $_SESSION['last_search_params']['city_ids'] = array_filter(
                            $_SESSION['last_search_params']['city_ids'],
                            function($id) use ($cityIdToRemove) {
                                return $id != $cityIdToRemove;
                            }
                        );
                        // Réindexer le tableau
                        $_SESSION['last_search_params']['city_ids'] = array_values($_SESSION['last_search_params']['city_ids']);
                    }
                }
            }
        } elseif ($filterType === 'transaction') {
            unset($_SESSION['last_search_params']['transaction']);
        } elseif ($filterType === 'property') {
            unset($_SESSION['last_search_params']['property']);
        } elseif ($filterType === 'price') {
            unset($_SESSION['last_search_params']['price_min']);
            unset($_SESSION['last_search_params']['price_max']);
        }
    }
    
    echo json_encode(['success' => true]);
    exit;
}

// Gérer l'effacement de tous les filtres
if (isset($_GET['clear_filters']) && $_GET['clear_filters'] == '1') {
    unset($_SESSION['last_search_params']);
    // Si c'est une requête AJAX, juste retourner OK
    if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
        echo json_encode(['success' => true]);
        exit;
    }
}

// Récupérer les paramètres de recherche depuis la session d'abord
$searchParams = $_SESSION['last_search_params'] ?? [];

// Si des paramètres sont dans l'URL, ils écrasent ceux de la session
$hasUrlParams = false;

// Villes (array)
if (isset($_GET['city_ids']) && is_array($_GET['city_ids'])) {
    $searchParams['city_ids'] = array_filter($_GET['city_ids'], 'is_numeric');
    $hasUrlParams = true;
}

// Noms des villes (pour affichage)
if (isset($_GET['cities'])) {
    $searchParams['cities'] = $_GET['cities'];
    $hasUrlParams = true;
}

// Type de transaction
if (isset($_GET['transaction']) && in_array($_GET['transaction'], ['vente', 'location'])) {
    $searchParams['transaction'] = $_GET['transaction'];
    $hasUrlParams = true;
}

// Type de propriété
if (isset($_GET['property'])) {
    $validProperties = ['appartement', 'maison', 'villa', 'terrain', 'local_commercial', 'bureau'];
    if (in_array($_GET['property'], $validProperties)) {
        $searchParams['property'] = $_GET['property'];
        $hasUrlParams = true;
    }
}

// Prix min
if (isset($_GET['price_min']) && is_numeric($_GET['price_min'])) {
    $searchParams['price_min'] = intval($_GET['price_min']);
    $hasUrlParams = true;
}

// Prix max
if (isset($_GET['price_max']) && is_numeric($_GET['price_max'])) {
    $searchParams['price_max'] = intval($_GET['price_max']);
    $hasUrlParams = true;
}

// Page courante pour la pagination (utilise 'p' au lieu de 'page' pour éviter le conflit)
if (isset($_GET['p']) && is_numeric($_GET['p'])) {
    $searchParams['page'] = max(1, intval($_GET['p']));
} else {
    // Si pas de paramètre de pagination, on commence à la page 1
    $searchParams['page'] = 1;
}

// Si on a de nouveaux paramètres de recherche (hasUrlParams), réinitialiser à la page 1
if ($hasUrlParams) {
    $searchParams['page'] = 1;
}

// Sauvegarder les paramètres de recherche en session (seulement si on a des paramètres d'URL)
if ($hasUrlParams || !isset($_SESSION['last_search_params'])) {
    $_SESSION['last_search_params'] = $searchParams;
}

// Créer l'objet de recherche
$searchObj = new PublicSearch($conn);

// Effectuer la recherche
$searchObj->search($searchParams);

// Afficher l'en-tête
PublicHeaderFooter::renderHeader('Recherche de biens immobiliers - Taghilt');

// Afficher la barre de recherche compacte avec le header de résultats intégré
SearchBarCompact::display(
    $searchParams, 
    true, // showHeader
    $searchObj->getSearchTitle(),
    $searchObj->getTotalResults(),
    $searchObj->getActiveFilters()
);

// Lien CSS et JS pour les résultats de recherche
echo '<link rel="stylesheet" href="assets/css/search-results.css">';

// Afficher les résultats
PublicSearchHtml::displaySearchResults($searchObj);

// Script JS pour l'interactivité
echo '<script src="assets/js/search-results.js"></script>';

// Afficher le pied de page
PublicHeaderFooter::renderFooter();
?>
