<?php
// Vérifier qu'on a un ID d'annonce
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: index.php');
    exit;
}

$annonce_id = (int)$_GET['id'];

// Inclure les classes nécessaires
require_once __DIR__ . '/../Classe/AnnonceDetail.php';
require_once __DIR__ . '/../views/AnnonceDetailHtml.php';
require_once __DIR__ . '/../views/SearchBarCompact.php';

use Classe\AnnonceDetail;
use Views\AnnonceDetailHtml;
use Views\PublicHeaderFooter;
use Views\SearchBarCompact;

// Créer l'objet annonce
$annonceObj = new AnnonceDetail($conn);

// Récupérer les données
if (!$annonceObj->getAnnonceById($annonce_id)) {
    // Annonce non trouvée
    PublicHeaderFooter::renderHeader("Annonce introuvable - Taghilt", '');
    AnnonceDetailHtml::displayAnnonceDetail($annonceObj);
    PublicHeaderFooter::renderFooter('');
    exit;
}

// Récupérer les informations pour le titre
$annonce = $annonceObj->getAnnonce();
$pageTitle = htmlspecialchars($annonce['titre']) . " - Taghilt";

// Afficher le header
PublicHeaderFooter::renderHeader($pageTitle, '');

// Récupérer les paramètres de recherche depuis la session
$searchParams = $_SESSION['last_search_params'] ?? [];

// Générer les filtres actifs à partir des paramètres
$activeFilters = [];

if (!empty($searchParams)) {
    // Villes
    if (!empty($searchParams['cities'])) {
        $cities = explode(',', $searchParams['cities']);
        foreach ($cities as $city) {
            $activeFilters[] = [
                'type' => 'city',
                'label' => trim($city),
                'value' => trim($city),
                'removable' => true
            ];
        }
    }
    
    // Transaction
    if (!empty($searchParams['transaction'])) {
        $transactionLabel = $searchParams['transaction'] == '1' ? 'Vente' : 'Location';
        $activeFilters[] = [
            'type' => 'transaction',
            'label' => $transactionLabel,
            'value' => $searchParams['transaction'],
            'removable' => true
        ];
    }
    
    // Type de propriété
    if (!empty($searchParams['property'])) {
        $propertyTypes = [
            '1' => 'Appartement',
            '2' => 'Maison/Villa',
            '3' => 'Villa de luxe',
            '4' => 'Terrain',
            '5' => 'Commerce/Bureau'
        ];
        if (isset($propertyTypes[$searchParams['property']])) {
            $activeFilters[] = [
                'type' => 'property',
                'label' => $propertyTypes[$searchParams['property']],
                'value' => $searchParams['property'],
                'removable' => true
            ];
        }
    }
    
    // Prix
    if (!empty($searchParams['price_min']) || !empty($searchParams['price_max'])) {
        $priceLabel = '';
        if (!empty($searchParams['price_min']) && !empty($searchParams['price_max'])) {
            $priceLabel = number_format($searchParams['price_min'], 0, ',', ' ') . ' - ' . 
                         number_format($searchParams['price_max'], 0, ',', ' ') . ' DA';
        } elseif (!empty($searchParams['price_min'])) {
            $priceLabel = 'À partir de ' . number_format($searchParams['price_min'], 0, ',', ' ') . ' DA';
        } else {
            $priceLabel = 'Jusqu\'à ' . number_format($searchParams['price_max'], 0, ',', ' ') . ' DA';
        }
        $activeFilters[] = [
            'type' => 'price',
            'label' => $priceLabel,
            'value' => 'price_range',
            'removable' => true
        ];
    }
}

// NE PAS afficher la barre de recherche sur la page annonce
// SearchBarCompact::display($searchParams, false, '', 0, $activeFilters);
?>

<!-- Lien CSS spécifique -->
<link rel="stylesheet" href="assets/css/annonce-detail.css">

<!-- Barre de navigation sticky -->
<div class="annonce-nav-bar" id="annonceNavBar">
    <div class="container">
        <div class="d-flex justify-content-between align-items-center">
            <a href="javascript:history.back()" class="btn btn-outline-primary">
                <i class="fas fa-arrow-left me-2"></i>Retour aux résultats
            </a>
            <div class="d-flex gap-2">
                <button class="btn btn-outline-secondary btn-share" onclick="shareAnnonce()">
                    <i class="fas fa-share-alt me-2"></i>Partager
                </button>
                <button class="btn btn-outline-danger btn-favorite-sticky">
                    <i class="far fa-heart me-2"></i>Favori
                </button>
            </div>
        </div>
    </div>
</div>

<?php
// Afficher le contenu
AnnonceDetailHtml::displayAnnonceDetail($annonceObj);

// Afficher le footer
PublicHeaderFooter::renderFooter('');
?>

<!-- JavaScript pour le formulaire de contact -->
<script>
document.getElementById('contact-form')?.addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    // Simuler l'envoi (à implémenter avec AJAX vers un script PHP)
    alert('Votre message a été envoyé ! Le propriétaire vous contactera bientôt.');
    this.reset();
    
    // TODO: Implémenter l'envoi réel via AJAX
    /*
    fetch('api/send-contact.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Message envoyé avec succès !');
            this.reset();
        } else {
            alert('Erreur lors de l\'envoi du message.');
        }
    });
    */
});

// Gestion du bouton favori (dans la sidebar)
document.querySelector('.btn-favorite')?.addEventListener('click', function() {
    toggleFavorite(this);
});

// Gestion du bouton favori sticky
document.querySelector('.btn-favorite-sticky')?.addEventListener('click', function() {
    toggleFavorite(this);
    // Synchroniser avec le bouton de la sidebar
    const sidebarBtn = document.querySelector('.btn-favorite');
    if (sidebarBtn) {
        const icon = sidebarBtn.querySelector('i');
        const stickyIcon = this.querySelector('i');
        if (stickyIcon.classList.contains('fas')) {
            icon.classList.remove('far');
            icon.classList.add('fas');
            sidebarBtn.classList.add('active');
        } else {
            icon.classList.remove('fas');
            icon.classList.add('far');
            sidebarBtn.classList.remove('active');
        }
    }
});

// Fonction pour basculer le favori
function toggleFavorite(btn) {
    const icon = btn.querySelector('i');
    if (icon.classList.contains('far')) {
        icon.classList.remove('far');
        icon.classList.add('fas');
        btn.classList.add('active');
        showNotification('Ajouté aux favoris', 'success');
    } else {
        icon.classList.remove('fas');
        icon.classList.add('far');
        btn.classList.remove('active');
        showNotification('Retiré des favoris', 'info');
    }
}

// Fonction de partage
function shareAnnonce() {
    const url = window.location.href;
    const title = document.title;
    
    if (navigator.share) {
        navigator.share({
            title: title,
            url: url
        }).catch(() => {
            copyToClipboard(url);
        });
    } else {
        copyToClipboard(url);
    }
}

function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(() => {
        showNotification('Lien copié dans le presse-papier', 'success');
    });
}

// Gestion du scroll pour la barre sticky
let lastScroll = 0;
const navBar = document.getElementById('annonceNavBar');

window.addEventListener('scroll', function() {
    const currentScroll = window.pageYOffset;
    
    if (currentScroll > 200) {
        navBar.classList.add('visible');
    } else {
        navBar.classList.remove('visible');
    }
    
    lastScroll = currentScroll;
});

// Mise à jour du compteur de la galerie
const carousel = document.getElementById('mainImageCarousel');
if (carousel) {
    carousel.addEventListener('slide.bs.carousel', function(e) {
        const counter = document.querySelector('.gallery-counter');
        if (counter) {
            const total = document.querySelectorAll('.carousel-item').length;
            counter.textContent = (e.to + 1) + '/' + total;
        }
    });
}

// Fonction de notification
function showNotification(message, type) {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type} position-fixed`;
    notification.style.cssText = 'top: 100px; right: 20px; z-index: 9999; min-width: 250px;';
    notification.innerHTML = `
        <i class="fas fa-${type === 'success' ? 'check-circle' : 'info-circle'} me-2"></i>
        ${message}
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.style.opacity = '0';
        notification.style.transition = 'opacity 0.3s ease';
        setTimeout(() => notification.remove(), 300);
    }, 3000);
}
</script>
