# 🏠 Taghilt - Plateforme Immobilière Algérienne

Plateforme web moderne de gestion et de recherche d'annonces immobilières en Algérie.

## ✨ Fonctionnalités

### 🔍 Recherche Avancée
- **Autocomplete intelligent** : Recherche de villes avec base de données complète des 58 wilayas et 100+ communes d'Algérie
- **Sélection multiple de villes** : Tags interactifs pour sélectionner plusieurs villes
- **Filtres multiples** : Type de transaction (vente/location), type de propriété, fourchette de prix
- **Slider de prix double** : Sélection interactive du budget min/max
- **Résultats paginés** : Affichage moderne avec cartes de propriétés

### 📋 Gestion des Annonces
- Création et modification d'annonces
- Upload de photos multiples
- Géolocalisation des biens
- Mise en avant des annonces premium
- Statistiques de vues et de contacts

### 👥 Gestion des Utilisateurs
- Système d'authentification sécurisé (remember me)
- Rôles et permissions (Admin, Agent, Particulier)
- Profils utilisateurs avec informations détaillées
- Tableau de bord personnalisé

### 🎨 Interface Moderne
- Design responsive (mobile, tablette, desktop)
- Animations fluides
- Formulaire de recherche moderne avec effets
- Interface publique et espace d'administration séparés

## 🛠️ Technologies Utilisées

### Backend
- **PHP 8.2+** : Langage serveur
- **MySQL/MariaDB** : Base de données
- **Architecture MVC** : Organisation du code

### Frontend
- **HTML5/CSS3** : Structure et style
- **JavaScript (ES6+)** : Interactivité
- **jQuery 3.7.1** : Manipulation DOM
- **Bootstrap 5.3** : Framework CSS
- **Font Awesome 6.4** : Icônes

### Bibliothèques JavaScript
- Fetch API pour les requêtes asynchrones
- Debouncing pour l'autocomplete
- Système de tags interactifs

## 📦 Installation

### Prérequis
- XAMPP (ou WAMP/MAMP) avec PHP 8.2+
- MySQL/MariaDB
- Git

### Étapes d'installation

1. **Cloner le dépôt**
```bash
cd C:\xampp\htdocs
git clone https://github.com/VOTRE-USERNAME/taghtil.git
cd taghtil
```

2. **Créer la base de données**
```sql
CREATE DATABASE taghtil CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

3. **Importer les données**
   - Ouvrir phpMyAdmin : `http://localhost/phpmyadmin`
   - Sélectionner la base `taghtil`
   - Importer dans cet ordre :
     1. `src/taghtil.sql` (structure et données de base)
     2. `src/localites_algerie.sql` (base des villes algériennes)
     3. `src/update_annonces_algerie.sql` (mise à jour des annonces)

4. **Configurer la connexion**
   - Copier `config.example.php` vers `config.php`
   - Éditer `config.php` avec vos paramètres de base de données

5. **Accéder à l'application**
   - Public : `http://localhost/taghtil/`
   - Admin : `http://localhost/taghtil/admin/`

## 🗂️ Structure du Projet

```
taghtil/
├── assets/                  # Ressources statiques
│   ├── css/                # Feuilles de style
│   │   ├── search-form-modern.css
│   │   ├── search-results.css
│   │   └── public-style.css
│   ├── js/                 # Scripts JavaScript
│   │   ├── search-form-modern.js
│   │   └── search-results.js
│   └── images/            # Images
├── Classe/                 # Classes PHP (logique métier)
│   ├── PublicIndex.php    # Page d'accueil publique
│   ├── PublicSearch.php   # Moteur de recherche
│   ├── AnnonceClient.php  # Gestion des annonces
│   └── Users.php          # Gestion des utilisateurs
├── views/                  # Vues HTML
│   ├── PublicHomeHtml.php
│   ├── PublicSearchHtml.php
│   └── PublicHeaderFooter.php
├── SitePage/              # Initialisation des pages
│   └── searchInit.php
├── src/                   # Scripts SQL
│   ├── taghtil.sql
│   ├── localites_algerie.sql
│   └── update_annonces_algerie.sql
├── admin/                 # Interface d'administration
├── Parametre/            # Configuration
└── index.php             # Point d'entrée principal
```

## 🎯 Fonctionnalités Principales

### Page d'Accueil
- Hero section avec formulaire de recherche moderne
- Types de propriétés avec images Unsplash
- Section d'annonces récentes
- Footer avec informations de contact

### Système de Recherche
1. **Autocomplete de villes**
   - Recherche instantanée dans la base de données
   - Affichage des wilayas et communes
   - Icônes différenciées par type de localité

2. **Sélection multiple**
   - Tags arrondis avec gradient
   - Suppression individuelle avec animation
   - Vide automatique de l'input après sélection

3. **Filtres de prix**
   - Double slider interactif
   - Boutons de présélection (5M, 10M, 20M, 30M, 50M DA)
   - Affichage formaté (M DA, K DA)

4. **Page de résultats**
   - Grille responsive de cartes
   - Badges (Vente/Location, À la une)
   - Informations détaillées (surface, pièces, chambres, salles de bain)
   - Pagination intelligente
   - Filtres actifs affichés avec suppression

## 🌍 Base de Données des Localités

La plateforme inclut une base de données complète des localités algériennes :
- **58 wilayas** avec coordonnées GPS
- **100+ communes principales** (Alger, Oran, Constantine, etc.)
- Support de la recherche en arabe et français
- Index optimisés pour la recherche rapide

## 🔐 Sécurité

- Échappement des entrées utilisateur
- Protection contre les injections SQL
- Validation des données côté serveur
- Système de sessions sécurisé
- Tokens CSRF pour les formulaires

## 📱 Responsive Design

L'application est entièrement responsive et fonctionne sur :
- 📱 Smartphones (320px et +)
- 📱 Tablettes (768px et +)
- 💻 Ordinateurs (1024px et +)
- 🖥️ Grands écrans (1920px et +)

## 🚀 Améliorations Futures

- [ ] Système de favoris avec base de données
- [ ] Alertes email pour nouvelles annonces
- [ ] Chat en direct entre acheteurs et vendeurs
- [ ] Comparaison de propriétés
- [ ] Carte interactive avec marqueurs
- [ ] Export PDF des annonces
- [ ] Système de notation et avis
- [ ] API REST pour applications mobiles

## 📝 Licence

Ce projet est sous licence MIT. Voir le fichier `LICENSE` pour plus de détails.

## 👨‍💻 Auteur

Développé avec ❤️ pour faciliter la recherche immobilière en Algérie.

## 🤝 Contribution

Les contributions sont les bienvenues ! N'hésitez pas à :
1. Fork le projet
2. Créer une branche (`git checkout -b feature/AmazingFeature`)
3. Commit vos changements (`git commit -m 'Add some AmazingFeature'`)
4. Push vers la branche (`git push origin feature/AmazingFeature`)
5. Ouvrir une Pull Request

## 📞 Support

Pour toute question ou problème, ouvrez une issue sur GitHub.

---

**⭐ Si ce projet vous plaît, n'hésitez pas à lui donner une étoile !**
