<?php

spl_autoload_register(function($class){
    // Gestion des namespaces
    $originalClass = $class;
    $class = str_replace('\\', '/', $class);
    
    // Pour le namespace Views, on mappe vers le dossier views (minuscule)
    if (strpos($class, 'Views/') === 0) {
        $class = str_replace('Views/', 'views/', $class);
    }
    
    // Pour le namespace Classe, on mappe vers le dossier Classe
    if (strpos($class, 'Classe/') === 0) {
        // Garde tel quel
    }
    
    // Pour le namespace Enum, on mappe vers le dossier Enum
    if (strpos($class, 'Enum/') === 0) {
        // Garde tel quel
    }
    
    // Utiliser le chemin relatif plutôt que DOCUMENT_ROOT
    $paths = [
        __DIR__ . '/../../' . $class . '.php',  // Relatif depuis ce fichier
        $class . '.php'  // Relatif depuis le répertoire courant
    ];
    
    foreach ($paths as $path) {
        if(file_exists($path)){
            require $path;
            return;
        }
    }
});
?>
