<?PHP
namespace Enum;

enum PageSite: string{
    case listePageException="log-/lsl-/d";
    case log="log";
    case lsl="lsl";
    case d="d";
    //liste des pages du site
    case hv="visiteurInit.php";
    case vsts="annonceClientInit.php";
    case dep="departementInit.php";
    case page="pagesInit.php";
    case role="rolesInit.php";
    case user="usersInit.php";
    case wdw="writeWhoDidWhatInit.php";
	case ab="about.php";
	case msg="messagesInit.php";
	case param="parametresInit.php";
    Case po="posteInit.php";

    public static function fromName(string $name): string
    {
        foreach (self::cases() as $status) {
            if( $name === $status->name ){
                return $status->value;
            }
        }
        throw new \ValueError("$name is not a valid backing value for enum " . self::class );
    }
    public static function tryFromName(string $name): string|null
    {
        try {
            return self::fromName($name);
        } catch (\ValueError $error) {
            return "E9999";
        }
    }
}
?>
