# 🚀 DÉPLOIEMENT RAPIDE - LISTE DE CONTRÔLE

## ✅ Avant le Déploiement

- [ ] Tous les fichiers sont prêts
- [ ] Base de données créée sur le serveur
- [ ] Identifiants de connexion vérifiés

## 📤 Déploiement

### 1. Upload des Fichiers
```
Uploadez tout le dossier vers:
/home/dzhostco/domains/reoleweb.com/public_html/public/taghilt/
```

### 2. Import Base de Données
```sql
-- Dans phpMyAdmin, sélectionnez: dzhostco_taghilt
-- Puis importez: src/taghilt.sql
```

### 3. Test de Connexion
```
Visitez: https://reoleweb.com/public/taghilt/test_db_connection.php
```

**Résultats attendus:**
- ✅ Config chargé
- ✅ Connexion MySQLi réussie  
- ✅ Connexion dbConnect() réussie
- ✅ Nombre d'annonces affiché

### 4. Test de l'Application
```
Visitez: https://reoleweb.com/public/taghilt/
```

Testez:
- [ ] Page d'accueil s'affiche
- [ ] Recherche fonctionne
- [ ] Détails d'une annonce s'affichent
- [ ] Boutons favoris (modal de connexion)

### 5. Nettoyage
```bash
# Supprimez le fichier de test
rm test_db_connection.php
```

## 🔧 Informations de Connexion

**Base de données:**
- Host: `localhost`
- Database: `dzhostco_taghilt`
- Username: `dzhostco_taghilt`
- Password: `ccGaDyDVQEVf5WyQkstP`

**Configuration:**
Le fichier `config.php` détecte automatiquement l'environnement.

## ❌ En Cas de Problème

### Erreur: "Call to a member function exec() on bool"
→ La connexion DB a échoué. Vérifiez avec `test_db_connection.php`

### Erreur: "config.php introuvable"
→ Assurez-vous que `config.php` est à la racine

### Erreur: "Access denied"
→ Vérifiez les identifiants de connexion dans cPanel

### Erreur: "Table doesn't exist"
→ Importez le fichier SQL: `src/taghilt.sql`

## 📞 Support

Si un problème persiste:
1. Exécutez `test_db_connection.php`
2. Notez les messages d'erreur
3. Vérifiez les logs d'erreur du serveur

## 🎉 Succès!

Une fois tous les tests validés:
- ✅ L'application fonctionne
- ✅ Le fichier de test est supprimé
- ✅ Les logs ne montrent pas d'erreurs
- ✅ Les utilisateurs peuvent naviguer

---

**Temps estimé:** 15-30 minutes
**Dernière mise à jour:** 2 novembre 2025
