# 🚀 Déploiement Rapide - Taghilt

## ✅ Problèmes Résolus

### 1. Migration dupropriodz → taghilt
- ✅ Dossier `Parametre/dupropriodz/` renommé en `Parametre/taghilt/`
- ✅ Tous les chemins d'includes mis à jour
- ✅ Variables et noms de base de données mis à jour
- ✅ Fichier SQL renommé `src/taghilt.sql`

### 2. Fichier Classeconfig.php supprimé
- ✅ `index.php` utilise maintenant `config.php`
- ✅ `process_register.php` utilise maintenant `config.php`
- ⚠️ `Classeconfig.php` ne doit PAS être uploadé sur le serveur

## 📤 Fichiers à Uploader sur le Serveur

### Fichiers Modifiés Récemment
```
index.php
process_register.php
config.php
config_production.php
Classe/PublicIndex.php
Classe/PublicSearch.php
Parametre/taghilt/ (tout le dossier)
api_public.php
test_data.php
connexion_auto.php
test_db_connection.php
```

### ⛔ Fichiers à NE PAS Uploader
```
Classeconfig.php (obsolète)
test_connexion_simple.php (script de test local)
migrate_remember_me.php (migration déjà effectuée)
```

## 🗄️ Base de Données

### Sur le Serveur de Production

1. **Vérifier que la base existe**
   ```sql
   -- Nom de la base : dzhostco_taghilt
   -- Utilisateur : dzhostco_taghilt
   -- Mot de passe : ccGaDyDVQEVf5WyQkstP
   ```

2. **Importer le SQL (si nouvelle installation)**
   ```bash
   mysql -u dzhostco_taghilt -p dzhostco_taghilt < src/taghilt.sql
   ```

3. **Ou mettre à jour (si base existante)**
   - Utilisez phpMyAdmin pour importer uniquement les nouvelles tables/colonnes
   - Ou utilisez les scripts SQL individuels dans `src/`

## 🔧 Configuration Automatique

Le fichier `config.php` détecte automatiquement l'environnement :

### En LOCAL (XAMPP)
```php
DB_HOST = 'localhost'
DB_NAME = 'taghilt'
DB_USER = 'root'
DB_PASS = ''
```

### En PRODUCTION (détecté automatiquement)
```php
DB_HOST = 'localhost'
DB_NAME = 'dzhostco_taghilt'
DB_USER = 'dzhostco_taghilt'
DB_PASS = 'ccGaDyDVQEVf5WyQkstP'
```

**La détection se fait via :**
- `$_SERVER['HTTP_HOST']` contient 'reoleweb.com'
- `$_SERVER['DOCUMENT_ROOT']` commence par '/home/dzhostco/'

## ✅ Checklist de Déploiement

### Avant l'Upload
- [ ] Tester en local : `http://localhost/taghilt/`
- [ ] Vérifier la page de recherche : `http://localhost/taghilt/index.php?page=search`
- [ ] Tester l'inscription
- [ ] Vérifier qu'il n'y a pas d'erreurs PHP

### Pendant l'Upload
- [ ] Uploader tous les fichiers modifiés
- [ ] **NE PAS** uploader `Classeconfig.php`
- [ ] Vérifier que `config.php` est bien uploadé
- [ ] Vérifier les permissions (755 pour dossiers, 644 pour fichiers)

### Après l'Upload
- [ ] Accéder à : `https://reoleweb.com/public/taghilt/`
- [ ] Tester la connexion : `https://reoleweb.com/public/taghilt/test_db_connection.php`
- [ ] Vérifier la page de recherche
- [ ] Tester une annonce
- [ ] **Supprimer** `test_db_connection.php` du serveur

## 🐛 En Cas d'Erreur

### "Failed to open stream: config.php"
→ Assurez-vous que `config.php` est bien à la racine du projet

### "Call to a member function exec() on bool"
→ La connexion DB a échoué. Exécutez `test_db_connection.php` pour diagnostiquer

### "Access denied for user"
→ Vérifiez les identifiants dans cPanel > MySQL Databases

### "Table doesn't exist"
→ Importez le fichier SQL : `src/taghilt.sql`

## 📞 URLs du Site

- **Local** : `http://localhost/taghilt/`
- **Production** : `https://reoleweb.com/public/taghilt/`
- **Admin** : `https://reoleweb.com/public/taghilt/admin/`

---

**Date de dernière mise à jour** : 2 novembre 2025
**Version** : 1.0
